/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.japicmp;

import japicmp.filter.Filter;
import java.io.File;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.champeau.gradle.japicmp.JApiCmpWorkerAction;
import me.champeau.gradle.japicmp.JapiCmpWorkerConfiguration;
import me.champeau.gradle.japicmp.filters.FilterConfiguration;
import me.champeau.gradle.japicmp.report.RichReport;
import me.champeau.gradle.japicmp.report.RuleConfiguration;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class JapicmpTask
extends DefaultTask {
    private List<String> packageIncludes = new ArrayList<String>();
    private List<String> packageExcludes = new ArrayList<String>();
    private List<String> classIncludes = new ArrayList<String>();
    private List<String> classExcludes = new ArrayList<String>();
    private List<String> methodIncludes = new ArrayList<String>();
    private List<String> methodExcludes = new ArrayList<String>();
    private List<String> fieldIncludes = new ArrayList<String>();
    private List<String> fieldExcludes = new ArrayList<String>();
    private List<String> annotationIncludes = new ArrayList<String>();
    private List<String> annotationExcludes = new ArrayList<String>();
    private List<FilterConfiguration> includeFilters = new ArrayList<FilterConfiguration>();
    private List<FilterConfiguration> excludeFilters = new ArrayList<FilterConfiguration>();
    private String accessModifier = "public";
    private boolean onlyModified = false;
    private boolean onlyBinaryIncompatibleModified = false;
    private boolean failOnSourceIncompatibility = false;
    private File xmlOutputFile;
    private File htmlOutputFile;
    private File txtOutputFile;
    private boolean failOnModification = false;
    private boolean includeSynthetic = false;
    private FileCollection oldClasspath;
    private FileCollection newClasspath;
    private FileCollection oldArchives;
    private FileCollection newArchives;
    private boolean ignoreMissingClasses = false;
    private RichReport richReport;

    @TaskAction
    public void exec() {
        WorkerExecutor workerExecutor = (WorkerExecutor)this.getServices().get(WorkerExecutor.class);
        workerExecutor.submit(JApiCmpWorkerAction.class, (Action)new Action<WorkerConfiguration>(){

            public void execute(WorkerConfiguration workerConfiguration) {
                workerConfiguration.setIsolationMode(IsolationMode.PROCESS);
                HashSet classpath = new HashSet();
                if (JapicmpTask.this.includeFilters != null) {
                    for (FilterConfiguration filterConfiguration : JapicmpTask.this.includeFilters) {
                        JapicmpTask.this.addClasspathFor(filterConfiguration.getFilterClass(), classpath);
                    }
                }
                if (JapicmpTask.this.excludeFilters != null) {
                    for (FilterConfiguration filterConfiguration : JapicmpTask.this.excludeFilters) {
                        JapicmpTask.this.addClasspathFor(filterConfiguration.getFilterClass(), classpath);
                    }
                }
                if (JapicmpTask.this.richReport != null) {
                    for (RuleConfiguration ruleConfiguration : JapicmpTask.this.richReport.getRules()) {
                        JapicmpTask.this.addClasspathFor(ruleConfiguration.getRuleClass(), classpath);
                    }
                }
                if (JavaVersion.current().isJava9Compatible()) {
                    classpath.addAll(JapicmpTask.this.resolveJaxb().getFiles());
                }
                workerConfiguration.setClasspath(classpath);
                List baseline = JapicmpTask.this.oldArchives != null ? JapicmpTask.toArchives(JapicmpTask.this.oldArchives) : JapicmpTask.this.inferArchives(JapicmpTask.this.oldClasspath);
                List list = JapicmpTask.this.newArchives != null ? JapicmpTask.toArchives(JapicmpTask.this.newArchives) : JapicmpTask.this.inferArchives(JapicmpTask.this.newClasspath);
                workerConfiguration.setDisplayName("Comparing " + list + " with " + baseline);
                workerConfiguration.params(new Object[]{new JapiCmpWorkerConfiguration(JapicmpTask.this.getIncludeSynthetic(), JapicmpTask.this.getIgnoreMissingClasses(), JapicmpTask.this.getPackageIncludes(), JapicmpTask.this.getPackageExcludes(), JapicmpTask.this.getClassIncludes(), JapicmpTask.this.getClassExcludes(), JapicmpTask.this.getMethodIncludes(), JapicmpTask.this.getMethodExcludes(), JapicmpTask.this.getFieldIncludes(), JapicmpTask.this.getFieldExcludes(), JapicmpTask.this.getAnnotationIncludes(), JapicmpTask.this.getAnnotationExcludes(), JapicmpTask.this.getIncludeFilters(), JapicmpTask.this.getExcludeFilters(), JapicmpTask.toArchives(JapicmpTask.this.getOldClasspath()), JapicmpTask.toArchives(JapicmpTask.this.getNewClasspath()), baseline, list, JapicmpTask.this.getOnlyModified(), JapicmpTask.this.getOnlyBinaryIncompatibleModified(), JapicmpTask.this.getFailOnSourceIncompatibility(), JapicmpTask.this.getAccessModifier(), JapicmpTask.this.getXmlOutputFile(), JapicmpTask.this.getHtmlOutputFile(), JapicmpTask.this.getTxtOutputFile(), JapicmpTask.this.getFailOnModification(), JapicmpTask.this.getProject().getBuildDir(), JapicmpTask.this.richReport)});
            }
        });
    }

    private Configuration resolveJaxb() {
        Project project = this.getProject();
        DependencyHandler dependencies = project.getDependencies();
        return project.getConfigurations().detachedConfiguration(new Dependency[]{dependencies.create((Object)"javax.xml.bind:jaxb-api:2.3.0"), dependencies.create((Object)"com.sun.xml.bind:jaxb-core:2.3.0.1"), dependencies.create((Object)"com.sun.xml.bind:jaxb-impl:2.3.0.1"), dependencies.create((Object)"javax.activation:activation:1.1.1")});
    }

    private void addClasspathFor(Class<?> clazz, Set<File> classpath) {
        ProtectionDomain domain = clazz.getProtectionDomain();
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource != null) {
            try {
                classpath.add(new File(codeSource.getLocation().toURI()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private List<JApiCmpWorkerAction.Archive> inferArchives(FileCollection fc) {
        if (fc instanceof Configuration) {
            ArrayList<JApiCmpWorkerAction.Archive> archives = new ArrayList<JApiCmpWorkerAction.Archive>();
            Set firstLevelModuleDependencies = ((Configuration)fc).getResolvedConfiguration().getFirstLevelModuleDependencies();
            for (ResolvedDependency moduleDependency : firstLevelModuleDependencies) {
                this.collectArchives(archives, moduleDependency);
            }
            return archives;
        }
        return JapicmpTask.toArchives(fc);
    }

    private static List<JApiCmpWorkerAction.Archive> toArchives(FileCollection fc) {
        Set files = fc.getFiles();
        ArrayList<JApiCmpWorkerAction.Archive> archives = new ArrayList<JApiCmpWorkerAction.Archive>(files.size());
        for (File file : files) {
            archives.add(new JApiCmpWorkerAction.Archive(file, "1.0"));
        }
        return archives;
    }

    private void collectArchives(List<JApiCmpWorkerAction.Archive> archives, ResolvedDependency resolvedDependency) {
        String version = resolvedDependency.getModule().getId().getVersion();
        archives.add(new JApiCmpWorkerAction.Archive(((ResolvedArtifact)resolvedDependency.getAllModuleArtifacts().iterator().next()).getFile(), version));
        for (ResolvedDependency dependency : resolvedDependency.getChildren()) {
            this.collectArchives(archives, dependency);
        }
    }

    public void richReport(Action<? super RichReport> configureAction) {
        if (this.richReport == null) {
            this.richReport = new RichReport();
        }
        configureAction.execute((Object)this.richReport);
    }

    @Input
    @Optional
    public List<String> getPackageIncludes() {
        return this.packageIncludes;
    }

    public void setPackageIncludes(List<String> packageIncludes) {
        this.packageIncludes = packageIncludes;
    }

    @Input
    @Optional
    public List<String> getPackageExcludes() {
        return this.packageExcludes;
    }

    public void setPackageExcludes(List<String> packageExcludes) {
        this.packageExcludes = packageExcludes;
    }

    @Input
    @Optional
    public List<String> getClassIncludes() {
        return this.classIncludes;
    }

    public void setClassIncludes(List<String> classIncludes) {
        this.classIncludes = classIncludes;
    }

    @Input
    @Optional
    public List<String> getClassExcludes() {
        return this.classExcludes;
    }

    public void setClassExcludes(List<String> classExcludes) {
        this.classExcludes = classExcludes;
    }

    @Input
    @Optional
    public List<String> getMethodIncludes() {
        return this.methodIncludes;
    }

    public void setMethodIncludes(List<String> methodIncludes) {
        this.methodIncludes = methodIncludes;
    }

    @Input
    @Optional
    public List<String> getMethodExcludes() {
        return this.methodExcludes;
    }

    public void setMethodExcludes(List<String> methodExcludes) {
        this.methodExcludes = methodExcludes;
    }

    @Input
    @Optional
    public List<String> getFieldIncludes() {
        return this.fieldIncludes;
    }

    public void setFieldIncludes(List<String> fieldIncludes) {
        this.fieldIncludes = fieldIncludes;
    }

    @Input
    @Optional
    public List<String> getFieldExcludes() {
        return this.fieldExcludes;
    }

    public void setFieldExcludes(List<String> fieldExcludes) {
        this.fieldExcludes = fieldExcludes;
    }

    @Input
    @Optional
    public List<String> getAnnotationIncludes() {
        return this.annotationIncludes;
    }

    public void setAnnotationIncludes(List<String> annotationIncludes) {
        this.annotationIncludes = annotationIncludes;
    }

    @Input
    @Optional
    public List<String> getAnnotationExcludes() {
        return this.annotationExcludes;
    }

    public void setAnnotationExcludes(List<String> annotationExcludes) {
        this.annotationExcludes = annotationExcludes;
    }

    @Input
    @Optional
    public List<FilterConfiguration> getIncludeFilters() {
        return this.includeFilters;
    }

    public void setIncludeFilters(List<FilterConfiguration> includeFilters) {
        this.includeFilters = includeFilters;
    }

    public void addIncludeFilter(Class<? extends Filter> includeFilterClass) {
        this.includeFilters.add(new FilterConfiguration(includeFilterClass));
    }

    @Input
    @Optional
    public List<FilterConfiguration> getExcludeFilters() {
        return this.excludeFilters;
    }

    public void setExcludeFilters(List<FilterConfiguration> excludeFilters) {
        this.excludeFilters = excludeFilters;
    }

    public void addExcludeFilter(Class<? extends Filter> excludeFilterClass) {
        this.excludeFilters.add(new FilterConfiguration(excludeFilterClass));
    }

    @Input
    @Optional
    public String getAccessModifier() {
        return this.accessModifier;
    }

    public void setAccessModifier(String accessModifier) {
        this.accessModifier = accessModifier;
    }

    @Input
    @Optional
    public boolean getOnlyModified() {
        return this.onlyModified;
    }

    public boolean isOnlyModified() {
        return this.onlyModified;
    }

    public void setOnlyModified(boolean onlyModified) {
        this.onlyModified = onlyModified;
    }

    @Input
    @Optional
    public boolean getOnlyBinaryIncompatibleModified() {
        return this.onlyBinaryIncompatibleModified;
    }

    public boolean isOnlyBinaryIncompatibleModified() {
        return this.onlyBinaryIncompatibleModified;
    }

    public void setOnlyBinaryIncompatibleModified(boolean onlyBinaryIncompatibleModified) {
        this.onlyBinaryIncompatibleModified = onlyBinaryIncompatibleModified;
    }

    @Input
    @Optional
    public boolean getFailOnSourceIncompatibility() {
        return this.failOnSourceIncompatibility;
    }

    public void setFailOnSourceIncompatibility(boolean failOnSourceIncompatibility) {
        this.failOnSourceIncompatibility = failOnSourceIncompatibility;
    }

    @OutputFile
    @Optional
    public File getXmlOutputFile() {
        return this.xmlOutputFile;
    }

    public void setXmlOutputFile(File xmlOutputFile) {
        this.xmlOutputFile = xmlOutputFile;
    }

    @OutputFile
    @Optional
    public File getHtmlOutputFile() {
        return this.htmlOutputFile;
    }

    public void setHtmlOutputFile(File htmlOutputFile) {
        this.htmlOutputFile = htmlOutputFile;
    }

    @OutputFile
    @Optional
    public File getTxtOutputFile() {
        return this.txtOutputFile;
    }

    public void setTxtOutputFile(File txtOutputFile) {
        this.txtOutputFile = txtOutputFile;
    }

    @Input
    @Optional
    public boolean getFailOnModification() {
        return this.failOnModification;
    }

    public boolean isFailOnModification() {
        return this.failOnModification;
    }

    public void setFailOnModification(boolean failOnModification) {
        this.failOnModification = failOnModification;
    }

    @Input
    @Optional
    public boolean getIncludeSynthetic() {
        return this.includeSynthetic;
    }

    public boolean isIncludeSynthetic() {
        return this.includeSynthetic;
    }

    public void setIncludeSynthetic(boolean includeSynthetic) {
        this.includeSynthetic = includeSynthetic;
    }

    @CompileClasspath
    public FileCollection getOldClasspath() {
        return this.oldClasspath;
    }

    public void setOldClasspath(FileCollection oldClasspath) {
        this.oldClasspath = oldClasspath;
    }

    @CompileClasspath
    public FileCollection getNewClasspath() {
        return this.newClasspath;
    }

    public void setNewClasspath(FileCollection newClasspath) {
        this.newClasspath = newClasspath;
    }

    @Optional
    @CompileClasspath
    public FileCollection getOldArchives() {
        return this.oldArchives;
    }

    public void setOldArchives(FileCollection oldArchives) {
        this.oldArchives = oldArchives;
    }

    @Optional
    @CompileClasspath
    public FileCollection getNewArchives() {
        return this.newArchives;
    }

    public void setNewArchives(FileCollection newArchives) {
        this.newArchives = newArchives;
    }

    @Optional
    @Input
    public boolean getIgnoreMissingClasses() {
        return this.ignoreMissingClasses;
    }

    public boolean isIgnoreMissingClasses() {
        return this.ignoreMissingClasses;
    }

    public void setIgnoreMissingClasses(boolean ignoreMissingClasses) {
        this.ignoreMissingClasses = ignoreMissingClasses;
    }

    @Optional
    @Nested
    public RichReport getRichReport() {
        return this.richReport;
    }

    public void setRichReport(RichReport richReport) {
        this.richReport = richReport;
    }
}

