/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.japicmp;

import com.google.common.base.Optional;
import japicmp.cmp.JApiCmpArchive;
import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.config.Options;
import japicmp.filter.JavadocLikePackageFilter;
import japicmp.model.AccessModifier;
import japicmp.model.JApiClass;
import japicmp.output.stdout.StdoutOutputGenerator;
import japicmp.output.xml.XmlOutput;
import japicmp.output.xml.XmlOutputGenerator;
import japicmp.output.xml.XmlOutputGeneratorOptions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import me.champeau.gradle.japicmp.JapiCmpWorkerConfiguration;
import me.champeau.gradle.japicmp.report.CompatibilityChangeViolationRuleConfiguration;
import me.champeau.gradle.japicmp.report.PostProcessRuleConfiguration;
import me.champeau.gradle.japicmp.report.PostProcessViolationsRule;
import me.champeau.gradle.japicmp.report.RichReportData;
import me.champeau.gradle.japicmp.report.RuleConfiguration;
import me.champeau.gradle.japicmp.report.SetupRule;
import me.champeau.gradle.japicmp.report.SetupRuleConfiguration;
import me.champeau.gradle.japicmp.report.Severity;
import me.champeau.gradle.japicmp.report.StatusChangeViolationRuleConfiguration;
import me.champeau.gradle.japicmp.report.Violation;
import me.champeau.gradle.japicmp.report.ViolationRule;
import me.champeau.gradle.japicmp.report.ViolationRuleConfiguration;
import me.champeau.gradle.japicmp.report.ViolationsGenerator;
import org.gradle.api.GradleException;

public class JApiCmpWorkerAction
extends JapiCmpWorkerConfiguration
implements Runnable {
    @Inject
    public JApiCmpWorkerAction(JapiCmpWorkerConfiguration configuration) {
        super(configuration.includeSynthetic, configuration.ignoreMissingClasses, configuration.packageIncludes, configuration.packageExcludes, configuration.oldClasspath, configuration.newClasspath, configuration.oldArchives, configuration.newArchives, configuration.onlyModified, configuration.onlyBinaryIncompatibleModified, configuration.accessModifier, configuration.xmlOutputFile, configuration.htmlOutputFile, configuration.txtOutputFile, configuration.failOnModification, configuration.buildDir, configuration.richReport);
    }

    private JarArchiveComparatorOptions createOptions() {
        JarArchiveComparatorOptions options = new JarArchiveComparatorOptions();
        options.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.TWO_SEPARATE_CLASSPATHS);
        options.setIncludeSynthetic(this.includeSynthetic);
        options.getIgnoreMissingClasses().setIgnoreAllMissingClasses(this.ignoreMissingClasses);
        for (String packageInclude : this.packageIncludes) {
            options.getFilters().getIncludes().add(new JavadocLikePackageFilter(packageInclude));
        }
        for (String packageExclude : this.packageExcludes) {
            options.getFilters().getExcludes().add(new JavadocLikePackageFilter(packageExclude));
        }
        return options;
    }

    @Override
    public void run() {
        JarArchiveComparatorOptions comparatorOptions = this.createOptions();
        JarArchiveComparator jarArchiveComparator = new JarArchiveComparator(comparatorOptions);
        this.generateOutput(jarArchiveComparator);
    }

    private static String prettyPrint(List<JApiCmpArchive> archives) {
        StringBuilder sb = new StringBuilder();
        for (JApiCmpArchive archive : archives) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(archive.getFile().getName());
        }
        return sb.toString();
    }

    private static List<JApiCmpArchive> toJapiCmpArchives(List<Archive> archives) {
        ArrayList<JApiCmpArchive> out = new ArrayList<JApiCmpArchive>(archives.size());
        for (Archive archive : archives) {
            out.add(archive.toJapicmpArchive());
        }
        return out;
    }

    private static String toClasspath(List<Archive> archives) {
        StringBuilder sb = new StringBuilder();
        for (Archive archive : archives) {
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(archive.file.getAbsolutePath());
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void generateOutput(JarArchiveComparator jarArchiveComparator) {
        Options options = Options.newDefault();
        options.setOldClassPath(Optional.of((Object)JApiCmpWorkerAction.toClasspath(this.oldClasspath)));
        options.setNewClassPath(Optional.of((Object)JApiCmpWorkerAction.toClasspath(this.newClasspath)));
        List<JApiCmpArchive> baseline = JApiCmpWorkerAction.toJapiCmpArchives(this.oldArchives);
        List<JApiCmpArchive> current = JApiCmpWorkerAction.toJapiCmpArchives(this.newArchives);
        List jApiClasses = jarArchiveComparator.compare(baseline, current);
        options.setOutputOnlyModifications(this.onlyModified);
        options.setOutputOnlyBinaryIncompatibleModifications(this.onlyBinaryIncompatibleModified);
        options.setIncludeSynthetic(this.includeSynthetic);
        options.setAccessModifier(AccessModifier.valueOf((String)this.accessModifier.toUpperCase()));
        File reportFile = null;
        if (this.xmlOutputFile != null) {
            options.setXmlOutputFile(Optional.of((Object)this.xmlOutputFile.getAbsolutePath()));
            reportFile = this.xmlOutputFile;
        }
        if (this.htmlOutputFile != null) {
            options.setHtmlOutputFile(Optional.of((Object)this.htmlOutputFile.getAbsolutePath()));
            reportFile = this.htmlOutputFile;
        }
        if (this.xmlOutputFile != null || this.htmlOutputFile != null) {
            XmlOutputGeneratorOptions xmlOptions = new XmlOutputGeneratorOptions();
            XmlOutputGenerator xmlOutputGenerator = new XmlOutputGenerator(jApiClasses, options, xmlOptions);
            XmlOutput xmlOutput = xmlOutputGenerator.generate();
            XmlOutputGenerator.writeToFiles((Options)options, (XmlOutput)xmlOutput);
        }
        if (this.txtOutputFile != null) {
            StdoutOutputGenerator stdoutOutputGenerator = new StdoutOutputGenerator(options, jApiClasses);
            String output = stdoutOutputGenerator.generate();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.txtOutputFile), "utf-8"));){
                writer.write(output);
            }
            catch (IOException ex) {
                throw new GradleException("Unable to write report", (Throwable)ex);
            }
            if (reportFile == null) {
                reportFile = this.txtOutputFile;
            }
        }
        boolean hasCustomViolations = false;
        if (this.richReport != null) {
            File file;
            List<String> includedClasses = this.richReport.getIncludedClasses();
            List<String> excludedClasses = this.richReport.getExcludedClasses();
            ViolationsGenerator generator = new ViolationsGenerator(includedClasses, excludedClasses);
            List<RuleConfiguration> rules = this.richReport.getRules();
            for (RuleConfiguration ruleConfiguration : rules) {
                Map<String, String> map = ruleConfiguration.getArguments();
                Class ruleClass = ruleConfiguration.getRuleClass();
                try {
                    Object rule;
                    Object t = rule = map == null ? ruleClass.newInstance() : ruleClass.getConstructor(Map.class).newInstance(map);
                    if (ruleConfiguration.getClass() == SetupRuleConfiguration.class) {
                        generator.addRule((SetupRule)rule);
                        continue;
                    }
                    if (ruleConfiguration.getClass() == PostProcessRuleConfiguration.class) {
                        generator.addRule((PostProcessViolationsRule)rule);
                        continue;
                    }
                    if (ruleConfiguration.getClass() == ViolationRuleConfiguration.class) {
                        generator.addRule((ViolationRule)rule);
                        continue;
                    }
                    if (ruleConfiguration.getClass() == StatusChangeViolationRuleConfiguration.class) {
                        generator.addRule(((StatusChangeViolationRuleConfiguration)ruleConfiguration).getStatus(), (ViolationRule)rule);
                        continue;
                    }
                    if (ruleConfiguration.getClass() != CompatibilityChangeViolationRuleConfiguration.class) continue;
                    generator.addRule(((CompatibilityChangeViolationRuleConfiguration)ruleConfiguration).getChange(), (ViolationRule)rule);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new GradleException("Unable to instantiate rule", (Throwable)e);
                }
            }
            if (this.richReport.isAddDefaultRules()) {
                generator.addDefaultRules();
            }
            Map<String, List<Violation>> violations = generator.toViolations(jApiClasses);
            for (List<Violation> list : violations.values()) {
                for (Violation violation : list) {
                    if (!violation.getSeverity().equals((Object)Severity.error)) continue;
                    hasCustomViolations = true;
                    break;
                }
                if (!hasCustomViolations) continue;
                break;
            }
            if ((file = this.richReport.getDestinationDir()) == null) {
                File file2 = new File(this.buildDir, "reports");
            }
            try {
                void var13_24;
                reportFile = new File((File)var13_24, this.richReport.getReportName());
                this.richReport.getRenderer().newInstance().render(reportFile, new RichReportData(this.richReport.getTitle(), this.richReport.getDescription(), violations));
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new GradleException("Unable to create renderer", (Throwable)reflectiveOperationException);
            }
        }
        if (this.failOnModification && JApiCmpWorkerAction.hasBreakingChange(jApiClasses) || hasCustomViolations) {
            String reportLink;
            try {
                reportLink = reportFile != null ? new URI("file", "", reportFile.toURI().getPath(), null, null).toString() : null;
            }
            catch (URISyntaxException e) {
                reportLink = null;
            }
            StringBuilder message = new StringBuilder("Detected binary changes between ").append(JApiCmpWorkerAction.prettyPrint(current)).append(" and ").append(JApiCmpWorkerAction.prettyPrint(baseline));
            if (reportLink != null) {
                message.append(". See failure report at ").append(reportLink);
            }
            throw new GradleException(message.toString());
        }
    }

    private static boolean hasBreakingChange(List<JApiClass> jApiClasses) {
        for (JApiClass jApiClass : jApiClasses) {
            if (jApiClass.isBinaryCompatible()) continue;
            return true;
        }
        return false;
    }

    public static class Archive
    implements Serializable {
        private final File file;
        private final String version;

        public Archive(File file, String version) {
            this.file = file;
            this.version = version;
        }

        public String toString() {
            return this.file.getName();
        }

        public JApiCmpArchive toJapicmpArchive() {
            return new JApiCmpArchive(this.file, this.version);
        }
    }
}

