/*
 * Decompiled with CFR 0.152.
 */
package me.caibou.rockerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Region;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import me.caibou.rockerview.R;

public abstract class RockerView
extends View {
    public static final int ACTION_PRESSED = 1;
    public static final int ACTION_MOVE = 0;
    public static final int ACTION_RELEASE = -1;
    private Region edgeRegion = new Region();
    private Point centerPoint = new Point();
    private int radius;

    public RockerView(Context context) {
        this(context, null);
    }

    public RockerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RockerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeData(context, attrs);
        this.initialTouchRange();
    }

    private void initializeData(Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RockerView);
        this.radius = typedArray.getDimensionPixelSize(R.styleable.RockerView_edge_radius, 200);
        typedArray.recycle();
        this.centerPoint.x = this.radius;
        this.centerPoint.y = this.radius;
    }

    private void initialTouchRange() {
        Path edgeRulePath = new Path();
        edgeRulePath.addCircle((float)this.centerPoint.x, (float)this.centerPoint.y, (float)this.radius, Path.Direction.CW);
        Region globalRegion = new Region(this.centerPoint.x - this.radius, this.centerPoint.y - this.radius, this.centerPoint.x + this.radius, this.centerPoint.y + this.radius);
        this.edgeRegion.setPath(edgeRulePath, globalRegion);
    }

    private double calculateAngle(float dx, float dy) {
        double degrees = Math.toDegrees(Math.atan2(dy, dx));
        return degrees < 0.0 ? Math.floor(degrees + 360.0) : degrees;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        float x = event.getX();
        float y = event.getY();
        double angle = this.calculateAngle(x - (float)this.centerPoint.x, y - (float)this.centerPoint.y);
        switch (action) {
            case 0: {
                if (!this.edgeRegion.contains((int)x, (int)y)) break;
                this.actionDown(x, y, angle);
                return true;
            }
            case 2: {
                this.actionMove(x, y, angle);
                break;
            }
            case 1: 
            case 3: {
                this.actionUp(x, y, angle);
            }
        }
        return super.onTouchEvent(event);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int sideLength = this.radius * 2;
        this.setMeasuredDimension(sideLength, sideLength);
    }

    public Point centerPoint() {
        return new Point(this.centerPoint);
    }

    protected void actionDown(float x, float y, double angle) {
    }

    protected void actionMove(float x, float y, double angle) {
    }

    protected void actionUp(float x, float y, double angle) {
    }
}

