/*
 * Decompiled with CFR 0.152.
 */
package me.caibou.rockerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Region;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import me.caibou.rockerview.R;
import me.caibou.rockerview.RockerView;

public class JoystickView
extends RockerView {
    private Region ballRegion;
    private Region invalidRegion;
    private Paint paint = new Paint();
    private Point center;
    private int edgeRadius;
    private int stickRadius;
    private int dr;
    private float stickX;
    private float stickY;
    private int stickBallColor;
    private OnAngleUpdateListener angleUpdateListener;

    public JoystickView(Context context) {
        this(context, null);
    }

    public JoystickView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JoystickView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialAttr(context, attrs);
        this.initialData();
    }

    private void initialAttr(Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.JoystickView);
        this.edgeRadius = typedArray.getDimensionPixelSize(R.styleable.JoystickView_edge_radius, 200);
        this.stickRadius = typedArray.getDimensionPixelSize(R.styleable.JoystickView_stick_radius, this.edgeRadius / 2);
        this.stickBallColor = typedArray.getColor(R.styleable.JoystickView_stick_color, this.getResources().getColor(R.color.stick_default_color));
        typedArray.recycle();
    }

    private void initialData() {
        this.dr = this.edgeRadius - this.stickRadius;
        this.center = this.centerPoint();
        this.stickX = this.center.x;
        this.stickY = this.center.y;
        Region ballRegionClip = new Region(this.center.x - this.dr, this.center.y - this.dr, this.center.x + this.dr, this.center.y + this.dr);
        Path rockerRulePath = new Path();
        rockerRulePath.addCircle((float)this.center.x, (float)this.center.y, (float)this.dr, Path.Direction.CW);
        this.ballRegion = new Region();
        this.ballRegion.setPath(rockerRulePath, ballRegionClip);
        int invalidRadius = this.edgeRadius / 3;
        Region invalidRegionClip = new Region(this.center.x - invalidRadius, this.center.y - invalidRadius, this.center.x + invalidRadius, this.center.y + invalidRadius);
        Path eventInvalidPath = new Path();
        eventInvalidPath.addCircle((float)this.center.x, (float)this.center.y, (float)invalidRadius, Path.Direction.CW);
        this.invalidRegion = new Region();
        this.invalidRegion.setPath(eventInvalidPath, invalidRegionClip);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawColor(0);
        this.drawRockerEdge(canvas);
        this.drawStickBall(canvas);
    }

    protected void drawRockerEdge(Canvas canvas) {
        this.paint.reset();
        this.paint.setColor(-16777216);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(2.0f);
        canvas.drawCircle((float)this.center.x, (float)this.center.y, (float)this.edgeRadius, this.paint);
    }

    protected void drawStickBall(Canvas canvas) {
        this.paint.reset();
        this.paint.setColor(this.stickBallColor);
        this.paint.setStyle(Paint.Style.FILL);
        canvas.drawCircle(this.stickX, this.stickY, (float)this.stickRadius, this.paint);
    }

    private void updateStickPos(float x, float y) {
        if (this.ballRegion.contains((int)x, (int)y)) {
            this.stickX = x;
            this.stickY = y;
        } else {
            float dx = x - (float)this.center.x;
            float dy = y - (float)this.center.y;
            float scale = (float)Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
            this.stickX = dx * (float)this.dr / scale + (float)this.center.x;
            this.stickY = dy * (float)this.dr / scale + (float)this.center.y;
        }
        this.invalidate();
    }

    private void resetStick() {
        this.stickX = this.center.x;
        this.stickY = this.center.y;
        this.invalidate();
    }

    private void updateAngle(double angle, int action) {
        if (this.angleUpdateListener != null) {
            this.angleUpdateListener.onAngleUpdate(angle, action);
        }
    }

    @Override
    protected void actionDown(float x, float y, double angle) {
        this.updateStickPos(x, y);
        if (!this.invalidRegion.contains((int)x, (int)y)) {
            this.updateAngle(angle, 1);
        }
    }

    @Override
    protected void actionMove(float x, float y, double angle) {
        this.updateStickPos(x, y);
        if (!this.invalidRegion.contains((int)x, (int)y)) {
            this.updateAngle(angle, 0);
        }
    }

    @Override
    protected void actionUp(float x, float y, double angle) {
        this.resetStick();
        this.updateAngle(angle, -1);
    }

    public void setAngleUpdateListener(OnAngleUpdateListener angleUpdateListener) {
        this.angleUpdateListener = angleUpdateListener;
    }

    public static interface OnAngleUpdateListener {
        public void onAngleUpdate(double var1, int var3);
    }
}

