/*
 * Decompiled with CFR 0.152.
 */
package me.caibou.rockerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.Region;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import me.caibou.rockerview.R;
import me.caibou.rockerview.RockerView;
import me.caibou.rockerview.Utils;

public class DirectionView
extends RockerView {
    private static final int INSIDE_CIRCLE_RADIUS = 30;
    private static final int INDICATOR_SWEEP_ANGLE = 90;
    private boolean pressedStatus = false;
    private int edgeRadius;
    private int buttonRadius;
    private int sideWidth;
    private int indicatorColor;
    private float startAngle;
    private Region invalidRegion = new Region();
    private Point centerPoint = new Point();
    private Paint paint = new Paint();
    private Path directPath;
    private RectF indicatorRect;
    private DirectionChangeListener directionChangeListener;

    public DirectionView(Context context) {
        this(context, null);
    }

    public DirectionView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DirectionView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialAttr(context, attrs);
        this.initialData();
        this.resetInvalidRegion();
    }

    private void initialAttr(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.DirectionView);
        this.buttonRadius = typedArray.getDimensionPixelSize(R.styleable.DirectionView_button_outside_circle_radius, 180);
        this.edgeRadius = typedArray.getDimensionPixelSize(R.styleable.DirectionView_edge_radius, 200);
        this.sideWidth = typedArray.getDimensionPixelSize(R.styleable.DirectionView_button_side_width, 120);
        this.indicatorColor = typedArray.getColor(R.styleable.DirectionView_indicator_color, -16711936);
        typedArray.recycle();
    }

    private void initialData() {
        int sideLengthOfCenter = (int)Math.sqrt(Math.pow(this.buttonRadius, 2.0) - Math.pow(this.sideWidth / 2, 2.0));
        int sideLength = sideLengthOfCenter - this.sideWidth / 2;
        this.centerPoint = this.centerPoint();
        this.directPath = new Path();
        this.directPath.moveTo((float)(-sideLengthOfCenter + this.centerPoint.x), (float)(-this.sideWidth / 2 + this.centerPoint.y));
        this.directPath.rLineTo((float)sideLength, 0.0f);
        this.directPath.rLineTo(0.0f, (float)(-sideLength));
        this.directPath.rLineTo((float)this.sideWidth, 0.0f);
        this.directPath.rLineTo(0.0f, (float)sideLength);
        this.directPath.rLineTo((float)sideLength, 0.0f);
        this.directPath.rLineTo(0.0f, (float)this.sideWidth);
        this.directPath.rLineTo((float)(-sideLength), 0.0f);
        this.directPath.rLineTo(0.0f, (float)sideLength);
        this.directPath.rLineTo((float)(-this.sideWidth), 0.0f);
        this.directPath.rLineTo(0.0f, (float)(-sideLength));
        this.directPath.rLineTo((float)(-sideLength), 0.0f);
        this.directPath.rLineTo(0.0f, (float)(-this.sideWidth));
        this.directPath.addCircle((float)this.centerPoint.x, (float)this.centerPoint.y, 30.0f, Path.Direction.CW);
        this.indicatorRect = new RectF();
        this.indicatorRect.set((float)(this.centerPoint.x - 30), (float)(this.centerPoint.y - 30), (float)(this.centerPoint.x + 30), (float)(this.centerPoint.y + 30));
    }

    private void resetInvalidRegion() {
        int invalidRadius = this.edgeRadius / 3;
        Region invalidRegionClip = new Region(this.centerPoint.x - invalidRadius, this.centerPoint.y - invalidRadius, this.centerPoint.x + invalidRadius, this.centerPoint.y + invalidRadius);
        Path eventInvalidPath = new Path();
        eventInvalidPath.addCircle((float)this.centerPoint.x, (float)this.centerPoint.y, (float)invalidRadius, Path.Direction.CW);
        this.invalidRegion.setPath(eventInvalidPath, invalidRegionClip);
    }

    protected void onDraw(Canvas canvas) {
        this.drawEdge(canvas);
        this.drawDirectButton(canvas);
        if (this.pressedStatus) {
            this.drawIndicator(canvas);
        }
    }

    protected void drawEdge(Canvas canvas) {
        this.paint.reset();
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(-16777216);
        canvas.drawCircle((float)this.centerPoint.x, (float)this.centerPoint.y, (float)this.edgeRadius, this.paint);
    }

    protected void drawDirectButton(Canvas canvas) {
        this.paint.reset();
        this.paint.setColor(-1);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(5.0f);
        this.paint.setAntiAlias(true);
        canvas.drawPath(this.directPath, this.paint);
    }

    protected void drawIndicator(Canvas canvas) {
        this.paint.reset();
        this.paint.setColor(this.indicatorColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(20.0f);
        canvas.drawArc(this.indicatorRect, this.startAngle, 90.0f, false, this.paint);
    }

    @Override
    protected void actionDown(float x, float y, double angle) {
        this.pressedStatus = true;
        if (!this.invalidRegion.contains((int)x, (int)y)) {
            this.updateIndicator(angle);
        }
    }

    @Override
    protected void actionMove(float x, float y, double angle) {
        if (!this.invalidRegion.contains((int)x, (int)y)) {
            this.updateIndicator(angle);
        }
    }

    @Override
    protected void actionUp(float x, float y, double angle) {
        this.resetIndicator();
        this.notifyDirection(Direction.NONE);
    }

    private void resetIndicator() {
        this.pressedStatus = false;
        this.invalidate();
    }

    private void updateIndicator(double angle) {
        if (Utils.range(angle, 337.5, 360.0) || Utils.range(angle, 0.0, 22.5)) {
            this.startAngle = 315.0f;
            this.notifyDirection(Direction.RIGHT);
        } else if (Utils.range(angle, 22.5, 67.5)) {
            this.startAngle = 0.0f;
            this.notifyDirection(Direction.DOWN_AND_RIGHT);
        } else if (Utils.range(angle, 67.5, 112.5)) {
            this.startAngle = 45.0f;
            this.notifyDirection(Direction.DOWN);
        } else if (Utils.range(angle, 112.5, 157.5)) {
            this.startAngle = 90.0f;
            this.notifyDirection(Direction.DOWN_AND_LEFT);
        } else if (Utils.range(angle, 157.5, 202.5)) {
            this.startAngle = 135.0f;
            this.notifyDirection(Direction.LEFT);
        } else if (Utils.range(angle, 202.5, 247.5)) {
            this.startAngle = 180.0f;
            this.notifyDirection(Direction.UP_AND_LEFT);
        } else if (Utils.range(angle, 247.5, 292.5)) {
            this.startAngle = 225.0f;
            this.notifyDirection(Direction.UP);
        } else if (Utils.range(angle, 292.5, 337.5)) {
            this.startAngle = 270.0f;
            this.notifyDirection(Direction.UP_AND_RIGHT);
        }
        this.invalidate();
    }

    private void notifyDirection(Direction direction) {
        if (this.directionChangeListener != null) {
            this.directionChangeListener.onDirectChange(direction);
        }
    }

    public void setDirectionChangeListener(DirectionChangeListener directionChangeListener) {
        this.directionChangeListener = directionChangeListener;
    }

    public static interface DirectionChangeListener {
        public void onDirectChange(Direction var1);
    }

    public static enum Direction {
        NONE,
        UP,
        DOWN,
        LEFT,
        RIGHT,
        UP_AND_LEFT,
        UP_AND_RIGHT,
        DOWN_AND_LEFT,
        DOWN_AND_RIGHT;

    }
}

