/*
 * Decompiled with CFR 0.152.
 */
package macaca.client.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import macaca.client.common.MacacaDriver;
import macaca.client.model.JsonwireErrors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class Utils {
    private final Log log = LogFactory.getLog(this.getClass());
    private HttpGet httpget = null;
    private HttpPost httppost = null;
    private HttpDelete httpdelete = null;
    private CloseableHttpClient httpclient = HttpClients.createDefault();
    private CloseableHttpResponse response = null;
    private HttpEntity entity = null;
    private StringEntity stringEntity = null;
    private JSONObject jsonResponse = null;
    private String stringResponse = "";
    private MacacaDriver driver;

    public Utils(MacacaDriver driver) {
        this.driver = driver;
    }

    private void printResponse(String stringResponse) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (stringResponse.length() > 400) {
            System.out.println(df.format(new Date()) + " Response:" + stringResponse.substring(0, 400) + "...more response is ignored..");
        } else {
            System.out.println(df.format(new Date()) + " Response:" + stringResponse);
        }
    }

    private void printRequest(String stringRequest) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(df.format(new Date()) + " Request:" + stringRequest);
    }

    public Object getRequest(String method, JSONObject jsonBody) throws Exception {
        for (String key : jsonBody.keySet()) {
            String value = jsonBody.get((Object)key).toString();
            method = method.replace(":" + key, value);
        }
        try {
            String url = "http://${host}:${port}/wd/hub/".replace("${host}", this.driver.getHost()).replace("${port}", this.driver.getPort()) + method;
            this.printRequest(url);
            this.httpget = new HttpGet(url);
            this.response = this.httpclient.execute((HttpUriRequest)this.httpget);
            this.entity = this.response.getEntity();
            if (this.entity != null) {
                this.stringResponse = EntityUtils.toString((HttpEntity)this.entity);
                this.printResponse(this.stringResponse);
                this.jsonResponse = JSON.parseObject((String)this.stringResponse);
                this.handleStatus(this.jsonResponse.getInteger("status"));
                return this.jsonResponse.get((Object)"value");
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object postRequest(String method, JSONObject jsonBody) throws Exception {
        JSONObject tempObj = new JSONObject();
        for (String key : jsonBody.keySet()) {
            String value = jsonBody.get((Object)key).toString();
            if (method.contains(":" + key)) {
                method = method.replace(":" + key, value);
                continue;
            }
            tempObj.put(key, jsonBody.get((Object)key));
        }
        try {
            String url = "http://${host}:${port}/wd/hub/".replace("${host}", this.driver.getHost()).replace("${port}", this.driver.getPort()) + method;
            this.httppost = new HttpPost(url);
            if (jsonBody != null) {
                this.stringEntity = new StringEntity(tempObj.toString(), "utf-8");
                this.stringEntity.setContentEncoding("utf-8");
                this.stringEntity.setContentType("application/json");
                this.httppost.setEntity((HttpEntity)this.stringEntity);
            }
            this.printRequest(url + ":" + tempObj.toString());
            this.response = this.httpclient.execute((HttpUriRequest)this.httppost);
            this.entity = this.response.getEntity();
            if (this.entity != null) {
                this.stringResponse = EntityUtils.toString((HttpEntity)this.entity);
                this.printResponse(this.stringResponse);
                this.jsonResponse = JSON.parseObject((String)this.stringResponse);
                this.handleStatus(this.jsonResponse.getInteger("status"));
                return this.jsonResponse;
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object deleteRequest(String method, JSONObject jsonBody) throws Exception {
        for (String key : jsonBody.keySet()) {
            String value = jsonBody.get((Object)key).toString();
            method = method.replace(":" + key, value);
        }
        String url = "http://${host}:${port}/wd/hub/".replace("${host}", this.driver.getHost()).replace("${port}", this.driver.getPort()) + method;
        this.httpdelete = new HttpDelete(url);
        this.response = this.httpclient.execute((HttpUriRequest)this.httpdelete);
        this.entity = this.response.getEntity();
        System.out.println(this.response.getStatusLine().getStatusCode());
        if (this.entity != null) {
            String stringResponse = EntityUtils.toString((HttpEntity)this.entity);
            this.printResponse(stringResponse);
            this.jsonResponse = JSON.parseObject((String)stringResponse);
            this.handleStatus(this.jsonResponse.getInteger("status"));
            return this.jsonResponse;
        }
        return null;
    }

    public Object request(String method, String url, JSONObject jsonObj) throws Exception {
        if (method.toUpperCase() == "GET") {
            return this.getRequest(url, jsonObj);
        }
        if (method.toUpperCase() == "POST") {
            return this.postRequest(url, jsonObj);
        }
        if (method.toUpperCase() == "DELETE") {
            return this.deleteRequest(url, jsonObj);
        }
        return null;
    }

    public void handleStatus(int statusCode) throws Exception {
        JsonwireErrors jsonwireErrors = new JsonwireErrors();
        Map<Integer, String> map = jsonwireErrors.getStatusMap();
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            if (entry.getKey() != statusCode) continue;
            if (statusCode == 0) break;
            throw new Exception(entry.getValue());
        }
    }

    public String getStatus(String method) throws Exception {
        try {
            String url = "http://${host}:${port}/wd/hub/".replace("${host}", this.driver.getHost()).replace("${port}", this.driver.getPort()) + method;
            this.httpget = new HttpGet(url);
            this.response = this.httpclient.execute((HttpUriRequest)this.httpget);
            this.entity = this.response.getEntity();
            return String.valueOf(this.response.getStatusLine().getStatusCode());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "get server status error";
    }
}

