/*
 * Decompiled with CFR 0.152.
 */
package macaca.client.commands;

import com.alibaba.fastjson.JSONObject;
import macaca.client.common.MacacaDriver;
import macaca.client.common.Utils;

public class Session {
    private MacacaDriver driver;
    private Utils utils;

    public Session(MacacaDriver driver) {
        this.driver = driver;
        this.utils = new Utils(driver);
    }

    public void createSession(JSONObject jsonObj) throws Exception {
        if (jsonObj.get((Object)"host") != null && jsonObj.get((Object)"port") != null) {
            String host = (String)jsonObj.get((Object)"host");
            int port = (Integer)jsonObj.get((Object)"port");
            this.driver.setRemote(host, port);
        }
        if (System.getenv("MACACA_UDID") != null) {
            jsonObj.put("udid", (Object)System.getenv("MACACA_UDID"));
        }
        if (System.getenv("MACACA_APP_NAME") != null) {
            jsonObj.put("package", (Object)System.getenv("MACACA_APP_NAME"));
        }
        System.out.print(jsonObj.toString());
        JSONObject response = (JSONObject)this.utils.request("POST", "session", jsonObj);
        String sessionId = (String)response.get((Object)"sessionId");
        this.driver.setSessionId(sessionId);
        this.driver.setCapabilities(response);
    }

    public void delSession() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionId", (Object)this.driver.getSessionId());
        this.utils.request("DELETE", "session/:sessionId", jsonObject);
    }

    public JSONObject sessionAvailable() throws Exception {
        return this.driver.getCapabilities();
    }
}

