/*
 * Decompiled with CFR 0.152.
 */
package macaca.client.commands;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import macaca.client.common.MacacaDriver;
import macaca.client.common.Utils;

public class Element {
    private MacacaDriver driver;
    private Utils utils;
    private Boolean globalTap;

    public Element(MacacaDriver driver) {
        this.driver = driver;
        this.globalTap = false;
        this.utils = new Utils(driver);
    }

    public void sendKeys(String keys) throws Exception {
        JSONObject jsonObject = new JSONObject();
        ArrayList<String> values = new ArrayList<String>();
        values.add(keys);
        jsonObject.put("value", values);
        this.setValue(jsonObject);
    }

    public void setValue(JSONObject jsonObject) throws Exception {
        jsonObject.put("sessionId", (Object)this.driver.getSessionId());
        jsonObject.put("elementId", (Object)this.driver.getElementId());
        this.utils.request("POST", "session/:sessionId/element/:elementId/value", jsonObject);
    }

    public void click() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionId", (Object)this.driver.getSessionId());
        if (!this.globalTap.booleanValue()) {
            jsonObject.put("elementId", (Object)this.driver.getElementId());
            this.utils.request("POST", "session/:sessionId/element/:elementId/click", jsonObject);
        } else {
            this.utils.request("POST", "session/:sessionId/click", jsonObject);
            this.globalTap = false;
        }
    }

    public boolean hasElement(JSONObject jsonObject) throws Exception {
        jsonObject.put("sessionId", (Object)this.driver.getSessionId());
        JSONObject response = (JSONObject)this.utils.request("POST", "session/:sessionId/element", jsonObject);
        JSONObject element = (JSONObject)response.get((Object)"value");
        Object elementId = element.get((Object)"ELEMENT");
        return elementId != null;
    }

    public String getText() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionId", (Object)this.driver.getSessionId());
        jsonObject.put("elementId", (Object)this.driver.getElementId());
        String text = (String)this.utils.request("GET", "session/:sessionId/element/:elementId/text", jsonObject);
        return text;
    }

    public void clearText() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionId", (Object)this.driver.getSessionId());
        jsonObject.put("elementId", (Object)this.driver.getElementId());
        this.utils.request("POST", "session/:sessionId/element/:elementId/clear", jsonObject);
    }

    public void back() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionId", (Object)this.driver.getSessionId());
        this.utils.request("POST", "session/:sessionId/back", jsonObject);
    }

    public Object getProperty(String name) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionId", (Object)this.driver.getSessionId());
        jsonObject.put("elementId", (Object)this.driver.getElementId());
        jsonObject.put("name", (Object)name);
        Object response = this.utils.request("GET", "session/:sessionId/element/:elementId/property/:name", jsonObject);
        return response;
    }

    public Object getRect() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionId", (Object)this.driver.getSessionId());
        jsonObject.put("elementId", (Object)this.driver.getElementId());
        JSONObject response = (JSONObject)this.utils.request("GET", "session/:sessionId/element/:elementId/rect", jsonObject);
        return response;
    }

    public String getComputedCss(String propertyName) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionId", (Object)this.driver.getSessionId());
        jsonObject.put("elementId", (Object)this.driver.getElementId());
        jsonObject.put("propertyName", (Object)propertyName);
        String computedCss = (String)this.utils.request("GET", "session/:sessionId/element/:elementId/css/:propertyName", jsonObject);
        return computedCss;
    }

    public boolean isDisplayed() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionId", (Object)this.driver.getSessionId());
        jsonObject.put("elementId", (Object)this.driver.getElementId());
        boolean displayed = (Boolean)this.utils.request("GET", "session/:sessionId/element/:elementId/displayed", jsonObject);
        return displayed;
    }

    public void touch(String action, JSONObject args) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionId", (Object)this.driver.getSessionId());
        JSONArray array = new JSONArray();
        JSONObject actionObject = new JSONObject();
        actionObject.put("element", (Object)this.driver.getElementId());
        actionObject.put("type", (Object)action);
        for (String key : args.keySet()) {
            String value = args.getString(key);
            actionObject.put(key, (Object)value);
        }
        array.add((Object)actionObject);
        jsonObject.put("actions", (Object)array);
        this.utils.request("POST", "session/:sessionId/actions", jsonObject);
    }
}

