/*
 * Decompiled with CFR 0.152.
 */
package macaca.client;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import macaca.client.commands.Alert;
import macaca.client.commands.Context;
import macaca.client.commands.Element;
import macaca.client.commands.Execute;
import macaca.client.commands.Keys;
import macaca.client.commands.ScreenShot;
import macaca.client.commands.Session;
import macaca.client.commands.Source;
import macaca.client.commands.Status;
import macaca.client.commands.Title;
import macaca.client.commands.Url;
import macaca.client.commands.Window;
import macaca.client.common.ElementSelector;
import macaca.client.common.GetElementWay;
import macaca.client.common.MacacaDriver;
import macaca.client.common.Utils;

public class MacacaClient {
    public MacacaDriver contexts = new MacacaDriver();
    private Alert alert = new Alert(this.contexts);
    private Context context = new Context(this.contexts);
    public Element element = new Element(this.contexts);
    private Execute execute = new Execute(this.contexts);
    private Keys _keys = new Keys(this.contexts);
    private ScreenShot screenshot = new ScreenShot(this.contexts);
    private Session session = new Session(this.contexts);
    private Source source = new Source(this.contexts);
    private Status status = new Status(this.contexts);
    private Title title = new Title(this.contexts);
    private Url _url = new Url(this.contexts);
    private Utils utils = new Utils(this.contexts);
    private Window window = new Window(this.contexts);
    public int waitElementTimeout = 1000;
    public int waitElementTimeInterval = 200;

    public int getWaitElementTimeout() {
        return this.waitElementTimeout;
    }

    public void setWaitElementTimeout(int waitElementTimeout) {
        this.waitElementTimeout = waitElementTimeout;
    }

    public int getWaitElementTimeInterval() {
        return this.waitElementTimeInterval;
    }

    public void setWaitElementTimeInterval(int waitElementTimeInterval) {
        this.waitElementTimeInterval = waitElementTimeInterval;
    }

    public MacacaClient acceptAlert() throws Exception {
        this.alert.acceptAlert();
        return this;
    }

    public MacacaClient dismissAlert() throws Exception {
        this.alert.dismissAlert();
        return this;
    }

    public String alertText() throws Exception {
        return this.alert.alertText();
    }

    public MacacaClient alertKeys(String keys) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("text", (Object)keys);
        this.alert.alertKeys(jsonObject);
        return this;
    }

    public JSONArray contexts() throws Exception {
        return this.context.getContexts();
    }

    public MacacaClient context(String contextRef) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)contextRef);
        this.context.setContext(jsonObject);
        return this;
    }

    public String currentContext() throws Exception {
        return this.context.getContext();
    }

    private boolean findElement(JSONObject jsonObject) throws Exception {
        jsonObject.put("sessionId", (Object)this.contexts.getSessionId());
        JSONObject response = (JSONObject)this.utils.request("POST", "session/:sessionId/element", jsonObject);
        JSONObject element = (JSONObject)response.get((Object)"value");
        Object elementId = element.get((Object)"ELEMENT");
        if (elementId != null) {
            this.contexts.setElementId(elementId);
            return true;
        }
        return false;
    }

    private JSONArray findElements(JSONObject jsonObject) throws Exception {
        jsonObject.put("sessionId", (Object)this.contexts.getSessionId());
        JSONObject response = (JSONObject)this.utils.request("POST", "session/:sessionId/elements", jsonObject);
        JSONArray elements = (JSONArray)response.get((Object)"value");
        return elements;
    }

    public Element element(String name, String value) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)name);
        jsonObject.put("using", (Object)value);
        boolean isExist = this.findElement(jsonObject);
        return isExist ? this.element : null;
    }

    public Element elementById(String elementId) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)elementId);
        jsonObject.put("using", (Object)"id");
        boolean isExist = this.findElement(jsonObject);
        return isExist ? this.element : null;
    }

    public Element elementByCss(String selector) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)selector);
        jsonObject.put("using", (Object)"css");
        boolean isExist = this.findElement(jsonObject);
        return isExist ? this.element : null;
    }

    public Element elementByXPath(String xpath) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)xpath);
        jsonObject.put("using", (Object)"xpath");
        boolean isExist = this.findElement(jsonObject);
        return isExist ? this.element : null;
    }

    public Element elementByName(String name) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)name);
        jsonObject.put("using", (Object)"name");
        boolean isExist = this.findElement(jsonObject);
        return isExist ? this.element : null;
    }

    public Element getElement(GetElementWay wayToFind, String value, int index) throws Exception {
        ElementSelector elementSelector;
        switch (wayToFind) {
            case ID: {
                elementSelector = this.elementsById(value);
                break;
            }
            case CSS: {
                elementSelector = this.elementsByCss(value);
                break;
            }
            case NAME: {
                elementSelector = this.elementsByName(value);
                break;
            }
            case XPATH: {
                elementSelector = this.elementsByXPath(value);
                break;
            }
            case CLASS_NAME: {
                elementSelector = this.elementsByClassName(value);
                break;
            }
            case LINK_TEXT: {
                elementSelector = this.elementsByLinkText(value);
                break;
            }
            case PARTIAL_LINK_TEXT: {
                elementSelector = this.elementsByPartialLinkText(value);
                break;
            }
            case TAG_NAME: {
                elementSelector = this.elementsByTagName(value);
                break;
            }
            default: {
                elementSelector = null;
            }
        }
        if (elementSelector == null) {
            System.out.println("can't find the element:" + value + "[" + index + "]");
            return null;
        }
        elementSelector.getIndex(index);
        return this.element;
    }

    public Element getElement(GetElementWay wayToFind, String value) throws Exception {
        switch (wayToFind) {
            case ID: {
                return this.elementById(value);
            }
            case CSS: {
                return this.elementByCss(value);
            }
            case NAME: {
                return this.elementByName(value);
            }
            case XPATH: {
                return this.elementByXPath(value);
            }
            case CLASS_NAME: {
                return this.elementByClassName(value);
            }
            case LINK_TEXT: {
                return this.elementByLinkText(value);
            }
            case PARTIAL_LINK_TEXT: {
                return this.elementByPartialLinkText(value);
            }
            case TAG_NAME: {
                return this.elementByTagName(value);
            }
        }
        return null;
    }

    public int countOfElements(GetElementWay wayToFind, String value) throws Exception {
        ElementSelector elementSelector = this.getElementSelector(wayToFind, value);
        if (elementSelector != null) {
            return elementSelector.size();
        }
        return 0;
    }

    private ElementSelector getElementSelector(GetElementWay wayToFind, String value) throws Exception {
        ElementSelector elementSelector;
        switch (wayToFind) {
            case ID: {
                elementSelector = this.elementsById(value);
                break;
            }
            case CSS: {
                elementSelector = this.elementsByCss(value);
                break;
            }
            case NAME: {
                elementSelector = this.elementsByName(value);
                break;
            }
            case XPATH: {
                elementSelector = this.elementsByXPath(value);
                break;
            }
            case CLASS_NAME: {
                elementSelector = this.elementsByClassName(value);
                break;
            }
            case LINK_TEXT: {
                elementSelector = this.elementsByLinkText(value);
                break;
            }
            case PARTIAL_LINK_TEXT: {
                elementSelector = this.elementsByPartialLinkText(value);
                break;
            }
            case TAG_NAME: {
                elementSelector = this.elementsByTagName(value);
                break;
            }
            default: {
                elementSelector = null;
            }
        }
        return elementSelector;
    }

    public Element waitForElement(GetElementWay wayToFind, String value, int index) throws Exception {
        int count = 0;
        boolean satisfied = false;
        for (int timeLeft = this.waitElementTimeout; timeLeft > 0; timeLeft -= this.waitElementTimeInterval) {
            boolean elementExist = false;
            System.out.println(String.format("attempt to search the element for %d times", count++));
            elementExist = this.isElementExist(wayToFind, value, index);
            if (!elementExist) {
                this.sleep(this.waitElementTimeInterval);
                continue;
            }
            satisfied = true;
            this.getElement(wayToFind, value, index);
            break;
        }
        if (!satisfied) {
            System.out.println("can't find the element:" + value);
            return null;
        }
        return this.element;
    }

    public Element waitForElement(GetElementWay wayToFind, String value) throws Exception {
        int count = 0;
        boolean satisfied = false;
        for (int timeLeft = this.waitElementTimeout; timeLeft > 0; timeLeft -= this.waitElementTimeInterval) {
            boolean elementExist = false;
            System.out.println(String.format("attempt to search the element for %d times", count++));
            elementExist = this.isElementExist(wayToFind, value);
            if (!elementExist) {
                this.sleep(this.waitElementTimeInterval);
                continue;
            }
            satisfied = true;
            this.getElement(wayToFind, value);
            break;
        }
        if (!satisfied) {
            System.out.println("can't find the element:" + value);
            return null;
        }
        return this.element;
    }

    public Element elementByClassName(String className) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)className);
        jsonObject.put("using", (Object)"class name");
        boolean isExist = this.findElement(jsonObject);
        return isExist ? this.element : null;
    }

    public Element elementByLinkText(String linkText) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)linkText);
        jsonObject.put("using", (Object)"link text");
        boolean isExist = this.findElement(jsonObject);
        return isExist ? this.element : null;
    }

    public Element elementByTagName(String tagName) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)tagName);
        jsonObject.put("using", (Object)"tag name");
        boolean isExist = this.findElement(jsonObject);
        return isExist ? this.element : null;
    }

    public Element elementByPartialLinkText(String partialLinkText) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)partialLinkText);
        jsonObject.put("using", (Object)"partial link text");
        boolean isExist = this.findElement(jsonObject);
        return isExist ? this.element : null;
    }

    public ElementSelector elementsByXPath(String xpath) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)xpath);
        jsonObject.put("using", (Object)"xpath");
        JSONArray jsonArray = this.findElements(jsonObject);
        return new ElementSelector(this.contexts, this, jsonArray);
    }

    public ElementSelector elementsByName(String name) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)name);
        jsonObject.put("using", (Object)"name");
        JSONArray jsonArray = this.findElements(jsonObject);
        return new ElementSelector(this.contexts, this, jsonArray);
    }

    public ElementSelector elementsById(String elementId) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)elementId);
        jsonObject.put("using", (Object)"id");
        JSONArray jsonArray = this.findElements(jsonObject);
        return new ElementSelector(this.contexts, this, jsonArray);
    }

    public ElementSelector elementsByClassName(String className) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)className);
        jsonObject.put("using", (Object)"class name");
        JSONArray jsonArray = this.findElements(jsonObject);
        return new ElementSelector(this.contexts, this, jsonArray);
    }

    public ElementSelector elementsByCss(String css) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)css);
        jsonObject.put("using", (Object)"selector");
        JSONArray jsonArray = this.findElements(jsonObject);
        return new ElementSelector(this.contexts, this, jsonArray);
    }

    public ElementSelector elementsByLinkText(String linkText) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)linkText);
        jsonObject.put("using", (Object)"link text");
        JSONArray jsonArray = this.findElements(jsonObject);
        return new ElementSelector(this.contexts, this, jsonArray);
    }

    public ElementSelector elementsByPartialLinkText(String partialLinkText) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)partialLinkText);
        jsonObject.put("using", (Object)"partial link text");
        JSONArray jsonArray = this.findElements(jsonObject);
        return new ElementSelector(this.contexts, this, jsonArray);
    }

    public ElementSelector elementsByTagName(String tagName) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)tagName);
        jsonObject.put("using", (Object)"tag name");
        JSONArray jsonArray = this.findElements(jsonObject);
        return new ElementSelector(this.contexts, this, jsonArray);
    }

    public Element waitForElement(String using, String value, int timeout, int interval) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)value);
        jsonObject.put("using", (Object)using);
        int count = 1;
        boolean satisfied = false;
        for (int timeLeft = timeout; timeLeft > 0; timeLeft -= interval) {
            boolean elementExist = false;
            System.out.println(String.format("attempt to search the element for %d times", count++));
            elementExist = this.isElementExist(using, value);
            if (!elementExist) {
                this.sleep(interval);
                continue;
            }
            satisfied = true;
            this.findElement(jsonObject);
            break;
        }
        if (!satisfied) {
            System.out.println("can't find the element: " + using + ":" + value);
            return null;
        }
        return this.element;
    }

    public Element waitForElement(String using, String value) throws Exception {
        return this.waitForElement(using, value, this.waitElementTimeout, this.waitElementTimeInterval);
    }

    public Element waitForElementById(String elementId) throws Exception {
        return this.waitForElement(GetElementWay.ID, elementId);
    }

    public Element waitForElementByCss(String selector) throws Exception {
        return this.waitForElement(GetElementWay.CSS, selector);
    }

    public Element waitForElementByXPath(String xpath) throws Exception {
        return this.waitForElement(GetElementWay.XPATH, xpath);
    }

    public Element waitForElementByTagName(String tagname) throws Exception {
        return this.waitForElement(GetElementWay.TAG_NAME, tagname);
    }

    public Element waitForElementByName(String name) throws Exception {
        return this.waitForElement(GetElementWay.NAME, name);
    }

    public Element waitForElementByLinkText(String text) throws Exception {
        return this.waitForElement(GetElementWay.LINK_TEXT, text);
    }

    public Element waitForElementByPartialLinkText(String text) throws Exception {
        return this.waitForElement("partial link text", text);
    }

    public boolean isElementExist(String using, String value) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)value);
        jsonObject.put("using", (Object)using);
        try {
            this.findElement(jsonObject);
        }
        catch (Exception e) {
            return false;
        }
        return this.element.isDisplayed();
    }

    public boolean isElementExist(GetElementWay wayToFind, String value, int index) throws Exception {
        try {
            this.getElement(wayToFind, value, index);
        }
        catch (Exception e) {
            return false;
        }
        return this.element.isDisplayed();
    }

    public boolean isElementExist(GetElementWay wayToFind, String value) throws Exception {
        try {
            this.getElement(wayToFind, value);
        }
        catch (Exception e) {
            return false;
        }
        return this.element.isDisplayed();
    }

    @Deprecated
    public MacacaClient sendKeys(String keys) throws Exception {
        JSONObject jsonObject = new JSONObject();
        ArrayList<String> values = new ArrayList<String>();
        values.add(keys);
        jsonObject.put("value", values);
        this.element.setValue(jsonObject);
        return this;
    }

    @Deprecated
    public MacacaClient click() throws Exception {
        this.element.click();
        return this;
    }

    @Deprecated
    public MacacaClient clear() throws Exception {
        this.element.clearText();
        return this;
    }

    public MacacaClient back() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionId", (Object)this.contexts.getSessionId());
        this.utils.request("POST", "session/:sessionId/back", jsonObject);
        return this;
    }

    @Deprecated
    public Object getProperty(String name) throws Exception {
        return this.element.getProperty(name);
    }

    @Deprecated
    public Object getRect() throws Exception {
        return this.element.getRect();
    }

    public JSONObject execute(String code) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("script", (Object)code);
        jsonObject.put("args", (Object)new JSONArray());
        return this.execute.execute(jsonObject);
    }

    public MacacaClient keys(String keys) throws Exception {
        JSONObject jsonObject = new JSONObject();
        ArrayList<String> values = new ArrayList<String>();
        values.add(keys);
        jsonObject.put("value", values);
        this._keys.keys(jsonObject);
        return this;
    }

    public MacacaClient takeScreenshot() throws Exception {
        this.screenshot.takeScreenshot();
        return this;
    }

    public MacacaClient saveScreenshot(String fileName) throws Exception {
        this.screenshot.saveScreenshot(fileName);
        return this;
    }

    public MacacaClient initDriver(JSONObject jsonObject) throws Exception {
        this.session.createSession(jsonObject);
        return this;
    }

    public String sessionId() throws Exception {
        return this.contexts.getSessionId();
    }

    public void quit() throws Exception {
        this.session.delSession();
    }

    public String source() throws Exception {
        return this.source.getSource();
    }

    public String status() throws Exception {
        return this.status.getStatus();
    }

    public MacacaClient sleep(int ms) throws Exception {
        Thread.sleep(ms);
        return this;
    }

    public String title() throws Exception {
        return this.title.title();
    }

    public String url() throws Exception {
        return this._url.url();
    }

    public MacacaClient get(String url) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("url", (Object)url);
        this._url.getUrl(jsonObject);
        return this;
    }

    public JSONObject getWindowSize() throws Exception {
        return this.window.getWindowSize();
    }

    public MacacaClient setWindowSize(int width, int height) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("width", (Object)width);
        jsonObject.put("height", (Object)height);
        this.window.setWindowSize(jsonObject);
        return this;
    }

    public MacacaClient maximize() throws Exception {
        this.window.maximize();
        return this;
    }

    @Deprecated
    public String text() throws Exception {
        return this.element.getText();
    }

    public MacacaClient touch(String action, JSONObject args) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionId", (Object)this.contexts.getSessionId());
        JSONArray array = new JSONArray();
        JSONObject actionObject = new JSONObject();
        actionObject.put("type", (Object)action);
        for (String key : args.keySet()) {
            String value = args.getString(key);
            actionObject.put(key, (Object)value);
        }
        array.add((Object)actionObject);
        jsonObject.put("actions", (Object)array);
        Utils utils = new Utils(this.contexts);
        utils.request("POST", "session/:sessionId/actions", jsonObject);
        return this;
    }

    public void tap(double x, double y) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("x", (Object)x);
        jsonObject.put("y", (Object)y);
        this.touch("tap", jsonObject);
    }

    public void doubleTap(double x, double y) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("x", (Object)x);
        jsonObject.put("y", (Object)y);
        this.touch("doubleTap", jsonObject);
    }

    public void press(double x, double y, double duration, int steps) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("x", (Object)x);
        jsonObject.put("y", (Object)y);
        jsonObject.put("duration", (Object)duration);
        jsonObject.put("steps", (Object)steps);
        this.touch("press", jsonObject);
    }

    public void pinch(double x, double y, double scale, double velocity, GesturePinchType direction, double percent, int steps) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("x", (Object)x);
        jsonObject.put("y", (Object)y);
        jsonObject.put("scale", (Object)scale);
        jsonObject.put("velocity", (Object)velocity);
        jsonObject.put("percent", (Object)percent);
        jsonObject.put("steps", (Object)steps);
        if (direction == GesturePinchType.PINCH_IN) {
            jsonObject.put("direction", (Object)"in");
        } else {
            jsonObject.put("direction", (Object)"out");
        }
        this.touch("pinch", jsonObject);
    }

    public void rotate(double rotation, double velocity) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("rotation", (Object)rotation);
        jsonObject.put("velocity", (Object)velocity);
        this.touch("rotate", jsonObject);
    }

    public void drag(double fromX, double fromY, double toX, double toY, double duration, int steps) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fromX", (Object)fromX);
        jsonObject.put("fromY", (Object)fromY);
        jsonObject.put("toX", (Object)toX);
        jsonObject.put("toY", (Object)toY);
        jsonObject.put("duration", (Object)duration);
        jsonObject.put("steps", (Object)steps);
        this.touch("drag", jsonObject);
    }

    public static enum GesturePinchType {
        PINCH_IN,
        PINCH_OUT;

    }
}

