/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.os;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kr.motd.maven.os.DetectionException;
import kr.motd.maven.os.Detector;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.InterpolationFilterReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=AbstractMavenLifecycleParticipant.class, hint="detect-os")
public class DetectExtension
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private Logger logger;
    private final Detector detector = new Detector(){

        protected void log(String message) {
            DetectExtension.this.logger.info(message);
        }

        protected void logProperty(String name, String value) {
            if (DetectExtension.this.logger.isInfoEnabled()) {
                DetectExtension.this.logger.info(name + ": " + value);
            }
        }
    };

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Properties props = session.getSystemProperties();
        try {
            this.detector.detect(props);
        }
        catch (DetectionException e) {
            throw new MavenExecutionException(e.getMessage(), session.getCurrentProject().getFile());
        }
        HashMap<String, String> dict = new HashMap<String, String>();
        dict.put("os.detected.name", props.getProperty("os.detected.name"));
        dict.put("os.detected.arch", props.getProperty("os.detected.arch"));
        dict.put("os.detected.classifier", props.getProperty("os.detected.classifier"));
        for (MavenProject p : session.getProjects()) {
            for (Dependency d : p.getDependencies()) {
                d.setGroupId(DetectExtension.interpolate(dict, d.getGroupId()));
                d.setArtifactId(DetectExtension.interpolate(dict, d.getArtifactId()));
                d.setVersion(DetectExtension.interpolate(dict, d.getVersion()));
                d.setClassifier(DetectExtension.interpolate(dict, d.getClassifier()));
                d.setSystemPath(DetectExtension.interpolate(dict, d.getSystemPath()));
                for (Exclusion e : d.getExclusions()) {
                    e.setGroupId(DetectExtension.interpolate(dict, e.getGroupId()));
                    e.setArtifactId(DetectExtension.interpolate(dict, e.getArtifactId()));
                }
            }
        }
    }

    private static String interpolate(Map<String, String> dict, String value) {
        if (value == null) {
            return null;
        }
        while (value.contains("${")) {
            InterpolationFilterReader reader = new InterpolationFilterReader((Reader)new StringReader(value), dict);
            StringWriter writer = new StringWriter(value.length());
            while (true) {
                int ch = 0;
                try {
                    ch = reader.read();
                }
                catch (IOException e) {
                    throw (Error)new Error().initCause(e);
                }
                if (ch == -1) break;
                writer.write(ch);
            }
            String newValue = writer.toString();
            if (value.equals(newValue)) break;
            value = newValue;
        }
        return value;
    }
}

