/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.metrics;

import java.util.Arrays;
import java.util.LinkedList;
import kg.apc.perfmon.metrics.AbstractPerfMonMetric;
import kg.apc.perfmon.metrics.MetricParams;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

class NetworkIOMetric
extends AbstractPerfMonMetric {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final byte RX_BYTES = 0;
    public static final byte RX_DROPPED = 1;
    public static final byte RX_ERRORS = 2;
    public static final byte RX_FRAME = 3;
    public static final byte RX_OVERRUNS = 4;
    public static final byte RX_PACKETS = 5;
    public static final byte TX_BYTES = 6;
    public static final byte TX_CARRIER = 7;
    public static final byte TX_COLLISIONS = 8;
    public static final byte TX_DROPPED = 9;
    public static final byte TX_ERRORS = 10;
    public static final byte TX_OVERRUNS = 11;
    public static final byte USED = 12;
    public static final byte SPEED = 13;
    public static final byte TX_PACKETS = 14;
    public static final String[] types = new String[]{"bytesrecv", "rxdrops", "rxerr", "rxframe", "rxoverruns", "rx", "bytessent", "txcarrier", "txcollisions", "txdrops", "txerr", "txoverruns", "used", "speed", "tx"};
    private int type = -1;
    private final String[] interfaces;
    private double prev = -1.0;
    private int dividingFactor = 1;

    public NetworkIOMetric(SigarProxy aSigar, MetricParams params) {
        super(aSigar);
        if (params.type.length() == 0) {
            this.type = 0;
        } else {
            this.type = Arrays.asList(types).indexOf(params.type);
            if (this.type < 0) {
                throw new IllegalArgumentException("Unknown net io type: " + params.type);
            }
        }
        log.debug("Net metric type: " + this.type);
        LinkedList<String> list = new LinkedList<String>();
        if (params.iface.length() != 0) {
            list.add(params.iface);
        } else {
            try {
                list.addAll(Arrays.asList(aSigar.getNetInterfaceList()));
            }
            catch (SigarException ex) {
                log.warn("Can't get network interfaces list", (Throwable)ex);
            }
        }
        this.interfaces = list.toArray(new String[0]);
        this.dividingFactor = this.getUnitDividingFactor(params.getUnit());
    }

    static void logAvailableInterfaces(SigarProxy sigar) {
        log.info("*** Logging available network interfaces ***");
        try {
            String[] list = sigar.getNetInterfaceList();
            for (int n = 0; n < list.length; ++n) {
                NetInterfaceConfig ifc = sigar.getNetInterfaceConfig(list[n]);
                log.info("Network interface: iface=" + ifc.getName() + " addr=" + ifc.getAddress() + " type=" + ifc.getType());
            }
        }
        catch (SigarException e) {
            log.debug("Can't get network info", (Throwable)e);
        }
    }

    public void getValue(StringBuffer res) throws SigarException {
        double val = 0.0;
        int factor = 1;
        block23: for (int n = 0; n < this.interfaces.length; ++n) {
            NetInterfaceStat usage;
            try {
                usage = this.sigarProxy.getNetInterfaceStat(this.interfaces[n]);
            }
            catch (SigarException e) {
                log.error("Failed to get interface stat: " + this.interfaces[n], (Throwable)e);
                continue;
            }
            switch (this.type) {
                case 0: {
                    val += (double)usage.getRxBytes();
                    factor = this.dividingFactor;
                    continue block23;
                }
                case 1: {
                    val += (double)usage.getRxDropped();
                    continue block23;
                }
                case 2: {
                    val += (double)usage.getRxErrors();
                    continue block23;
                }
                case 3: {
                    val += (double)usage.getRxFrame();
                    continue block23;
                }
                case 4: {
                    val += (double)usage.getRxOverruns();
                    continue block23;
                }
                case 5: {
                    val += (double)usage.getRxPackets();
                    continue block23;
                }
                case 6: {
                    val += (double)usage.getTxBytes();
                    factor = this.dividingFactor;
                    continue block23;
                }
                case 7: {
                    val += (double)usage.getTxCarrier();
                    continue block23;
                }
                case 8: {
                    val += (double)usage.getTxCollisions();
                    continue block23;
                }
                case 9: {
                    val += (double)usage.getTxDropped();
                    continue block23;
                }
                case 10: {
                    val += (double)usage.getTxErrors();
                    continue block23;
                }
                case 11: {
                    val += (double)usage.getTxOverruns();
                    continue block23;
                }
                case 12: {
                    val = usage.getTxPackets();
                    continue block23;
                }
                case 13: {
                    val = usage.getSpeed();
                    continue block23;
                }
                case 14: {
                    val += (double)usage.getTxPackets();
                    continue block23;
                }
                default: {
                    throw new SigarException("Unknown net io type " + this.type);
                }
            }
        }
        switch (this.type) {
            case 13: {
                break;
            }
            case 12: {
                break;
            }
            default: {
                double cur = val;
                val = this.prev > 0.0 ? cur - this.prev : 0.0;
                this.prev = cur;
            }
        }
        res.append(Double.toString(val /= (double)factor));
    }
}

