/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.Color;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;

public class ResponseTimesOverTimeGui
extends AbstractOverTimeVisualizer {
    public ResponseTimesOverTimeGui() {
        this.graphPanel.getGraphObject().setYAxisLabel("Response times in ms");
    }

    private void addThreadGroupRecord(String threadGroupName, long time, long numThreads) {
        String labelAgg = "Overall Response Times";
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(threadGroupName);
        AbstractGraphRow rowAgg = (AbstractGraphRow)this.modelAggregate.get(labelAgg);
        if (row == null) {
            row = this.getNewRow(this.model, 0, threadGroupName, 2, false, false, false, true, true);
        }
        if (rowAgg == null) {
            rowAgg = this.getNewRow(this.modelAggregate, 0, labelAgg, 2, false, false, false, true, Color.RED, true);
        }
        row.add(time, numThreads);
        rowAgg.add(time, numThreads);
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Response Times Over Time");
    }

    @Override
    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        super.add(res);
        this.addThreadGroupRecord(res.getSampleLabel(), this.normalizeTime(res.getEndTime()), res.getTime());
        this.updateGui(null);
    }

    @Override
    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel(this, 2971);
    }

    @Override
    public String getWikiPage() {
        return "ResponseTimesOverTime";
    }
}

