/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.threads;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.charting.DateTimeRenderer;
import kg.apc.charting.GraphPanelChart;
import kg.apc.charting.rows.GraphRowSumValues;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.ButtonPanelAddCopyRemove;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import kg.apc.jmeter.threads.UltimateThreadGroup;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.gui.LoopControlPanel;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.gui.AbstractThreadGroupGui;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class UltimateThreadGroupGui
extends AbstractThreadGroupGui
implements TableModelListener,
CellEditorListener {
    public static final String WIKIPAGE = "UltimateThreadGroup";
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected ConcurrentHashMap<String, AbstractGraphRow> model;
    private GraphPanelChart chart;
    public static final String[] columnIdentifiers = new String[]{"Start Threads Count", "Initial Delay, sec", "Startup Time, sec", "Hold Load For, sec", "Shutdown Time"};
    public static final Class[] columnClasses = new Class[]{String.class, String.class, String.class, String.class, String.class};
    public static final Integer[] defaultValues = new Integer[]{100, 0, 30, 60, 10};
    private LoopControlPanel loopPanel;
    protected PowerTableModel tableModel;
    protected JTable grid;
    protected ButtonPanelAddCopyRemove buttons;

    public UltimateThreadGroupGui() {
        this.init();
    }

    protected final void init() {
        JMeterPluginsUtils.addHelpLinkToPanel((Container)((Object)this), WIKIPAGE);
        VerticalPanel containerPanel = new VerticalPanel();
        containerPanel.add((Component)this.createParamsPanel(), "North");
        containerPanel.add((Component)GuiBuilderHelper.getComponentWithMargin(this.createChart(), 2, 2, 0, 2), "Center");
        this.add((Component)containerPanel, "Center");
        this.createControllerPanel();
    }

    private JPanel createParamsPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createTitledBorder("Threads Schedule"));
        panel.setPreferredSize(new Dimension(200, 200));
        JScrollPane scroll = new JScrollPane(this.createGrid());
        scroll.setPreferredSize(scroll.getMinimumSize());
        panel.add((Component)scroll, "Center");
        this.buttons = new ButtonPanelAddCopyRemove(this.grid, this.tableModel, defaultValues);
        panel.add((Component)this.buttons, "South");
        return panel;
    }

    private JTable createGrid() {
        this.grid = new JTable();
        this.grid.getDefaultEditor(String.class).addCellEditorListener(this);
        this.createTableModel();
        this.grid.setSelectionMode(0);
        this.grid.setMinimumSize(new Dimension(200, 100));
        return this.grid;
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Ultimate Thread Group");
    }

    public TestElement createTestElement() {
        UltimateThreadGroup tg = new UltimateThreadGroup();
        this.modifyTestElement((TestElement)tg);
        tg.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return tg;
    }

    public void modifyTestElement(TestElement tg) {
        if (this.grid.isEditing()) {
            this.grid.getCellEditor().stopCellEditing();
        }
        if (tg instanceof UltimateThreadGroup) {
            UltimateThreadGroup utg = (UltimateThreadGroup)tg;
            CollectionProperty rows = JMeterPluginsUtils.tableModelRowsToCollectionProperty(this.tableModel, "ultimatethreadgroupdata");
            utg.setData(rows);
            utg.setSamplerController((LoopController)this.loopPanel.createTestElement());
        }
        super.configureTestElement(tg);
    }

    public void configure(TestElement tg) {
        super.configure(tg);
        UltimateThreadGroup utg = (UltimateThreadGroup)tg;
        JMeterProperty threadValues = utg.getData();
        if (!(threadValues instanceof NullProperty)) {
            CollectionProperty columns = (CollectionProperty)threadValues;
            this.tableModel.removeTableModelListener((TableModelListener)this);
            JMeterPluginsUtils.collectionPropertyToTableModelRows(columns, this.tableModel);
            this.tableModel.addTableModelListener((TableModelListener)this);
            this.updateUI();
        } else {
            log.warn("Received null property instead of collection");
        }
        TestElement te = (TestElement)tg.getProperty("ThreadGroup.main_controller").getObjectValue();
        if (te != null) {
            this.loopPanel.configure(te);
        }
        this.buttons.checkDeleteButtonStatus();
    }

    public void updateUI() {
        super.updateUI();
        if (this.tableModel != null) {
            UltimateThreadGroup utgForPreview = new UltimateThreadGroup();
            utgForPreview.setData(JMeterPluginsUtils.tableModelRowsToCollectionPropertyEval(this.tableModel, "ultimatethreadgroupdata"));
            this.updateChart(utgForPreview);
        }
    }

    private void updateChart(UltimateThreadGroup tg) {
        int n;
        tg.testStarted();
        this.model.clear();
        GraphRowSumValues row = new GraphRowSumValues();
        row.setColor(Color.RED);
        row.setDrawLine(true);
        row.setMarkerSize(0);
        row.setDrawThickLines(true);
        HashTree hashTree = new HashTree();
        hashTree.add((Object)new LoopController());
        JMeterThread thread = new JMeterThread(hashTree, null, null);
        long now = System.currentTimeMillis();
        this.chart.setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss", now - 1L));
        this.chart.setForcedMinX(now);
        row.add(now, 0.0);
        int numThreads = tg.getNumThreads();
        log.debug("Num Threads: " + numThreads);
        for (n = 0; n < numThreads; ++n) {
            thread.setThreadNum(n);
            thread.setThreadName(Integer.toString(n));
            tg.scheduleThread(thread, now);
            row.add(thread.getStartTime() - 1L, 0.0);
            row.add(thread.getStartTime(), 1.0);
        }
        tg.testStarted();
        for (n = 0; n < tg.getNumThreads(); ++n) {
            thread.setThreadNum(n);
            thread.setThreadName(Integer.toString(n));
            tg.scheduleThread(thread, now);
            row.add(thread.getEndTime() - 1L, 0.0);
            row.add(thread.getEndTime(), -1.0);
        }
        this.model.put("Expected parallel users count", row);
        this.chart.invalidateCache();
        this.chart.repaint();
    }

    private JPanel createControllerPanel() {
        this.loopPanel = new LoopControlPanel(false);
        LoopController looper = (LoopController)this.loopPanel.createTestElement();
        looper.setLoops(-1);
        looper.setContinueForever(true);
        this.loopPanel.configure((TestElement)looper);
        return this.loopPanel;
    }

    private Component createChart() {
        this.chart = new GraphPanelChart(false, true);
        this.model = new ConcurrentHashMap();
        this.chart.setRows(this.model);
        this.chart.getChartSettings().setDrawFinalZeroingLines(true);
        this.chart.setxAxisLabel("Elapsed time");
        this.chart.setYAxisLabel("Number of active threads");
        this.chart.setBorder(BorderFactory.createBevelBorder(1));
        return this.chart;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateUI();
    }

    private void createTableModel() {
        this.tableModel = new PowerTableModel(columnIdentifiers, columnClasses);
        this.tableModel.addTableModelListener((TableModelListener)this);
        this.grid.setModel((TableModel)this.tableModel);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.updateUI();
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
    }

    public void clearGui() {
        super.clearGui();
        this.tableModel.clearData();
    }
}

