/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.reporters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.BrowseAction;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import kg.apc.jmeter.reporters.LoadosophiaUploader;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.loadosophia.jmeter.LoadosophiaAPIClient;

public class LoadosophiaUploaderGui
extends AbstractVisualizer {
    public static final String WIKIPAGE = "LoadosophiaUploader";
    private JTextField testTitle;
    private JTextArea uploadToken;
    private JTextField projectKey;
    private JTextArea infoArea;
    private JTextField storeDir;
    private JComboBox colorFlag;
    private JCheckBox useOnline;

    public LoadosophiaUploaderGui() {
        this.init();
        this.initFields();
    }

    protected Component getFilePanel() {
        return new JPanel();
    }

    public String getStaticLabel() {
        return "bzm - BlazeMeter Sense Uploader";
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public TestElement createTestElement() {
        LoadosophiaUploader te = new LoadosophiaUploader();
        this.modifyTestElement((TestElement)te);
        te.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return te;
    }

    public void modifyTestElement(TestElement te) {
        super.modifyTestElement(te);
        if (te instanceof LoadosophiaUploader) {
            LoadosophiaUploader fw = (LoadosophiaUploader)te;
            fw.setProject(this.projectKey.getText());
            fw.setUploadToken(this.uploadToken.getText());
            fw.setStoreDir(this.storeDir.getText());
            fw.setColorFlag(this.indexToColor(this.colorFlag.getSelectedIndex()));
            fw.setTitle(this.testTitle.getText());
            fw.setUseOnline(this.useOnline.isSelected());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        LoadosophiaUploader fw = (LoadosophiaUploader)element;
        this.projectKey.setText(fw.getProject());
        this.uploadToken.setText(fw.getUploadToken());
        this.storeDir.setText(fw.getStoreDir());
        this.colorFlag.setSelectedIndex(this.colorToIndex(fw.getColorFlag()));
        this.testTitle.setText(fw.getTitle());
        this.useOnline.setSelected(fw.isUseOnline());
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        int row = 0;
        this.addToPanel(mainPanel, labelConstraints, 0, row, new JLabel("Initiate active test: ", 4));
        this.useOnline = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, row, this.useOnline);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Upload to Project: ", 4));
        this.projectKey = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, row, this.projectKey);
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Test Title: ", 4));
        this.testTitle = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, row, this.testTitle);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Color Flag: ", 4));
        this.colorFlag = new JComboBox<String>(LoadosophiaAPIClient.colors);
        this.addToPanel(mainPanel, editConstraints, 1, row, this.colorFlag);
        editConstraints.fill = 1;
        editConstraints.insets = new Insets(4, 0, 0, 0);
        labelConstraints.insets = new Insets(4, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Upload Token: ", 4));
        this.uploadToken = new JTextArea();
        this.uploadToken.setLineWrap(true);
        this.addToPanel(mainPanel, editConstraints, 1, row, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.uploadToken, 6));
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Temp directory: ", 4));
        this.storeDir = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, row, this.storeDir);
        JButton browseButton = new JButton("Browse...");
        this.addToPanel(mainPanel, labelConstraints, 2, row, browseButton);
        GuiBuilderHelper.strechItemToComponent(this.storeDir, browseButton);
        browseButton.addActionListener(new BrowseAction(this.storeDir, true));
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Info Area: ", 4));
        this.infoArea = new JTextArea();
        this.infoArea.setEditable(false);
        this.infoArea.setOpaque(false);
        GuiBuilderHelper.strechItemToComponent(this.storeDir, this.infoArea);
        this.addToPanel(mainPanel, editConstraints, 1, row, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.infoArea, 10));
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void initFields() {
        this.testTitle.setText("");
        this.projectKey.setText("DEFAULT");
        this.uploadToken.setText("Replace this text with upload token received at sense.blazemeter.com\nRemember that anyone who has this token can upload files to your account.\nPlease, treat your token as confidential data.\nSee plugin help for details.");
        this.storeDir.setText("");
        this.colorFlag.setSelectedIndex(0);
        this.useOnline.setSelected(true);
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    public void clearData() {
        this.infoArea.setText("");
    }

    public void inform(String string) {
        this.infoArea.append(string + "\n");
    }

    private String indexToColor(int selectedIndex) {
        if (selectedIndex >= 0) {
            return LoadosophiaAPIClient.colors[selectedIndex];
        }
        return "none";
    }

    private int colorToIndex(String colorFlag) {
        return Arrays.asList(LoadosophiaAPIClient.colors).indexOf(colorFlag);
    }

    public void add(SampleResult sample) {
    }
}

