/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.reporters;

import kg.apc.jmeter.reporters.LoadosophiaConsolidator;
import kg.apc.jmeter.reporters.LoadosophiaUploaderGui;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.loadosophia.jmeter.StatusNotifierCallback;

public class LoadosophiaUploader
extends ResultCollector
implements StatusNotifierCallback {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String TITLE = "title";
    public static final String COLOR = "color";
    public static final String UPLOAD_TOKEN = "uploadToken";
    public static final String PROJECT = "project";
    public static final String STORE_DIR = "storeDir";
    public static final String USE_ONLINE = "useOnline";
    protected LoadosophiaConsolidator consolidator;

    public void testStarted() {
        this.testStarted("*local*");
    }

    public void testEnded() {
        this.testEnded("*local*");
    }

    public void testStarted(String host) {
        if (this.consolidator == null) {
            this.consolidator = this.getConsolidator();
            log.debug("Consolidator: " + this.consolidator);
        }
        this.consolidator.add(this);
    }

    public void testEnded(String host) {
        this.consolidator.remove(this);
        if (this.consolidator.getNumSources() < 1) {
            this.consolidator = null;
            LoadosophiaConsolidator.destroy();
        }
    }

    public void setProject(String proj) {
        this.setProperty(PROJECT, proj);
    }

    public String getProject() {
        return this.getPropertyAsString(PROJECT);
    }

    public void setUploadToken(String token) {
        this.setProperty(UPLOAD_TOKEN, token);
    }

    public String getUploadToken() {
        return this.getPropertyAsString(UPLOAD_TOKEN);
    }

    public void setTitle(String prefix) {
        this.setProperty(TITLE, prefix);
    }

    public String getTitle() {
        return this.getPropertyAsString(TITLE);
    }

    public void informUser(String string) {
        Visualizer vis = this.getVisualizer();
        if (vis != null && vis instanceof LoadosophiaUploaderGui) {
            log.info(string);
            ((LoadosophiaUploaderGui)vis).inform(string);
        } else {
            log.info(string);
        }
    }

    public String getStoreDir() {
        return this.getPropertyAsString(STORE_DIR);
    }

    public void setStoreDir(String prefix) {
        this.setProperty(STORE_DIR, prefix);
    }

    public void setColorFlag(String color) {
        this.setProperty(COLOR, color);
    }

    public String getColorFlag() {
        return this.getPropertyAsString(COLOR);
    }

    @Override
    public void notifyAbout(String info) {
        this.informUser(info);
    }

    public boolean isUseOnline() {
        return this.getPropertyAsBoolean(USE_ONLINE);
    }

    public void setUseOnline(boolean selected) {
        this.setProperty(USE_ONLINE, selected);
    }

    public void sampleOccurred(SampleEvent e) {
        this.consolidator.sampleOccurred(e);
    }

    public void sampleStarted(SampleEvent e) {
        this.consolidator.sampleStarted(e);
    }

    public void sampleStopped(SampleEvent e) {
        this.consolidator.sampleStopped(e);
    }

    protected LoadosophiaConsolidator getConsolidator() {
        return LoadosophiaConsolidator.getInstance();
    }
}

