/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.reporters;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.perfmon.PerfMonCollector;
import kg.apc.jmeter.reporters.LoadosophiaAggregator;
import kg.apc.jmeter.reporters.LoadosophiaUploader;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.loadosophia.jmeter.LoadosophiaAPIClient;
import org.loadosophia.jmeter.LoadosophiaUploadResults;

public class LoadosophiaConsolidator
extends ResultCollector
implements Serializable,
Remoteable,
NoThreadClone,
Runnable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Object LOCK = new Object();
    private static LoadosophiaConsolidator instance;
    private Set<LoadosophiaUploader> sources = new HashSet<LoadosophiaUploader>();
    private boolean isSaving;
    private String fileName;
    private String address = JMeterUtils.getPropDefault((String)"loadosophia.address", (String)"https://sense.blazemeter.com/");
    private boolean isOnlineInitiated = false;
    private LoadosophiaAPIClient apiClient;
    private BlockingQueue<SampleEvent> processingQueue;
    private Thread processorThread;
    private LoadosophiaAggregator aggregator;

    protected LoadosophiaConsolidator() {
    }

    public static LoadosophiaConsolidator getInstance() {
        if (instance == null) {
            instance = new LoadosophiaConsolidator();
        }
        return instance;
    }

    public void add(LoadosophiaUploader source) {
        log.debug("Add to consolidator: " + source);
        this.sources.add(source);
        if (this.sources.size() == 1) {
            log.debug("First source arrived, let's start the process");
            this.start(source);
            this.testStarted();
        }
        if (this.isOnlineInitiated) {
            this.aggregator.setNumSources(this.sources.size());
        }
    }

    public void remove(LoadosophiaUploader source) {
        log.debug("Remove from consolidator: " + source);
        this.sources.remove(source);
        if (this.isOnlineInitiated) {
            this.aggregator.setNumSources(this.getNumSources());
        }
        if (this.sources.size() == 0) {
            log.debug("Last source departed, let's finish the process");
            this.testEnded();
            this.stop(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(LoadosophiaUploader source) {
        Object object = LOCK;
        synchronized (object) {
            this.apiClient = this.getAPIClient(source);
            try {
                if (!this.isSaving) {
                    this.isSaving = true;
                    this.setupSaving(source);
                }
            }
            catch (IOException ex) {
                log.error("Error setting up saving", (Throwable)ex);
            }
            this.initiateOnline(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop(LoadosophiaUploader source) {
        String redirectLink = "";
        Object object = LOCK;
        synchronized (object) {
            this.flush();
            try {
                if (this.fileName == null) {
                    throw new IOException("File for upload was not set, search for errors above in log");
                }
                this.isSaving = false;
                LinkedList<String> monFiles = this.hasStandardSet() ? PerfMonCollector.getFiles() : new LinkedList();
                LoadosophiaUploadResults uploadResult = this.apiClient.sendFiles(new File(this.fileName), monFiles);
                redirectLink = uploadResult.getRedirectLink();
                source.informUser("Uploaded successfully, go to results: " + redirectLink);
            }
            catch (IOException ex) {
                source.informUser("Failed to upload results to BM.Sense, see log for detais: " + ex.getMessage());
                log.error("Failed to upload results to BM.Sense", (Throwable)ex);
            }
        }
        if (this.isOnlineInitiated) {
            this.finishOnline(redirectLink);
        }
        this.clearData();
        if (this.hasStandardSet()) {
            PerfMonCollector.clearFiles();
        }
    }

    private void flush() {
        try {
            Class<ResultCollector> c = ResultCollector.class;
            Method m = c.getDeclaredMethod("flushFile", new Class[0]);
            m.invoke((Object)this, new Object[0]);
            log.info("Successfully flushed results file");
        }
        catch (NoSuchMethodException ex) {
            log.warn("Cannot flush results file since you are using old version of JMeter, consider upgrading to latest. Currently the results may be incomplete.");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to flush file", (Throwable)e);
        }
    }

    private boolean hasStandardSet() {
        boolean hasStandardSet = true;
        try {
            Class.forName("kg.apc.jmeter.perfmon.PerfMonCollector");
        }
        catch (ClassNotFoundException e) {
            hasStandardSet = false;
        }
        return hasStandardSet;
    }

    private void setupSaving(LoadosophiaUploader source) throws IOException {
        File tmpFile;
        log.debug("Set up saving with " + source);
        String dir = source.getStoreDir();
        try {
            if (dir == null || dir.trim().isEmpty()) {
                tmpFile = File.createTempFile("Sense_", ".jtl");
            } else {
                File storeDir = new File(dir);
                storeDir.mkdirs();
                tmpFile = File.createTempFile("Sense_", ".jtl", storeDir);
            }
        }
        catch (IOException ex) {
            source.informUser("Unable to create temp file: " + ex.getMessage());
            source.informUser("Try to set another directory in the above field.");
            throw ex;
        }
        this.fileName = tmpFile.getAbsolutePath();
        tmpFile.delete();
        source.informUser("Storing results for upload to Sense: " + this.fileName);
        this.setFilename(this.fileName);
        this.clearTemporary(this.getProperty("filename"));
        SampleSaveConfiguration conf = this.getSaveConfig();
        JMeterPluginsUtils.doBestCSVSetup(conf);
        this.setSaveConfig(conf);
    }

    public void sampleOccurred(SampleEvent event) {
        super.sampleOccurred(event);
        if (this.isOnlineInitiated) {
            try {
                if (!this.processingQueue.offer(event, 1L, TimeUnit.SECONDS)) {
                    log.warn("Failed first dequeue insert try, retrying");
                    if (!this.processingQueue.offer(event, 1L, TimeUnit.SECONDS)) {
                        log.error("Failed second try to inser into deque, dropped sample");
                    }
                }
            }
            catch (InterruptedException ex) {
                log.info("Interrupted while putting sample event into deque", (Throwable)ex);
            }
        }
    }

    @Override
    public void run() {
        while (this.isOnlineInitiated) {
            try {
                SampleEvent event = this.processingQueue.poll(1L, TimeUnit.SECONDS);
                if (event != null) {
                    this.aggregator.addSample(event);
                }
                if (!this.aggregator.haveDataToSend()) continue;
                try {
                    this.apiClient.sendOnlineData(this.aggregator.getDataToSend());
                }
                catch (IOException ex) {
                    log.warn("Failed to send active test data", (Throwable)ex);
                }
            }
            catch (InterruptedException ex) {
                log.debug("Interrupted while taking sample event from deque", (Throwable)ex);
                break;
            }
        }
    }

    private void initiateOnline(LoadosophiaUploader source) {
        if (source.isUseOnline()) {
            try {
                log.info("Starting BM.Sense online test");
                source.informUser("Started active test: " + this.apiClient.startOnline());
                this.aggregator = new LoadosophiaAggregator();
                this.processingQueue = new LinkedBlockingQueue<SampleEvent>();
                this.processorThread = new Thread(this);
                this.processorThread.setDaemon(true);
                this.isOnlineInitiated = true;
                this.processorThread.start();
            }
            catch (IOException ex) {
                source.informUser("Failed to start active test");
                log.warn("Failed to initiate active test", (Throwable)ex);
                this.isOnlineInitiated = false;
            }
        }
    }

    private void finishOnline(String redirectLink) {
        this.processorThread.interrupt();
        while (this.processorThread.isAlive() && !this.processorThread.isInterrupted()) {
            log.info("Waiting for aggregator thread to stop...");
            try {
                Thread.sleep(50L);
                this.processorThread.interrupt();
            }
            catch (InterruptedException ex) {
                log.warn("Interrupted sleep", (Throwable)ex);
            }
        }
        log.info("Ending BM.Sense online test");
        try {
            this.apiClient.endOnline(redirectLink);
        }
        catch (IOException ex) {
            log.warn("Failed to finalize active test", (Throwable)ex);
        }
        this.isOnlineInitiated = false;
    }

    protected LoadosophiaAPIClient getAPIClient(LoadosophiaUploader source) {
        return new LoadosophiaAPIClient(source, this.address, source.getUploadToken(), source.getProject(), source.getColorFlag(), source.getTitle());
    }

    public int getNumSources() {
        return this.sources.size();
    }

    public static void destroy() {
        instance = null;
    }
}

