/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.reporters;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class LoadosophiaAggregator {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private SortedMap<Long, List<SampleEvent>> buffer = new TreeMap<Long, List<SampleEvent>>();
    private static final long SEND_SECONDS = 5L;
    private long lastAggregatedTime = 0L;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private int numSources = 0;

    public void addSample(SampleEvent res) {
        Long time = res.getResult().getEndTime() / 1000L;
        if (!this.buffer.containsKey(time)) {
            if (time <= this.lastAggregatedTime) {
                log.debug("Got time " + time + " <= " + this.lastAggregatedTime);
                Iterator<Long> iterator = this.buffer.keySet().iterator();
                while (iterator.hasNext()) {
                    Long aLong;
                    time = aLong = iterator.next();
                }
            }
            this.buffer.put(time, new LinkedList());
        }
        ((List)this.buffer.get(time)).add(res);
    }

    public boolean haveDataToSend() {
        return (long)this.buffer.size() > this.getBufLen() + 1L;
    }

    private long getBufLen() {
        return 5L * (long)this.numSources;
    }

    public JSONArray getDataToSend() {
        JSONArray data = new JSONArray();
        Iterator<Long> it = this.buffer.keySet().iterator();
        int cnt = 0;
        while ((long)cnt < this.getBufLen() && it.hasNext()) {
            Long sec = it.next();
            List raw = (List)this.buffer.get(sec);
            data.add(this.getAggregateSecond(sec, raw));
            it.remove();
            ++cnt;
        }
        return data;
    }

    private JSONObject getAggregateSecond(Long sec, List<SampleEvent> raw) {
        JSONObject result = new JSONObject();
        this.lastAggregatedTime = sec;
        Date ts = new Date(sec * 1000L);
        log.debug("Aggregating " + sec);
        result.put("ts", this.format.format(ts));
        HashMap<String, Integer> threads = new HashMap<String, Integer>();
        int avg_rt = 0;
        Long[] rtimes = new Long[raw.size()];
        String[] rcodes = new String[raw.size()];
        int cnt = 0;
        int failedCount = 0;
        for (SampleEvent evt : raw) {
            SampleResult res = evt.getResult();
            if (!threads.containsKey(evt.getHostname())) {
                threads.put(evt.getHostname(), 0);
            }
            threads.put(evt.getHostname(), res.getAllThreads());
            avg_rt = (int)((long)avg_rt + res.getTime());
            rtimes[cnt] = res.getTime();
            rcodes[cnt] = res.getResponseCode();
            if (!res.isSuccessful()) {
                ++failedCount;
            }
            ++cnt;
        }
        long tsum = 0L;
        for (Integer tcount : threads.values()) {
            tsum += (long)tcount.intValue();
        }
        result.put("rps", (Object)cnt);
        result.put("threads", (Object)tsum);
        result.put("avg_rt", (Object)(avg_rt / cnt));
        result.put("quantiles", LoadosophiaAggregator.getQuantilesJSON(rtimes));
        result.put("net", this.getNetJSON(failedCount, cnt - failedCount));
        result.put("rc", this.getRCJSON(rcodes));
        result.put("planned_rps", (Object)0);
        return result;
    }

    public static JSONObject getQuantilesJSON(Long[] rtimes) {
        JSONObject result = new JSONObject();
        Arrays.sort((Object[])rtimes);
        double[] quantiles = new double[]{0.25, 0.5, 0.75, 0.8, 0.9, 0.95, 0.98, 0.99, 1.0};
        Stack<Long> timings = new Stack<Long>();
        timings.addAll(Arrays.asList(rtimes));
        double level = 1.0;
        Integer timing = 0;
        for (int qn = quantiles.length - 1; qn >= 0; --qn) {
            double quan = quantiles[qn];
            while (level >= quan && !timings.empty()) {
                timing = timings.pop();
                level -= 1.0 / (double)rtimes.length;
            }
            result.element(String.valueOf(quan * 100.0), timing);
        }
        return result;
    }

    private JSONObject getNetJSON(int failedCount, int succCount) {
        JSONObject result = new JSONObject();
        result.put("0", (Object)succCount);
        result.put("1", (Object)failedCount);
        return result;
    }

    private JSONObject getRCJSON(String[] rcodes) {
        JSONObject result = new JSONObject();
        for (String rcode : rcodes) {
            int oldval = 0;
            if (result.containsKey(rcode)) {
                oldval = (Integer)result.get(rcode);
            }
            result.put(rcode, (Object)(oldval + 1));
        }
        return result;
    }

    public void setNumSources(int numSources) {
        this.numSources = numSources;
    }
}

