/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.modifiers;

import kg.apc.jmeter.modifiers.FifoMap;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class FifoPopPreProcessor
extends AbstractTestElement
implements PreProcessor,
TestStateListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String queueName = "FifoName";
    public static final String variableName = "Variable";
    public static final String TIMEOUT = "Timeout";

    public FifoPopPreProcessor() {
        this.setTimeout(Long.toString(JMeterUtils.getPropDefault((String)"kg.apc.jmeter.functions.FifoTimeout", (long)Long.MAX_VALUE)));
    }

    public void testStarted() {
        FifoMap.getInstance().clear();
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded() {
        FifoMap.getInstance().clear();
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public void process() {
        String value = null;
        try {
            Object valueObj = FifoMap.getInstance().pop(this.getQueueName(), this.getTimeoutAsLong());
            if (valueObj != null) {
                value = valueObj.toString();
            }
        }
        catch (InterruptedException ex) {
            log.warn("Interrupted pop from queue " + this.getQueueName());
            value = "INTERRUPTED";
        }
        JMeterVariables vars = JMeterContextService.getContext().getVariables();
        if (vars != null) {
            vars.put(this.getVarName(), value);
        }
    }

    public String getVarName() {
        return this.getPropertyAsString(variableName);
    }

    private long getTimeoutAsLong() {
        String timeout = this.getTimeout();
        if (timeout.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(timeout);
    }

    public String getTimeout() {
        return this.getPropertyAsString(TIMEOUT);
    }

    public String getQueueName() {
        return this.getPropertyAsString(queueName);
    }

    public final void setTimeout(String atimeout) {
        this.setProperty(TIMEOUT, atimeout);
    }

    public void setVarName(String text) {
        this.setProperty(variableName, text);
    }

    public void setQueueName(String text) {
        this.setProperty(queueName, text);
    }
}

