/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads.arrivals;

import com.blazemeter.jmeter.threads.AbstractThreadStarter;
import com.blazemeter.jmeter.threads.arrivals.ArrivalsThreadGroup;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ArrivalsThreadStarter
extends AbstractThreadStarter {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private ArrivalsThreadGroup arrivalsTG;
    protected long scheduledCount = 0L;
    protected double rollingTime = 0.0;

    public ArrivalsThreadStarter(int groupIndex, ListenerNotifier listenerNotifier, ListedHashTree listedHashTree, StandardJMeterEngine standardJMeterEngine, ArrivalsThreadGroup owner) {
        super(groupIndex, owner, listedHashTree, listenerNotifier, standardJMeterEngine);
        this.arrivalsTG = owner;
    }

    @Override
    protected void supplyActiveThreads() throws InterruptedException {
        while (this.needMoreArrivals()) {
            if (this.arrivalsTG.releasedPoolThread()) continue;
            if (this.arrivalsTG.canCreateMoreThreads()) {
                this.addActiveThread();
                continue;
            }
            log.debug("Not creating thread because of concurrency limit");
        }
    }

    public synchronized boolean needMoreArrivals() throws InterruptedException {
        double currentRate;
        if (this.rollingTime > 0.0) {
            while (this.rollingTime >= (double)System.currentTimeMillis()) {
                long maxWait = (long)(this.rollingTime - (double)System.currentTimeMillis());
                if (maxWait <= 0L) continue;
                log.debug("Waiting " + maxWait);
                this.wait(maxWait);
            }
        } else {
            this.rollingTime = System.currentTimeMillis();
            this.startTime = this.rollingTime / 1000.0;
        }
        if ((currentRate = this.getCurrentRate()) < 0.0) {
            log.info("Duration limit reached, no more arrivals needed, had arrivals: " + this.scheduledCount);
            ((ArrivalsThreadGroup)this.owner).setArrivalsLimit(String.valueOf(this.scheduledCount));
            return false;
        }
        this.tickRollingTime(currentRate);
        return !this.owner.isLimitReached();
    }

    protected double getCurrentRate() {
        long rampUp = this.owner.getRampUpSeconds();
        long hold = this.owner.getHoldSeconds();
        long steps = this.owner.getStepsAsLong();
        double throughput = this.owner.getTargetLevelFactored();
        double timeOffset = this.rollingTime / 1000.0 - this.startTime;
        if (timeOffset >= (double)(rampUp + hold)) {
            return -1.0;
        }
        if (rampUp == 0L || timeOffset > (double)rampUp) {
            return throughput;
        }
        if (steps > 0L) {
            double stepSize = throughput / (double)steps;
            double stepLen = (double)rampUp / (double)steps;
            return stepSize * (Math.floor(timeOffset / stepLen) + 1.0);
        }
        double slope = throughput / (double)rampUp;
        return slope * Math.sqrt((double)(2L * this.scheduledCount) / slope);
    }

    protected void tickRollingTime(double currentRate) {
        double delay = currentRate > 0.0 ? 1000.0 / currentRate : 0.0;
        this.rollingTime += delay;
        ++this.scheduledCount;
    }
}

