/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.control;

import com.blazemeter.jmeter.control.WeightedSwitchController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.Grid;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class WeightedSwitchControllerGui
extends AbstractControllerGui {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String WEIGHTS = "Weight";
    private Grid grid;

    public WeightedSwitchControllerGui() {
        this.init();
        this.clearGui();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), ((Object)((Object)this)).getClass().getSimpleName()), "North");
        this.grid = new Grid("Child Item Weights", new String[]{"Name", WEIGHTS}, new Class[]{String.class, String.class}, new String[]{"", "100"});
        this.grid.getComponent(2).setVisible(false);
        this.add((Component)((Object)this.grid), "Center");
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public String getStaticLabel() {
        return "bzm - Weighted Switch Controller";
    }

    public TestElement createTestElement() {
        WeightedSwitchController te = new WeightedSwitchController();
        this.modifyTestElement((TestElement)te);
        return te;
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof WeightedSwitchController) {
            WeightedSwitchController wsc = (WeightedSwitchController)element;
            wsc.setData(this.grid.getModel());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        log.debug("Props: " + this.isShowing() + " " + this.isVisible() + " " + this.isEnabled() + " " + this.isFocusOwner());
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null && element instanceof WeightedSwitchController) {
            WeightedSwitchController wsc = (WeightedSwitchController)element;
            CollectionProperty oldData = wsc.getData();
            this.grid.getModel().clearData();
            if (this.isShowing()) {
                this.fillGridFromTree(wsc, oldData);
            } else {
                JMeterPluginsUtils.collectionPropertyToTableModelRows(oldData, this.grid.getModel());
            }
        }
    }

    private void fillGridFromTree(WeightedSwitchController wsc, CollectionProperty oldData) {
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        JMeterTreeNode root = (JMeterTreeNode)treeModel.getRoot();
        LinkedList<JMeterTreeNode> childItems = this.getChildItems(root, wsc);
        for (int n = 0; n < childItems.size(); ++n) {
            JMeterProperty row;
            JMeterTreeNode node = childItems.get(n);
            String w = "100";
            if (oldData.size() > n && oldData.get(n) != null && (row = oldData.get(n)) instanceof CollectionProperty) {
                w = ((CollectionProperty)row).get(1).getStringValue();
            }
            this.grid.getModel().addRow((Object[])new String[]{node.getTestElement().getName(), w});
        }
    }

    private LinkedList<JMeterTreeNode> getChildItems(JMeterTreeNode root, WeightedSwitchController element) {
        LinkedList<JMeterTreeNode> result = new LinkedList<JMeterTreeNode>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            JMeterTreeNode child = (JMeterTreeNode)root.getChildAt(i);
            TestElement te = child.getTestElement();
            if (element != root.getTestElement()) {
                result.addAll(this.getChildItems(child, element));
                continue;
            }
            if (!(te instanceof Sampler) && !(te instanceof Controller)) continue;
            result.add(child);
        }
        return result;
    }

    public void clearGui() {
        super.clearGui();
        this.grid.getModel().clearData();
    }
}

