/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.protocol.http.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.control.gui.LogicControllerGui;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.protocol.http.control.HttpSimpleTableControl;

public class HttpSimpleTableControlGui
extends LogicControllerGui
implements JMeterGUIComponent,
ActionListener,
UnsharedComponent {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String WIKIPAGE = "HttpSimpleTableServer";
    private JTextField portField;
    private JTextField datasetDirectoryField;
    private JCheckBox timestampChkBox;
    private JButton stop;
    private JButton start;
    private static final String ACTION_STOP = "stop";
    private static final String ACTION_START = "start";
    private HttpSimpleTableControl simpleTableController;

    public HttpSimpleTableControlGui() {
        log.debug("Creating HttpSimpleTableControlGui");
        this.init();
    }

    public TestElement createTestElement() {
        this.simpleTableController = new HttpSimpleTableControl();
        log.debug("creating/configuring model = " + (Object)((Object)this.simpleTableController));
        this.modifyTestElement((TestElement)this.simpleTableController);
        return this.simpleTableController;
    }

    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        if (el instanceof HttpSimpleTableControl) {
            this.simpleTableController = (HttpSimpleTableControl)el;
            if (this.portField.getText().isEmpty()) {
                this.simpleTableController.setPort(HttpSimpleTableControl.DEFAULT_PORT_S);
            } else {
                this.simpleTableController.setPort(this.portField.getText());
            }
            if (this.datasetDirectoryField.getText().isEmpty()) {
                this.simpleTableController.setDataDir(HttpSimpleTableControl.DEFAULT_DATA_DIR);
            } else {
                this.simpleTableController.setDataDir(this.datasetDirectoryField.getText());
            }
            this.simpleTableController.setTimestamp(this.timestampChkBox.isSelected());
        }
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("HTTP Simple Table Server");
    }

    public Collection<String> getMenuCategories() {
        return Arrays.asList("menu_non_test_elements");
    }

    public void configure(TestElement element) {
        log.debug("Configuring gui with " + element);
        super.configure(element);
        this.simpleTableController = (HttpSimpleTableControl)element;
        this.portField.setText(this.simpleTableController.getPortString());
        this.datasetDirectoryField.setText(this.simpleTableController.getDataDir());
        this.timestampChkBox.setSelected(this.simpleTableController.getTimestamp());
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        String command = action.getActionCommand();
        IOException except = null;
        if (command.equals(ACTION_STOP)) {
            this.simpleTableController.stopHttpSimpleTable();
            this.stop.setEnabled(false);
            this.start.setEnabled(true);
        } else if (command.equals(ACTION_START)) {
            this.modifyTestElement((TestElement)this.simpleTableController);
            try {
                this.simpleTableController.startHttpSimpleTable();
            }
            catch (IOException e) {
                e.printStackTrace();
                except = e;
            }
            if (null == except) {
                this.start.setEnabled(false);
                this.stop.setEnabled(true);
            }
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        Box myBox = Box.createVerticalBox();
        myBox.add(this.createPortPanel());
        mainPanel.add((Component)myBox, "North");
        mainPanel.add((Component)this.createControls(), "Center");
        this.add(mainPanel, "Center");
    }

    private JPanel createControls() {
        this.start = new JButton(JMeterUtils.getResString((String)ACTION_START));
        this.start.addActionListener(this);
        this.start.setActionCommand(ACTION_START);
        this.start.setEnabled(true);
        this.stop = new JButton(JMeterUtils.getResString((String)ACTION_STOP));
        this.stop.addActionListener(this);
        this.stop.setActionCommand(ACTION_STOP);
        this.stop.setEnabled(false);
        JPanel panel = new JPanel();
        panel.add(this.start);
        panel.add(this.stop);
        return panel;
    }

    private JPanel createPortPanel() {
        this.portField = new JTextField(HttpSimpleTableControl.DEFAULT_PORT_S, 8);
        this.portField.setName("HttpSimpleTableControlGui.port");
        JLabel label = new JLabel(JMeterUtils.getResString((String)"port"));
        label.setLabelFor(this.portField);
        this.datasetDirectoryField = new JTextField(HttpSimpleTableControl.DEFAULT_DATA_DIR, 8);
        this.datasetDirectoryField.setName("HttpSimpleTableControlGui.dir");
        JLabel ddLabel = new JLabel("Dataset directory:");
        ddLabel.setLabelFor(this.datasetDirectoryField);
        this.timestampChkBox = new JCheckBox();
        this.timestampChkBox.setSelected(true);
        this.timestampChkBox.setName("HttpSimpleTableControlGui.timestamp");
        JLabel tsLabel = new JLabel("Timestamp:");
        tsLabel.setLabelFor(this.timestampChkBox);
        HorizontalPanel panel = new HorizontalPanel();
        panel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Settings"));
        panel.add((Component)label);
        panel.add((Component)this.portField);
        panel.add((Component)ddLabel);
        panel.add((Component)this.datasetDirectoryField);
        panel.add((Component)tsLabel);
        panel.add((Component)this.timestampChkBox);
        panel.add(Box.createHorizontalStrut(10));
        return panel;
    }

    public void clearGui() {
        super.clearGui();
        this.portField.setText(HttpSimpleTableControl.DEFAULT_PORT_S);
        this.datasetDirectoryField.setText(HttpSimpleTableControl.DEFAULT_DATA_DIR);
        this.timestampChkBox.setSelected(true);
    }
}

