/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.modifiers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.BrowseAction;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import kg.apc.jmeter.modifiers.CheckConsistencyAction;
import kg.apc.jmeter.modifiers.RawRequestSourcePreProcessor;
import org.apache.jmeter.processor.gui.AbstractPreProcessorGui;
import org.apache.jmeter.testelement.TestElement;

public class RawRequestSourcePreProcessorGui
extends AbstractPreProcessorGui {
    public static final String WIKIPAGE = "RawDataSource";
    private JCheckBox rewindOnEOF;
    private JTextField variableName;
    private JTextField fileName;
    private JButton browseButton;
    private JButton checkButton;
    private JTextArea checkInfo;
    private JCheckBox encodeHex;

    public RawRequestSourcePreProcessorGui() {
        this.init();
        this.initFields();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Raw Data Source PreProcessor");
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.rewindOnEOF.setSelected(element.getPropertyAsBoolean("rewind"));
        this.variableName.setText(element.getPropertyAsString("variable_name"));
        this.fileName.setText(element.getPropertyAsString("filename"));
        this.encodeHex.setSelected(element.getPropertyAsBoolean("isHex"));
    }

    public TestElement createTestElement() {
        RawRequestSourcePreProcessor preproc = new RawRequestSourcePreProcessor();
        this.modifyTestElement((TestElement)preproc);
        preproc.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return preproc;
    }

    public void modifyTestElement(TestElement te) {
        this.configureTestElement(te);
        if (te instanceof RawRequestSourcePreProcessor) {
            RawRequestSourcePreProcessor preproc = (RawRequestSourcePreProcessor)te;
            preproc.setRewindOnEOF(this.rewindOnEOF.isSelected());
            preproc.setVarName(this.variableName.getText());
            preproc.setFileName(this.fileName.getText());
            preproc.setEncodeHex(this.encodeHex.isSelected());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("Rewind on end of file: ", 4));
        this.rewindOnEOF = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.rewindOnEOF);
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("Data file path: ", 4));
        this.fileName = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.fileName);
        this.browseButton = new JButton("Browse...");
        this.addToPanel(mainPanel, labelConstraints, 2, 1, this.browseButton);
        GuiBuilderHelper.strechItemToComponent(this.fileName, this.browseButton);
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.browseButton.addActionListener(new BrowseAction(this.fileName));
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("Variable name: ", 4));
        this.variableName = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.variableName);
        this.addToPanel(mainPanel, labelConstraints, 0, 3, new JLabel("Encode read data as HEX: ", 4));
        this.encodeHex = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 3, this.encodeHex);
        editConstraints.insets = new Insets(4, 0, 0, 0);
        labelConstraints.insets = new Insets(4, 0, 0, 2);
        this.checkButton = new JButton("Check File Consistency");
        this.addToPanel(mainPanel, labelConstraints, 0, 4, this.checkButton);
        labelConstraints.insets = new Insets(4, 0, 0, 0);
        this.checkInfo = new JTextArea();
        this.addToPanel(mainPanel, editConstraints, 1, 4, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.checkInfo, 10));
        this.checkButton.addActionListener(new CheckConsistencyAction(this.fileName, this.checkInfo));
        this.checkInfo.setEditable(false);
        this.checkInfo.setOpaque(false);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    private void initFields() {
        this.rewindOnEOF.setSelected(true);
        this.variableName.setText("rawData");
        this.fileName.setText("");
        this.checkInfo.setText("");
        this.encodeHex.setSelected(false);
    }
}

