/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.config.redis;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ResourceBundle;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.engine.util.NoConfigMerge;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterStopThreadException;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisDataSet
extends ConfigTestElement
implements TestBean,
LoopIterationListener,
NoConfigMerge,
TestStateListener {
    private static final long serialVersionUID = 7383500755324202605L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final Integer DEFAULT_PORT = 6379;
    public static final Integer DEFAULT_TIMEOUT = 2000;
    public static final Integer DEFAULT_DATABASE = 0;
    private String host;
    private String port;
    private String timeout;
    private String password;
    private String database;
    private String redisKey;
    private String variableNames;
    private String delimiter;
    private GetMode getMode;
    private int maxIdle;
    private int minIdle;
    private int maxActive;
    private long maxWait;
    private WhenExhaustedAction whenExhaustedAction;
    private boolean testOnBorrow;
    private boolean testOnReturn;
    private boolean testWhileIdle;
    private long timeBetweenEvictionRunsMillis;
    private int numTestsPerEvictionRun;
    private long minEvictableIdleTimeMillis;
    private long softMinEvictableIdleTimeMillis;
    private transient String[] vars;
    private transient JedisPool pool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterationStart(LoopIterationEvent event) {
        Jedis connection = null;
        try {
            connection = (Jedis)this.pool.getResource();
            String line = null;
            line = this.getMode.equals((Object)GetMode.RANDOM_REMOVE) ? connection.lpop(this.redisKey) : connection.srandmember(this.redisKey);
            if (line == null) {
                throw new JMeterStopThreadException("End of redis data detected, thread will exit");
            }
            String names = this.variableNames;
            if (this.vars == null) {
                this.vars = JOrphanUtils.split((String)names, (String)",");
            }
            JMeterContext context = this.getThreadContext();
            JMeterVariables threadVars = context.getVariables();
            String[] values = JOrphanUtils.split((String)line, (String)this.delimiter, (boolean)false);
            for (int a = 0; a < this.vars.length && a < values.length; ++a) {
                threadVars.put(this.vars[a], values[a]);
            }
        }
        finally {
            this.pool.returnResource((Object)connection);
        }
    }

    public void testEnded() {
        this.testEnded("");
    }

    public void testEnded(String host) {
        this.pool.destroy();
    }

    public void testStarted() {
        this.testStarted("");
    }

    public Object clone() {
        RedisDataSet clonedElement = (RedisDataSet)((Object)super.clone());
        clonedElement.pool = this.pool;
        return clonedElement;
    }

    public void setProperty(JMeterProperty property) {
        if (property instanceof StringProperty) {
            String pn = property.getName();
            if (pn.equals("getMode")) {
                Object objectValue = property.getObjectValue();
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(((Object)((Object)this)).getClass());
                    ResourceBundle rb = (ResourceBundle)beanInfo.getBeanDescriptor().getValue("resourceBundle");
                    for (GetMode e : GetMode.values()) {
                        String propName = e.toString();
                        if (!objectValue.equals(rb.getObject(propName))) continue;
                        int tmpMode = e.ordinal();
                        if (log.isDebugEnabled()) {
                            log.debug("Converted " + pn + "=" + objectValue + " to mode=" + tmpMode + " using Locale: " + rb.getLocale());
                        }
                        super.setProperty(pn, tmpMode);
                        return;
                    }
                    log.warn("Could not convert " + pn + "=" + objectValue + " using Locale: " + rb.getLocale());
                }
                catch (IntrospectionException e) {
                    log.error("Could not find BeanInfo", (Throwable)e);
                }
            } else if (pn.equals("whenExhaustedAction")) {
                Object objectValue = property.getObjectValue();
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(((Object)((Object)this)).getClass());
                    ResourceBundle rb = (ResourceBundle)beanInfo.getBeanDescriptor().getValue("resourceBundle");
                    for (WhenExhaustedAction e : WhenExhaustedAction.values()) {
                        String propName = e.toString();
                        if (!objectValue.equals(rb.getObject(propName))) continue;
                        int tmpMode = e.ordinal();
                        if (log.isDebugEnabled()) {
                            log.debug("Converted " + pn + "=" + objectValue + " to mode=" + tmpMode + " using Locale: " + rb.getLocale());
                        }
                        super.setProperty(pn, tmpMode);
                        return;
                    }
                    log.warn("Could not convert " + pn + "=" + objectValue + " using Locale: " + rb.getLocale());
                }
                catch (IntrospectionException e) {
                    log.error("Could not find BeanInfo", (Throwable)e);
                }
            }
        }
        super.setProperty(property);
    }

    public void testStarted(String distributedHost) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxActive(this.getMaxActive());
        config.setMaxIdle(this.getMaxIdle());
        config.setMinIdle(this.getMinIdle());
        config.setMaxWait(this.getMaxWait());
        config.setWhenExhaustedAction((byte)this.getWhenExhaustedAction());
        config.setTestOnBorrow(this.getTestOnBorrow());
        config.setTestOnReturn(this.getTestOnReturn());
        config.setTestWhileIdle(this.getTestWhileIdle());
        config.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        config.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
        config.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        config.setSoftMinEvictableIdleTimeMillis(this.getSoftMinEvictableIdleTimeMillis());
        int port = 6379;
        if (!JOrphanUtils.isBlank((String)this.port)) {
            port = Integer.parseInt(this.port);
        }
        int timeout = 2000;
        if (!JOrphanUtils.isBlank((String)this.timeout)) {
            timeout = Integer.parseInt(this.timeout);
        }
        int database = 0;
        if (!JOrphanUtils.isBlank((String)this.database)) {
            database = Integer.parseInt(this.database);
        }
        String password = null;
        if (!JOrphanUtils.isBlank((String)this.password)) {
            password = this.password;
        }
        this.pool = new JedisPool((GenericObjectPool.Config)config, this.host, port, timeout, password, database);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getRedisKey() {
        return this.redisKey;
    }

    public void setRedisKey(String redisKey) {
        this.redisKey = redisKey;
    }

    public String getVariableNames() {
        return this.variableNames;
    }

    public void setVariableNames(String variableNames) {
        this.variableNames = variableNames;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public int getWhenExhaustedAction() {
        return this.whenExhaustedAction.ordinal();
    }

    public void setWhenExhaustedAction(int whenExhaustedAction) {
        this.whenExhaustedAction = WhenExhaustedAction.values()[whenExhaustedAction];
    }

    public boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    public void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
    }

    public int getGetMode() {
        return this.getMode.ordinal();
    }

    public void setGetMode(int mode) {
        this.getMode = GetMode.values()[mode];
    }

    public static enum GetMode {
        RANDOM_REMOVE(0),
        RANDOM_KEEP(1);

        private byte value;

        private GetMode(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static enum WhenExhaustedAction {
        FAIL(0),
        BLOCK(1),
        GROW(2);

        private byte value;

        private WhenExhaustedAction(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

