/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import android.graphics.PointF;
import java.util.Arrays;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageVignetteFilter;
import jp.wasabeef.glide.transformations.gpu.GPUFilterTransformation;

public class VignetteFilterTransformation
extends GPUFilterTransformation {
    private PointF center;
    private float[] vignetteColor;
    private float vignetteStart;
    private float vignetteEnd;

    public VignetteFilterTransformation() {
        this(new PointF(0.5f, 0.5f), new float[]{0.0f, 0.0f, 0.0f}, 0.0f, 0.75f);
    }

    public VignetteFilterTransformation(PointF center, float[] color, float start, float end) {
        super((GPUImageFilter)new GPUImageVignetteFilter());
        this.center = center;
        this.vignetteColor = color;
        this.vignetteStart = start;
        this.vignetteEnd = end;
        GPUImageVignetteFilter filter = (GPUImageVignetteFilter)this.getFilter();
        filter.setVignetteCenter(this.center);
        filter.setVignetteColor(this.vignetteColor);
        filter.setVignetteStart(this.vignetteStart);
        filter.setVignetteEnd(this.vignetteEnd);
    }

    @Override
    public String key() {
        return "VignetteFilterTransformation(center=" + this.center.toString() + ",color=" + Arrays.toString(this.vignetteColor) + ",start=" + this.vignetteStart + ",end=" + this.vignetteEnd + ")";
    }
}

