/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.wasabeef.glide.transformations.BitmapTransformation;

public class GPUFilterTransformation
extends BitmapTransformation {
    private GPUImageFilter gpuImageFilter;

    public GPUFilterTransformation(GPUImageFilter filter) {
        this.gpuImageFilter = filter;
    }

    @Override
    protected Bitmap transform(@NonNull Context context, @NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        GPUImage gpuImage = new GPUImage(context);
        gpuImage.setImage(toTransform);
        gpuImage.setFilter(this.gpuImageFilter);
        return gpuImage.getBitmapWithFilterApplied();
    }

    @Override
    public String key() {
        return this.getClass().getSimpleName();
    }

    public <T> T getFilter() {
        return (T)this.gpuImageFilter;
    }
}

