/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import jp.wasabeef.glide.transformations.BitmapTransformation;

public class CropTransformation
extends BitmapTransformation {
    private int width;
    private int height;
    private CropType cropType = CropType.CENTER;

    public CropTransformation(int width, int height) {
        this(width, height, CropType.CENTER);
    }

    public CropTransformation(int width, int height, CropType cropType) {
        this.width = width;
        this.height = height;
        this.cropType = cropType;
    }

    @Override
    protected Bitmap transform(@NonNull Context context, @NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        this.width = this.width == 0 ? toTransform.getWidth() : this.width;
        this.height = this.height == 0 ? toTransform.getHeight() : this.height;
        Bitmap.Config config = toTransform.getConfig() != null ? toTransform.getConfig() : Bitmap.Config.ARGB_8888;
        Bitmap bitmap = pool.get(this.width, this.height, config);
        bitmap.setHasAlpha(true);
        float scaleX = (float)this.width / (float)toTransform.getWidth();
        float scaleY = (float)this.height / (float)toTransform.getHeight();
        float scale = Math.max(scaleX, scaleY);
        float scaledWidth = scale * (float)toTransform.getWidth();
        float scaledHeight = scale * (float)toTransform.getHeight();
        float left = ((float)this.width - scaledWidth) / 2.0f;
        float top = this.getTop(scaledHeight);
        RectF targetRect = new RectF(left, top, left + scaledWidth, top + scaledHeight);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawBitmap(toTransform, null, targetRect, null);
        return bitmap;
    }

    @Override
    public String key() {
        return "CropTransformation(width=" + this.width + ", height=" + this.height + ", cropType=" + (Object)((Object)this.cropType) + ")";
    }

    private float getTop(float scaledHeight) {
        switch (this.cropType) {
            case TOP: {
                return 0.0f;
            }
            case CENTER: {
                return ((float)this.height - scaledHeight) / 2.0f;
            }
            case BOTTOM: {
                return (float)this.height - scaledHeight;
            }
        }
        return 0.0f;
    }

    public static enum CropType {
        TOP,
        CENTER,
        BOTTOM;

    }
}

