/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf.transports;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Properties;
import org.jgroups.stack.IpAddress;
import org.jgroups.tests.perf.Receiver;
import org.jgroups.tests.perf.Transport;

public class UdpTransport
implements Transport {
    Receiver receiver = null;
    Properties config = null;
    InetAddress mcast_addr = null;
    int mcast_port = 7500;
    InetAddress bind_addr = null;
    MulticastSocket mcast_sock = null;
    DatagramSocket ucast_sock = null;
    IpAddress local_addr = null;
    ReceiverThread mcast_receiver = null;
    ReceiverThread ucast_receiver = null;
    int max_receiver_buffer_size = 500000;
    int max_send_buffer_size = 500000;

    public Object getLocalAddress() {
        return this.local_addr;
    }

    public void create(Properties properties) throws Exception {
        this.config = properties;
        String mcast_addr_str = System.getProperty("udp.mcast_addr", this.config.getProperty("mcast_addr"));
        if (mcast_addr_str == null) {
            mcast_addr_str = "228.8.8.8";
        }
        this.mcast_addr = InetAddress.getByName(mcast_addr_str);
        String bind_addr_str = System.getProperty("udp.bind_addr", this.config.getProperty("bind_addr"));
        this.bind_addr = bind_addr_str != null ? InetAddress.getByName(bind_addr_str) : InetAddress.getLocalHost();
        this.ucast_sock = new DatagramSocket(0, this.bind_addr);
        this.ucast_sock.setReceiveBufferSize(this.max_receiver_buffer_size);
        this.ucast_sock.setSendBufferSize(this.max_send_buffer_size);
        this.mcast_sock = new MulticastSocket(this.mcast_port);
        this.mcast_sock.setReceiveBufferSize(this.max_receiver_buffer_size);
        this.mcast_sock.setSendBufferSize(this.max_send_buffer_size);
        if (this.bind_addr != null) {
            this.mcast_sock.setInterface(this.bind_addr);
        }
        this.mcast_sock.joinGroup(this.mcast_addr);
        this.local_addr = new IpAddress(this.ucast_sock.getLocalAddress(), this.ucast_sock.getLocalPort());
        System.out.println("-- local_addr is " + this.local_addr);
    }

    public void start() throws Exception {
        this.mcast_receiver = new ReceiverThread(this.mcast_sock);
        this.ucast_receiver = new ReceiverThread(this.ucast_sock);
        this.mcast_receiver.start();
        this.ucast_receiver.start();
    }

    public void stop() {
        if (this.mcast_receiver != null) {
            this.mcast_receiver.stop();
        }
        if (this.ucast_receiver != null) {
            this.ucast_receiver.stop();
        }
    }

    public void destroy() {
        if (this.mcast_sock != null) {
            this.mcast_sock.close();
        }
        if (this.ucast_sock != null) {
            this.ucast_sock.close();
        }
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public void send(Object destination, byte[] payload) throws Exception {
        DatagramPacket p;
        if (destination == null) {
            p = new DatagramPacket(payload, payload.length, this.mcast_addr, this.mcast_port);
        } else {
            IpAddress addr = (IpAddress)destination;
            p = new DatagramPacket(payload, payload.length, addr.getIpAddress(), addr.getPort());
        }
        this.ucast_sock.send(p);
    }

    class ReceiverThread
    implements Runnable {
        DatagramSocket sock;
        Thread t = null;

        ReceiverThread(DatagramSocket sock) {
            this.sock = sock;
        }

        void start() throws Exception {
            this.t = new Thread((Runnable)this, "ReceiverThread for " + this.sock.getLocalAddress() + ':' + this.sock.getLocalPort());
            this.t.start();
        }

        void stop() {
            this.t = null;
            if (this.sock != null) {
                this.sock.close();
            }
        }

        public void run() {
            byte[] buf = new byte[128000];
            while (this.t != null) {
                DatagramPacket p = new DatagramPacket(buf, buf.length);
                try {
                    this.sock.receive(p);
                    if (UdpTransport.this.receiver == null) continue;
                    IpAddress addr = new IpAddress(p.getAddress(), p.getPort());
                    UdpTransport.this.receiver.receive(addr, p.getData());
                }
                catch (IOException e) {
                    if (this.sock != null) continue;
                    this.t = null;
                }
            }
            this.t = null;
        }
    }
}

