/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class ConnectTest
extends TestCase {
    JChannel channel;
    final int TIMES = 10;
    String props = "UDP(mcast_addr=228.8.8.8;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=false)";

    public ConnectTest(String name) {
        super(name);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    void doIt(int times) {
        for (int i = 0; i < times; ++i) {
            System.out.println("\nAttempt #" + (i + 1));
            System.out.print("Connecting to channel: ");
            try {
                this.channel.connect("ConnectTest");
                System.out.println("-- connected --");
            }
            catch (Exception e) {
                System.out.println("-- connection failed --");
                System.err.println(e);
            }
            System.out.print("Disconnecting from channel: ");
            this.channel.disconnect();
            System.out.println("-- disconnected --");
        }
    }

    public void testConnectAndDisconnect() throws Exception {
        System.out.print("Creating channel: ");
        this.channel = new JChannel(this.props);
        System.out.println("-- created --");
        this.doIt(10);
        System.out.print("Closing channel: ");
        this.channel.close();
        System.out.println("-- closed --");
        this.channel.close();
        System.out.println("Remaining threads are:");
        Util.printThreads();
    }

    public void testDisconnectConnectOne() throws Exception {
        this.channel = new JChannel(this.props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup2");
        View view = this.channel.getView();
        ConnectTest.assertEquals((int)1, (int)view.size());
        ConnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
    }

    public void testDisconnectConnectTwo() throws Exception {
        JChannel coordinator = new JChannel(this.props);
        coordinator.connect("testgroup");
        View view = coordinator.getView();
        System.out.println("-- view for coordinator: " + view);
        this.channel = new JChannel(this.props);
        this.channel.connect("testgroup1");
        view = this.channel.getView();
        System.out.println("-- view for channel: " + view);
        this.channel.disconnect();
        this.channel.connect("testgroup");
        view = this.channel.getView();
        System.out.println("-- view for channel: " + view);
        ConnectTest.assertEquals((int)2, (int)view.size());
        ConnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
        ConnectTest.assertTrue((boolean)view.containsMember(coordinator.getLocalAddress()));
        coordinator.close();
    }

    public void testDisconnectConnectSendTwo() throws Exception {
        Promise msgPromise = new Promise();
        JChannel coordinator = new JChannel(this.props);
        coordinator.connect("testgroup");
        PullPushAdapter ppa = new PullPushAdapter((Transport)coordinator, new PromisedMessageListener(msgPromise));
        ppa.start();
        this.channel = new JChannel(this.props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = (Message)msgPromise.getResult(20000L);
        ConnectTest.assertTrue((msg != null ? 1 : 0) != 0);
        ConnectTest.assertEquals((Object)"payload", (Object)msg.getObject());
        ppa.stop();
        coordinator.close();
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ConnectTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private class PromisedMessageListener
    implements MessageListener {
        private Promise promise;

        public PromisedMessageListener(Promise promise) {
            this.promise = promise;
        }

        public byte[] getState() {
            return null;
        }

        public void receive(Message msg) {
            this.promise.setResult(msg);
        }

        public void setState(byte[] state) {
        }
    }
}

