/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.protocols.AUTOCONF;
import org.jgroups.protocols.UdpHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.List;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class UDP
extends Protocol
implements Runnable {
    DatagramSocket sock = null;
    private static BoundedList last_ports_used = null;
    int num_last_ports = 100;
    MulticastSocket mcast_recv_sock = null;
    MulticastSocket mcast_send_sock = null;
    IpAddress local_addr = null;
    String channel_name = null;
    UdpHeader udp_hdr = null;
    IpAddress mcast_addr = null;
    InetAddress bind_addr = null;
    boolean bind_to_all_interfaces = false;
    int bind_port = 0;
    int port_range = 1;
    String mcast_addr_name = "228.8.8.8";
    int mcast_port = 7600;
    Thread mcast_receiver = null;
    UcastReceiver ucast_receiver = null;
    boolean ip_mcast = true;
    int ip_ttl = 64;
    final Vector members = new Vector(11);
    final ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(1024);
    int mcast_send_buf_size = 32000;
    int mcast_recv_buf_size = 64000;
    int ucast_send_buf_size = 32000;
    int ucast_recv_buf_size = 64000;
    boolean loopback = true;
    boolean discard_incompatible_packets = false;
    boolean use_incoming_packet_handler = false;
    Queue incoming_queue = null;
    IncomingPacketHandler incoming_packet_handler = null;
    boolean use_outgoing_packet_handler = false;
    Queue outgoing_queue = null;
    OutgoingPacketHandler outgoing_packet_handler = null;
    byte[] additional_data = null;
    int max_bundle_size = AUTOCONF.senseMaxFragSizeStatic();
    long max_bundle_timeout = 20L;
    boolean enable_bundling = false;
    TimeScheduler timer = null;
    HashMap addr_translation_table = new HashMap();
    boolean use_addr_translation = false;
    static final String name = "UDP";
    static final String IGNORE_BIND_ADDRESS_PROPERTY = "ignore.bind.address";
    final int VERSION_LENGTH = Version.getLength();

    public String toString() {
        return "Protocol UDP(local address: " + this.local_addr + ')';
    }

    BoundedList getLastPortsUsed() {
        if (last_ports_used == null) {
            last_ports_used = new BoundedList(this.num_last_ports);
        }
        return last_ports_used;
    }

    public void run() {
        byte[] receive_buf = new byte[65535];
        DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
        while (this.mcast_receiver != null && this.mcast_recv_sock != null) {
            try {
                StringBuffer sb;
                packet.setData(receive_buf, 0, receive_buf.length);
                this.mcast_recv_sock.receive(packet);
                InetAddress sender_addr = packet.getAddress();
                int sender_port = packet.getPort();
                int len = packet.getLength();
                byte[] data = packet.getData();
                if (len == 4 && data[0] == 100 && data[1] == 105 && data[2] == 97 && data[3] == 103) {
                    this.handleDiagnosticProbe(sender_addr, sender_port);
                    continue;
                }
                if (this.log.isTraceEnabled()) {
                    sb = new StringBuffer("received (mcast) ");
                    sb.append(len).append(" bytes from ").append(sender_addr).append(':');
                    sb.append(sender_port).append(" (size=").append(len).append(" bytes)");
                    this.log.trace((Object)sb.toString());
                }
                if (len > receive_buf.length && this.log.isErrorEnabled()) {
                    this.log.error((Object)("size of the received packet (" + len + ") is bigger than " + "allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG protocol and make its frag_size lower than " + receive_buf.length));
                }
                if (!Version.compareTo(data)) {
                    if (this.log.isWarnEnabled()) {
                        sb = new StringBuffer();
                        sb.append("packet from ").append(sender_addr).append(':').append(sender_port);
                        sb.append(" has different version (").append(Version.printVersionId(data, Version.version_id.length));
                        sb.append(") from ours (").append(Version.printVersionId(Version.version_id)).append("). ");
                        if (this.discard_incompatible_packets) {
                            sb.append("Packet is discarded");
                        } else {
                            sb.append("This may cause problems");
                        }
                        this.log.warn((Object)sb.toString());
                    }
                    if (this.discard_incompatible_packets) continue;
                }
                if (this.use_incoming_packet_handler) {
                    byte[] tmp = new byte[len];
                    System.arraycopy(data, 0, tmp, 0, len);
                    this.incoming_queue.add(new IncomingQueueEntry(this.mcast_addr, sender_addr, sender_port, tmp));
                    continue;
                }
                this.handleIncomingUdpPacket(this.mcast_addr, sender_addr, sender_port, data);
            }
            catch (SocketException sock_ex) {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace((Object)("multicast socket is closed, exception=" + sock_ex));
                break;
            }
            catch (InterruptedIOException io_ex) {
            }
            catch (Throwable ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"failure in multicast receive()", ex);
                }
                Util.sleep(100L);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"multicast thread terminated");
        }
    }

    void handleDiagnosticProbe(InetAddress sender, int port) {
        block3: {
            try {
                byte[] diag_rsp = this.getDiagResponse().getBytes();
                DatagramPacket rsp = new DatagramPacket(diag_rsp, 0, diag_rsp.length, sender, port);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("sending diag response to " + sender + ':' + port));
                }
                this.sock.send(rsp);
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error((Object)("failed sending diag rsp to " + sender + ':' + port + ", exception=" + t));
            }
        }
    }

    String getDiagResponse() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.local_addr).append(" (").append(this.channel_name).append(')');
        sb.append(" [").append(this.mcast_addr_name).append(':').append(this.mcast_port).append("]\n");
        sb.append("Version=").append("2.2.8").append(", cvs=\"").append("$Id: Version.java,v 1.18.2.1 2005/05/30 09:47:56 belaban Exp $").append("\"\n");
        sb.append("bound to ").append(this.bind_addr).append(':').append(this.bind_port).append('\n');
        sb.append("members: ").append(this.members).append('\n');
        return sb.toString();
    }

    public String getName() {
        return name;
    }

    public void init() throws Exception {
        if (this.use_incoming_packet_handler) {
            this.incoming_queue = new Queue();
            this.incoming_packet_handler = new IncomingPacketHandler();
        }
        if (this.use_outgoing_packet_handler) {
            this.outgoing_queue = new Queue();
            if (this.enable_bundling) {
                TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
                if (this.timer == null) {
                    throw new Exception("timer could not be retrieved");
                }
                this.outgoing_packet_handler = new BundlingOutgoingPacketHandler();
            } else {
                this.outgoing_packet_handler = new OutgoingPacketHandler();
            }
        }
    }

    public void start() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"creating sockets and starting threads");
        }
        this.createSockets();
        this.passUp(new Event(8, this.local_addr));
        this.startThreads();
    }

    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"closing sockets and stopping threads");
        }
        this.stopThreads();
        this.closeSockets();
    }

    public boolean setProperties(Properties props) {
        String tmp = null;
        super.setProperties(props);
        try {
            tmp = System.getProperty("bind.address");
            if (Boolean.getBoolean(IGNORE_BIND_ADDRESS_PROPERTY)) {
                tmp = null;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        String str = tmp != null ? tmp : props.getProperty("bind_addr");
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal((Object)("(bind_addr): host " + str + " not known"));
                }
                return false;
            }
            props.remove("bind_addr");
        }
        if ((str = props.getProperty("bind_to_all_interfaces")) != null) {
            this.bind_to_all_interfaces = new Boolean(str);
            props.remove("bind_to_all_interfaces");
        }
        if ((str = props.getProperty("bind_port")) != null) {
            this.bind_port = Integer.parseInt(str);
            props.remove("bind_port");
        }
        if ((str = props.getProperty("num_last_ports")) != null) {
            this.num_last_ports = Integer.parseInt(str);
            props.remove("num_last_ports");
        }
        if ((str = props.getProperty("start_port")) != null) {
            this.bind_port = Integer.parseInt(str);
            props.remove("start_port");
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = Integer.parseInt(str);
            props.remove("port_range");
        }
        if ((str = props.getProperty("mcast_addr")) != null) {
            this.mcast_addr_name = str;
            props.remove("mcast_addr");
        }
        if ((str = props.getProperty("mcast_port")) != null) {
            this.mcast_port = Integer.parseInt(str);
            props.remove("mcast_port");
        }
        if ((str = props.getProperty("ip_mcast")) != null) {
            this.ip_mcast = Boolean.valueOf(str);
            props.remove("ip_mcast");
        }
        if ((str = props.getProperty("ip_ttl")) != null) {
            this.ip_ttl = Integer.parseInt(str);
            props.remove("ip_ttl");
        }
        if ((str = props.getProperty("mcast_send_buf_size")) != null) {
            this.mcast_send_buf_size = Integer.parseInt(str);
            props.remove("mcast_send_buf_size");
        }
        if ((str = props.getProperty("mcast_recv_buf_size")) != null) {
            this.mcast_recv_buf_size = Integer.parseInt(str);
            props.remove("mcast_recv_buf_size");
        }
        if ((str = props.getProperty("ucast_send_buf_size")) != null) {
            this.ucast_send_buf_size = Integer.parseInt(str);
            props.remove("ucast_send_buf_size");
        }
        if ((str = props.getProperty("ucast_recv_buf_size")) != null) {
            this.ucast_recv_buf_size = Integer.parseInt(str);
            props.remove("ucast_recv_buf_size");
        }
        if ((str = props.getProperty("loopback")) != null) {
            this.loopback = Boolean.valueOf(str);
            props.remove("loopback");
        }
        if ((str = props.getProperty("discard_incompatibe_packets")) != null) {
            this.discard_incompatible_packets = Boolean.valueOf(str);
            props.remove("discard_incompatibe_packets");
        }
        if ((str = props.getProperty("use_packet_handler")) != null) {
            this.use_incoming_packet_handler = Boolean.valueOf(str);
            props.remove("use_packet_handler");
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"'use_packet_handler' is deprecated; use 'use_incoming_packet_handler' instead");
            }
        }
        if ((str = props.getProperty("use_incoming_packet_handler")) != null) {
            this.use_incoming_packet_handler = Boolean.valueOf(str);
            props.remove("use_incoming_packet_handler");
        }
        if ((str = props.getProperty("use_outgoing_packet_handler")) != null) {
            this.use_outgoing_packet_handler = Boolean.valueOf(str);
            props.remove("use_outgoing_packet_handler");
        }
        if ((str = props.getProperty("max_bundle_size")) != null) {
            int bundle_size = Integer.parseInt(str);
            if (bundle_size > this.max_bundle_size) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("max_bundle_size (" + bundle_size + ") is greater than largest UDP fragmentation size (" + this.max_bundle_size + ')'));
                }
                return false;
            }
            if (bundle_size <= 0) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("max_bundle_size (" + bundle_size + ") is <= 0"));
                }
                return false;
            }
            this.max_bundle_size = bundle_size;
            props.remove("max_bundle_size");
        }
        if ((str = props.getProperty("max_bundle_timeout")) != null) {
            this.max_bundle_timeout = Long.parseLong(str);
            if (this.max_bundle_timeout <= 0L) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("max_bundle_timeout of " + this.max_bundle_timeout + " is invalid"));
                }
                return false;
            }
            props.remove("max_bundle_timeout");
        }
        if ((str = props.getProperty("enable_bundling")) != null) {
            this.enable_bundling = Boolean.valueOf(str);
            props.remove("enable_bundling");
        }
        if ((str = props.getProperty("use_addr_translation")) != null) {
            this.use_addr_translation = Boolean.valueOf(str);
            props.remove("use_addr_translation");
        }
        if (props.size() > 0) {
            System.err.println("UDP.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        if (this.enable_bundling) {
            if (!this.use_outgoing_packet_handler && this.log.isWarnEnabled()) {
                this.log.warn((Object)"enable_bundling is true; setting use_outgoing_packet_handler=true");
            }
            this.use_outgoing_packet_handler = true;
        }
        return true;
    }

    public void startUpHandler() {
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 56: {
                this.passUp(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        block10: {
            if (evt.getType() != 1) {
                this.handleDownEvent(evt);
                return;
            }
            Message msg = (Message)evt.getArg();
            if (this.channel_name != null) {
                msg.putHeader(name, this.udp_hdr);
            }
            Address dest_addr = msg.getDest();
            if (this.observer != null) {
                this.observer.passDown(evt);
            }
            if (dest_addr == null) {
                if (this.ip_mcast) {
                    if (this.mcast_addr == null) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("dest address of message is null, and sending to default address fails as mcast_addr is null, too ! Discarding message " + Util.printEvent(evt)));
                        }
                        return;
                    }
                    msg.setDest(this.mcast_addr);
                } else {
                    this.sendMultipleUdpMessages(msg, this.members);
                    return;
                }
            }
            try {
                this.sendUdpMessage(msg);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block10;
                this.log.error((Object)("exception=" + e + ", msg=" + msg + ", mcast_addr=" + this.mcast_addr));
            }
        }
    }

    void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleIncomingUdpPacket(IpAddress dest, InetAddress sender, int port, byte[] data) {
        DataInputStream inp;
        ByteArrayInputStream inp_stream;
        block10: {
            inp_stream = null;
            inp = null;
            Message msg = null;
            try {
                inp_stream = new ByteArrayInputStream(data, this.VERSION_LENGTH, data.length - this.VERSION_LENGTH);
                inp = new DataInputStream(inp_stream);
                if (this.enable_bundling) {
                    List l = this.bufferToList(inp, dest, sender, port);
                    Enumeration en = l.elements();
                    while (en.hasMoreElements()) {
                        msg = (Message)en.nextElement();
                        try {
                            this.handleMessage(msg);
                        }
                        catch (Throwable t) {
                            if (!this.log.isErrorEnabled()) continue;
                            this.log.error((Object)("failure: " + t.toString()));
                        }
                    }
                    break block10;
                }
                msg = this.bufferToMessage(inp, dest, sender, port);
                this.handleMessage(msg);
            }
            catch (Throwable e) {
                try {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"exception in processing incoming packet", e);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Util.closeInputStream(inp);
                    Util.closeInputStream(inp_stream);
                }
            }
        }
        Util.closeInputStream(inp);
        Util.closeInputStream(inp_stream);
    }

    void handleMessage(Message msg) {
        UdpHeader hdr;
        Address dst = msg.getDest();
        if (dst == null) {
            dst = this.mcast_addr;
        }
        if (this.loopback) {
            Address src = msg.getSrc();
            if ((dst == null || dst != null && dst.isMulticastAddress()) && src != null && this.local_addr.equals(src)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"discarded own loopback multicast packet");
                }
                return;
            }
        }
        Event evt = new Event(1, msg);
        if (this.log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer("message is ");
            sb.append(msg).append(", headers are ").append(msg.getHeaders());
            this.log.trace((Object)sb.toString());
        }
        if (this.observer != null) {
            this.observer.up(evt, this.up_queue.size());
        }
        if ((hdr = (UdpHeader)msg.getHeader(name)) != null) {
            String ch_name = hdr.channel_name;
            if (ch_name != null && this.channel_name != null && !this.channel_name.equals(ch_name) && !ch_name.equals("DIAG_GROUP-BELA-322649")) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("discarded message from different group (" + ch_name + "). Sender was " + msg.getSrc()));
                }
                return;
            }
        } else if (this.log.isErrorEnabled()) {
            this.log.error((Object)"message does not have a UDP header");
        }
        this.passUp(evt);
    }

    void sendUdpMessage(Message msg) throws Exception {
        this.sendUdpMessage(msg, false);
    }

    void sendUdpMessage(Message msg, boolean copyForOutgoingQueue) throws Exception {
        IpAddress dest = (IpAddress)msg.getDest();
        this.setSourceAddress(msg);
        if (this.log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer("sending msg to ");
            sb.append(msg.getDest()).append(" (src=").append(msg.getSrc()).append("), headers are ").append(msg.getHeaders());
            this.log.trace((Object)sb.toString());
        }
        if (this.loopback && (dest.equals(this.local_addr) || dest.isMulticastAddress())) {
            Message copy = msg.copy();
            copy.setSrc(this.local_addr);
            Event evt = new Event(1, copy);
            if (this.observer != null) {
                this.observer.up(evt, this.up_queue.size());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("looped back local message " + copy));
            }
            this.passUp(evt);
            if (dest != null && !dest.isMulticastAddress()) {
                return;
            }
        }
        if (this.use_outgoing_packet_handler) {
            if (copyForOutgoingQueue) {
                this.outgoing_queue.add(msg.copy());
            } else {
                this.outgoing_queue.add(msg);
            }
            return;
        }
        this.send(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(Message msg) throws Exception {
        IpAddress dest = (IpAddress)msg.getDest();
        IpAddress src = (IpAddress)msg.getSrc();
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = this.out_stream;
        synchronized (exposedByteArrayOutputStream) {
            Buffer buf = this.messageToBuffer(msg, dest, src);
            this.doSend(buf, dest.getIpAddress(), dest.getPort());
        }
    }

    void doSend(Buffer buf, InetAddress dest, int port) throws IOException {
        DatagramPacket packet = new DatagramPacket(buf.getBuf(), buf.getOffset(), buf.getLength(), dest, port);
        if (dest.isMulticastAddress() && this.mcast_send_sock != null) {
            this.mcast_send_sock.send(packet);
        } else if (this.sock != null) {
            this.sock.send(packet);
        }
    }

    void sendMultipleUdpMessages(Message msg, Vector dests) {
        for (int i = 0; i < dests.size(); ++i) {
            Address dest = (Address)dests.elementAt(i);
            msg.setDest(dest);
            try {
                this.sendUdpMessage(msg, true);
                continue;
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("exception=" + e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Buffer messageToBuffer(Message msg, IpAddress dest, IpAddress src) throws IOException {
        Buffer buffer;
        DataOutputStream out = null;
        this.out_stream.reset();
        this.out_stream.write(Version.version_id, 0, Version.version_id.length);
        try {
            Buffer retval;
            out = new DataOutputStream(this.out_stream);
            this.nullAddresses(msg, dest, src);
            msg.writeTo(out);
            this.revertAddresses(msg, dest, src);
            out.flush();
            buffer = retval = new Buffer(this.out_stream.getRawBuffer(), 0, this.out_stream.size());
        }
        catch (Throwable throwable) {
            Util.closeOutputStream(out);
            throw throwable;
        }
        Util.closeOutputStream(out);
        return buffer;
    }

    void nullAddresses(Message msg, IpAddress dest, IpAddress src) {
        msg.setDest(null);
        if (!dest.isMulticastAddress()) {
            if (src != null) {
                msg.setSrc(new IpAddress(src.getPort(), false));
                if (src.getAdditionalData() != null) {
                    ((IpAddress)msg.getSrc()).setAdditionalData(src.getAdditionalData());
                }
            } else {
                msg.setSrc(null);
            }
        } else if (src != null) {
            msg.setSrc(new IpAddress(src.getPort(), false));
            if (src.getAdditionalData() != null) {
                ((IpAddress)msg.getSrc()).setAdditionalData(src.getAdditionalData());
            }
        }
    }

    void revertAddresses(Message msg, IpAddress dest, IpAddress src) {
        msg.setDest(dest);
        msg.setSrc(src);
    }

    Message bufferToMessage(DataInputStream instream, IpAddress dest, InetAddress sender, int port) throws IOException, IllegalAccessException, InstantiationException {
        Message msg = new Message();
        msg.readFrom(instream);
        this.setAddresses(msg, dest, sender, port);
        return msg;
    }

    void setAddresses(Message msg, IpAddress dest, InetAddress sender, int port) {
        IpAddress src_addr;
        if (msg.getDest() == null && dest != null) {
            msg.setDest(dest);
        }
        if ((src_addr = (IpAddress)msg.getSrc()) == null) {
            try {
                msg.setSrc(new IpAddress(sender, port));
            }
            catch (Throwable t) {}
        } else {
            byte[] tmp_additional_data = src_addr.getAdditionalData();
            if (src_addr.getIpAddress() == null) {
                try {
                    msg.setSrc(new IpAddress(sender, src_addr.getPort()));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (tmp_additional_data != null) {
                ((IpAddress)msg.getSrc()).setAdditionalData(tmp_additional_data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Buffer listToBuffer(List l, IpAddress dest) throws IOException {
        Buffer buffer;
        Buffer retval = null;
        int len = l != null ? l.size() : 0;
        DataOutputStream out = null;
        this.out_stream.reset();
        this.out_stream.write(Version.version_id, 0, Version.version_id.length);
        try {
            out = new DataOutputStream(this.out_stream);
            out.writeInt(len);
            Enumeration en = l.elements();
            while (en.hasMoreElements()) {
                Message msg = (Message)en.nextElement();
                IpAddress src = (IpAddress)msg.getSrc();
                this.nullAddresses(msg, dest, src);
                msg.writeTo(out);
                this.revertAddresses(msg, dest, src);
            }
            out.flush();
            buffer = retval = new Buffer(this.out_stream.getRawBuffer(), 0, this.out_stream.size());
        }
        catch (Throwable throwable) {
            Util.closeOutputStream(out);
            throw throwable;
        }
        Util.closeOutputStream(out);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List bufferToList(DataInputStream instream, IpAddress dest, InetAddress sender, int port) throws IOException, IllegalAccessException, InstantiationException {
        List l = new List();
        InputStream in = null;
        try {
            int len = instream.readInt();
            for (int i = 0; i < len; ++i) {
                Message msg = new Message();
                msg.readFrom(instream);
                this.setAddresses(msg, dest, sender, port);
                l.add(msg);
            }
            List list = l;
            return list;
        }
        finally {
            Util.closeInputStream(in);
        }
    }

    void createSockets() throws Exception {
        InetAddress[] interfaces;
        InetAddress tmp_addr = null;
        if (this.bind_addr == null && (interfaces = InetAddress.getAllByName(InetAddress.getLocalHost().getHostAddress())) != null && interfaces.length > 0) {
            this.bind_addr = interfaces[0];
        }
        if (this.bind_addr == null) {
            this.bind_addr = InetAddress.getLocalHost();
        }
        if (this.bind_addr != null && this.log.isInfoEnabled()) {
            this.log.info((Object)("sockets will use interface " + this.bind_addr.getHostAddress()));
        }
        this.sock = this.bind_port > 0 ? this.createDatagramSocketWithBindPort() : this.createEphemeralDatagramSocket();
        if (this.sock == null) {
            throw new Exception("UDP.createSocket(): sock is null");
        }
        this.local_addr = new IpAddress(this.sock.getLocalAddress(), this.sock.getLocalPort());
        if (this.additional_data != null) {
            this.local_addr.setAdditionalData(this.additional_data);
        }
        if (this.ip_mcast) {
            this.mcast_recv_sock = new MulticastSocket(this.mcast_port);
            this.mcast_recv_sock.setTimeToLive(this.ip_ttl);
            tmp_addr = InetAddress.getByName(this.mcast_addr_name);
            this.mcast_addr = new IpAddress(tmp_addr, this.mcast_port);
            if (this.bind_to_all_interfaces && Util.getJavaVersion() >= 14) {
                this.bindToAllInterfaces(this.mcast_recv_sock, this.mcast_addr.getIpAddress());
            } else {
                if (this.bind_addr != null) {
                    this.mcast_recv_sock.setInterface(this.bind_addr);
                }
                this.mcast_recv_sock.joinGroup(tmp_addr);
            }
            this.mcast_send_sock = new MulticastSocket();
            this.mcast_send_sock.setTimeToLive(this.ip_ttl);
            if (this.bind_addr != null) {
                this.mcast_send_sock.setInterface(this.bind_addr);
            }
        }
        this.setBufferSizes();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("socket information:\n" + this.dumpSocketInfo()));
        }
    }

    private void bindToAllInterfaces(MulticastSocket s, InetAddress mcastAddr) throws IOException {
        InetSocketAddress tmp_mcast_addr = new InetSocketAddress(mcastAddr, this.mcast_port);
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            if (!en2.hasMoreElements()) continue;
            InetAddress addr = en2.nextElement();
            s.joinGroup(tmp_mcast_addr, i);
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("joined " + tmp_mcast_addr + " on interface " + i.getName() + " (" + addr + ")"));
        }
    }

    DatagramSocket createEphemeralDatagramSocket() throws SocketException {
        DatagramSocket tmp;
        block4: {
            tmp = null;
            int localPort = 0;
            while (true) {
                tmp = new DatagramSocket(localPort, this.bind_addr);
                if (this.num_last_ports <= 0) break block4;
                localPort = tmp.getLocalPort();
                if (!this.getLastPortsUsed().contains(new Integer(localPort))) break;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("local port " + localPort + " already seen in this session; will try to get other port"));
                }
                try {
                    tmp.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++localPort;
            }
            this.getLastPortsUsed().add(new Integer(localPort));
        }
        return tmp;
    }

    DatagramSocket createDatagramSocketWithBindPort() throws Exception {
        DatagramSocket tmp = null;
        int rcv_port = this.bind_port;
        int max_port = this.bind_port + this.port_range;
        while (rcv_port <= max_port) {
            try {
                tmp = new DatagramSocket(rcv_port, this.bind_addr);
                break;
            }
            catch (SocketException bind_ex) {
                ++rcv_port;
            }
            catch (SecurityException sec_ex) {
                ++rcv_port;
            }
            if (rcv_port < max_port + 1) continue;
            throw new Exception("UDP.createSockets(): cannot list on any port in range " + this.bind_port + '-' + (this.bind_port + this.port_range));
        }
        return tmp;
    }

    String dumpSocketInfo() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("local_addr=").append(this.local_addr);
        sb.append(", mcast_addr=").append(this.mcast_addr);
        sb.append(", bind_addr=").append(this.bind_addr);
        sb.append(", ttl=").append(this.ip_ttl);
        if (this.sock != null) {
            sb.append("\nsock: bound to ");
            sb.append(this.sock.getLocalAddress().getHostAddress()).append(':').append(this.sock.getLocalPort());
            sb.append(", receive buffer size=").append(this.sock.getReceiveBufferSize());
            sb.append(", send buffer size=").append(this.sock.getSendBufferSize());
        }
        if (this.mcast_recv_sock != null) {
            sb.append("\nmcast_recv_sock: bound to ");
            sb.append(this.mcast_recv_sock.getInterface().getHostAddress()).append(':').append(this.mcast_recv_sock.getLocalPort());
            sb.append(", send buffer size=").append(this.mcast_recv_sock.getSendBufferSize());
            sb.append(", receive buffer size=").append(this.mcast_recv_sock.getReceiveBufferSize());
        }
        if (this.mcast_send_sock != null) {
            sb.append("\nmcast_send_sock: bound to ");
            sb.append(this.mcast_send_sock.getInterface().getHostAddress()).append(':').append(this.mcast_send_sock.getLocalPort());
            sb.append(", send buffer size=").append(this.mcast_send_sock.getSendBufferSize());
            sb.append(", receive buffer size=").append(this.mcast_send_sock.getReceiveBufferSize());
        }
        return sb.toString();
    }

    void setBufferSizes() {
        block20: {
            block18: {
                block16: {
                    if (this.sock != null) {
                        block15: {
                            try {
                                this.sock.setSendBufferSize(this.ucast_send_buf_size);
                            }
                            catch (Throwable ex) {
                                if (!this.log.isWarnEnabled()) break block15;
                                this.log.warn((Object)("failed setting ucast_send_buf_size in sock: " + ex));
                            }
                        }
                        try {
                            this.sock.setReceiveBufferSize(this.ucast_recv_buf_size);
                        }
                        catch (Throwable ex) {
                            if (!this.log.isWarnEnabled()) break block16;
                            this.log.warn((Object)("failed setting ucast_recv_buf_size in sock: " + ex));
                        }
                    }
                }
                if (this.mcast_recv_sock != null) {
                    block17: {
                        try {
                            this.mcast_recv_sock.setSendBufferSize(this.mcast_send_buf_size);
                        }
                        catch (Throwable ex) {
                            if (!this.log.isWarnEnabled()) break block17;
                            this.log.warn((Object)("failed setting mcast_send_buf_size in mcast_recv_sock: " + ex));
                        }
                    }
                    try {
                        this.mcast_recv_sock.setReceiveBufferSize(this.mcast_recv_buf_size);
                    }
                    catch (Throwable ex) {
                        if (!this.log.isWarnEnabled()) break block18;
                        this.log.warn((Object)("failed setting mcast_recv_buf_size in mcast_recv_sock: " + ex));
                    }
                }
            }
            if (this.mcast_send_sock != null) {
                block19: {
                    try {
                        this.mcast_send_sock.setSendBufferSize(this.mcast_send_buf_size);
                    }
                    catch (Throwable ex) {
                        if (!this.log.isWarnEnabled()) break block19;
                        this.log.warn((Object)("failed setting mcast_send_buf_size in mcast_send_sock: " + ex));
                    }
                }
                try {
                    this.mcast_send_sock.setReceiveBufferSize(this.mcast_recv_buf_size);
                }
                catch (Throwable ex) {
                    if (!this.log.isWarnEnabled()) break block20;
                    this.log.warn((Object)("failed setting mcast_recv_buf_size in mcast_send_sock: " + ex));
                }
            }
        }
    }

    void closeSockets() {
        this.closeMulticastSocket();
        this.closeSocket();
    }

    void closeMulticastSocket() {
        if (this.mcast_recv_sock != null) {
            try {
                if (this.mcast_addr != null) {
                    this.mcast_recv_sock.leaveGroup(this.mcast_addr.getIpAddress());
                }
                this.mcast_recv_sock.close();
                this.mcast_recv_sock = null;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"multicast receive socket closed");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mcast_addr = null;
        }
        if (this.mcast_send_sock != null) {
            this.mcast_send_sock.close();
            this.mcast_send_sock = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"multicast send socket closed");
            }
        }
    }

    void closeSocket() {
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"socket closed");
            }
        }
    }

    void startThreads() throws Exception {
        if (this.ucast_receiver == null) {
            this.ucast_receiver = new UcastReceiver();
            this.ucast_receiver.start();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"created unicast receiver thread");
            }
        }
        if (this.ip_mcast) {
            if (this.mcast_receiver != null) {
                if (this.mcast_receiver.isAlive()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"did not create new multicastreceiver thread as existing multicast receiver thread is still running");
                    }
                } else {
                    this.mcast_receiver = null;
                }
            }
            if (this.mcast_receiver == null) {
                this.mcast_receiver = new Thread((Runnable)this, "UDP mcast receiver");
                this.mcast_receiver.setPriority(10);
                this.mcast_receiver.setDaemon(true);
                this.mcast_receiver.start();
            }
        }
        if (this.use_outgoing_packet_handler) {
            this.outgoing_packet_handler.start();
        }
        if (this.use_incoming_packet_handler) {
            this.incoming_packet_handler.start();
        }
    }

    void stopThreads() {
        if (this.mcast_receiver != null) {
            if (this.mcast_receiver.isAlive()) {
                Thread tmp = this.mcast_receiver;
                this.mcast_receiver = null;
                this.closeMulticastSocket();
                tmp.interrupt();
                try {
                    tmp.join(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object var1_1 = null;
            }
            this.mcast_receiver = null;
        }
        if (this.ucast_receiver != null) {
            this.ucast_receiver.stop();
            this.ucast_receiver = null;
        }
        if (this.incoming_packet_handler != null) {
            this.incoming_packet_handler.stop();
        }
        if (this.outgoing_packet_handler != null) {
            this.outgoing_packet_handler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    for (int i = 0; i < tmpvec.size(); ++i) {
                        this.members.addElement(tmpvec.elementAt(i));
                    }
                    break;
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 2: {
                this.channel_name = (String)evt.getArg();
                this.udp_hdr = new UdpHeader(this.channel_name);
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                this.passUp(new Event(5));
                break;
            }
            case 56: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
            }
        }
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("additional_data")) {
            this.additional_data = (byte[])map.get("additional_data");
        }
        if (map.containsKey("send_buf_size")) {
            this.ucast_send_buf_size = this.mcast_send_buf_size = ((Integer)map.get("send_buf_size")).intValue();
        }
        if (map.containsKey("recv_buf_size")) {
            this.ucast_recv_buf_size = this.mcast_recv_buf_size = ((Integer)map.get("recv_buf_size")).intValue();
        }
        this.setBufferSizes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String dumpMessages(HashMap map) {
        StringBuffer sb = new StringBuffer();
        if (map != null) {
            HashMap hashMap = map;
            synchronized (hashMap) {
                Iterator it = map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Object key = entry.getKey();
                    if (key == null) {
                        key = "null";
                    }
                    List l = (List)entry.getValue();
                    sb.append(key).append(": ");
                    sb.append(l.size()).append(" msgs\n");
                }
            }
        }
        return sb.toString();
    }

    class BundlingOutgoingPacketHandler
    extends OutgoingPacketHandler {
        long total_bytes;
        final HashMap msgs;

        BundlingOutgoingPacketHandler() {
            this.total_bytes = 0L;
            this.msgs = new HashMap(11);
        }

        void start() {
            super.start();
            this.t.setName("UDP.BundlingOutgoingPacketHandler thread");
        }

        public void run() {
            Message msg = null;
            Message leftover = null;
            long start = 0L;
            while (UDP.this.outgoing_queue != null) {
                try {
                    this.total_bytes = 0L;
                    msg = leftover != null ? leftover : (Message)UDP.this.outgoing_queue.remove();
                    start = System.currentTimeMillis();
                    leftover = this.waitForMessagesToAccumulate(msg, UDP.this.outgoing_queue, UDP.this.max_bundle_size, start, UDP.this.max_bundle_timeout);
                    this.bundleAndSend(start);
                }
                catch (QueueClosedException closed_ex) {
                    break;
                }
                catch (Throwable th) {
                    if (!UDP.this.log.isErrorEnabled()) continue;
                    UDP.this.log.error((Object)"exception sending packet", th);
                }
            }
            this.bundleAndSend(start);
            if (UDP.this.log.isTraceEnabled()) {
                UDP.this.log.trace((Object)"packet_handler thread terminating");
            }
        }

        Message waitForMessagesToAccumulate(Message m, Queue q, long max_size, long start_time, long max_time) {
            Message leftover = null;
            boolean running = true;
            boolean size_exceeded = false;
            boolean time_reached = false;
            long time_to_wait = max_time;
            long waited_time = 0L;
            while (running) {
                try {
                    Message msg = m != null ? m : (Message)q.remove(time_to_wait);
                    m = null;
                    long len = msg.size();
                    this.checkLength(len);
                    waited_time = System.currentTimeMillis() - start_time;
                    time_to_wait = max_time - waited_time;
                    size_exceeded = this.total_bytes + len > max_size;
                    boolean bl = time_reached = time_to_wait <= 0L;
                    if (size_exceeded) {
                        running = false;
                        leftover = msg;
                        continue;
                    }
                    this.addMessage(msg);
                    this.total_bytes += len;
                    if (!time_reached) continue;
                    running = false;
                }
                catch (TimeoutException timeout) {
                    waited_time = System.currentTimeMillis() - start_time;
                    time_reached = true;
                    break;
                }
                catch (QueueClosedException closed) {
                    break;
                }
                catch (Exception ex) {
                    UDP.this.log.error((Object)"failure in bundling", (Throwable)ex);
                }
            }
            return leftover;
        }

        void checkLength(long len) throws Exception {
            if (len > (long)UDP.this.max_bundle_size) {
                throw new Exception("UDP.BundlingOutgoingPacketHandler.handleMessage(): message size (" + len + ") is greater than max bundling size (" + UDP.this.max_bundle_size + "). " + "Set the fragmentation/bundle size in FRAG and UDP correctly");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addMessage(Message msg) {
            Address dst = msg.getDest();
            HashMap hashMap = this.msgs;
            synchronized (hashMap) {
                List tmp = (List)this.msgs.get(dst);
                if (tmp == null) {
                    tmp = new List();
                    this.msgs.put(dst, tmp);
                }
                tmp.add(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bundleAndSend(long start_time) {
            long stop_time = System.currentTimeMillis();
            HashMap hashMap = this.msgs;
            synchronized (hashMap) {
                if (this.msgs.size() == 0) {
                    return;
                }
                if (start_time == 0L) {
                    start_time = System.currentTimeMillis();
                }
                if (UDP.this.log.isTraceEnabled()) {
                    StringBuffer sb = new StringBuffer("sending ").append(this.numMsgs(this.msgs)).append(" msgs (");
                    sb.append(this.total_bytes).append(" bytes, ").append(stop_time - start_time).append("ms)");
                    sb.append(" to ").append(this.msgs.size()).append(" destination(s)");
                    if (this.msgs.size() > 1) {
                        sb.append(" (dests=").append(this.msgs.keySet()).append(")");
                    }
                    UDP.this.log.trace((Object)sb.toString());
                }
                Iterator it = this.msgs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    IpAddress dst = (IpAddress)entry.getKey();
                    InetAddress addr = dst.getIpAddress();
                    int port = dst.getPort();
                    List l = (List)entry.getValue();
                    try {
                        if (l.size() <= 0) continue;
                        ExposedByteArrayOutputStream exposedByteArrayOutputStream = UDP.this.out_stream;
                        synchronized (exposedByteArrayOutputStream) {
                            Buffer buffer = UDP.this.listToBuffer(l, dst);
                            UDP.this.doSend(buffer, addr, port);
                        }
                    }
                    catch (IOException e) {
                        if (!UDP.this.log.isErrorEnabled()) continue;
                        UDP.this.log.error((Object)("exception sending msg (to dest=" + dst + "): " + e));
                    }
                }
                this.msgs.clear();
            }
        }

        private int numMsgs(HashMap map) {
            Collection values = map.values();
            int size = 0;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                List l = (List)it.next();
                size += l.size();
            }
            return size;
        }
    }

    class OutgoingPacketHandler
    implements Runnable {
        Thread t = null;
        byte[] buf;
        DatagramPacket packet;
        IpAddress dest;

        OutgoingPacketHandler() {
        }

        public void run() {
            while (UDP.this.outgoing_queue != null && UDP.this.outgoing_packet_handler != null) {
                Message msg;
                block5: {
                    try {
                        msg = (Message)UDP.this.outgoing_queue.remove();
                        this.handleMessage(msg);
                    }
                    catch (QueueClosedException closed_ex) {
                        break;
                    }
                    catch (Throwable th) {
                        if (!UDP.this.log.isErrorEnabled()) break block5;
                        UDP.this.log.error((Object)"exception sending packet", th);
                    }
                }
                msg = null;
            }
            if (UDP.this.log.isTraceEnabled()) {
                UDP.this.log.trace((Object)"packet_handler thread terminating");
            }
        }

        protected void handleMessage(Message msg) throws Exception {
            UDP.this.send(msg);
        }

        void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "UDP.OutgoingPacketHandler thread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        void stop() {
            if (UDP.this.outgoing_queue != null) {
                UDP.this.outgoing_queue.close(false);
            }
            this.t = null;
        }
    }

    class IncomingPacketHandler
    implements Runnable {
        Thread t = null;

        IncomingPacketHandler() {
        }

        public void run() {
            while (UDP.this.incoming_queue != null && UDP.this.incoming_packet_handler != null) {
                byte[] data;
                IncomingQueueEntry entry;
                try {
                    entry = (IncomingQueueEntry)UDP.this.incoming_queue.remove();
                    data = entry.buf;
                }
                catch (QueueClosedException closed_ex) {
                    if (!UDP.this.log.isDebugEnabled()) break;
                    UDP.this.log.debug((Object)"packet_handler thread terminating");
                    break;
                }
                UDP.this.handleIncomingUdpPacket(entry.dest, entry.sender, entry.port, data);
            }
        }

        void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "UDP.IncomingPacketHandler thread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        void stop() {
            if (UDP.this.incoming_queue != null) {
                UDP.this.incoming_queue.close(false);
            }
            this.t = null;
            UDP.this.incoming_queue = null;
        }
    }

    public class UcastReceiver
    implements Runnable {
        boolean running = true;
        Thread thread = null;

        public void start() {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, "UDP.UcastReceiverThread");
                this.thread.setDaemon(true);
                this.running = true;
                this.thread.start();
            }
        }

        public void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                this.running = false;
                Thread tmp = this.thread;
                this.thread = null;
                UDP.this.closeSocket();
                tmp.interrupt();
                Object var1_1 = null;
            }
            this.thread = null;
        }

        public void run() {
            byte[] receive_buf = new byte[65535];
            DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
            while (this.running && this.thread != null && UDP.this.sock != null) {
                try {
                    packet.setData(receive_buf, 0, receive_buf.length);
                    UDP.this.sock.receive(packet);
                    InetAddress sender_addr = packet.getAddress();
                    int sender_port = packet.getPort();
                    int len = packet.getLength();
                    byte[] data = packet.getData();
                    if (UDP.this.log.isTraceEnabled()) {
                        UDP.this.log.trace((Object)("received (ucast) " + len + " bytes from " + sender_addr + ':' + sender_port));
                    }
                    if (len > receive_buf.length && UDP.this.log.isErrorEnabled()) {
                        UDP.this.log.error((Object)("size of the received packet (" + len + ") is bigger than allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG protocol and make its frag_size lower than " + receive_buf.length));
                    }
                    if (!Version.compareTo(data)) {
                        if (UDP.this.log.isWarnEnabled()) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("packet from ").append(sender_addr).append(':').append(sender_port);
                            sb.append(" has different version (").append(Version.printVersionId(data, Version.version_id.length));
                            sb.append(") from ours (").append(Version.printVersionId(Version.version_id)).append("). ");
                            if (UDP.this.discard_incompatible_packets) {
                                sb.append("Packet is discarded");
                            } else {
                                sb.append("This may cause problems");
                            }
                            UDP.this.log.warn((Object)sb.toString());
                        }
                        if (UDP.this.discard_incompatible_packets) continue;
                    }
                    if (UDP.this.use_incoming_packet_handler) {
                        byte[] tmp = new byte[len];
                        System.arraycopy(data, 0, tmp, 0, len);
                        UDP.this.incoming_queue.add(new IncomingQueueEntry(UDP.this.local_addr, sender_addr, sender_port, tmp));
                        continue;
                    }
                    UDP.this.handleIncomingUdpPacket(UDP.this.local_addr, sender_addr, sender_port, data);
                }
                catch (SocketException sock_ex) {
                    if (!UDP.this.log.isDebugEnabled()) break;
                    UDP.this.log.debug((Object)("unicast receiver socket is closed, exception=" + sock_ex));
                    break;
                }
                catch (InterruptedIOException io_ex) {
                }
                catch (Throwable ex) {
                    if (UDP.this.log.isErrorEnabled()) {
                        UDP.this.log.error((Object)("[" + UDP.this.local_addr + "] failed receiving unicast packet"), ex);
                    }
                    Util.sleep(100L);
                }
            }
            if (UDP.this.log.isDebugEnabled()) {
                UDP.this.log.debug((Object)"unicast receiver thread terminated");
            }
        }
    }

    class IncomingQueueEntry {
        IpAddress dest = null;
        InetAddress sender = null;
        int port = -1;
        byte[] buf;

        public IncomingQueueEntry(IpAddress dest, InetAddress sender, int port, byte[] buf) {
            this.dest = dest;
            this.sender = sender;
            this.port = port;
            this.buf = buf;
        }

        public IncomingQueueEntry(byte[] buf) {
            this.buf = buf;
        }
    }
}

