/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;
import org.jgroups.Transport;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RspCollector;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.ReentrantLatch;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class MessageDispatcher
implements RequestHandler {
    protected Channel channel = null;
    protected RequestCorrelator corr = null;
    protected MessageListener msg_listener = null;
    protected MembershipListener membership_listener = null;
    protected RequestHandler req_handler = null;
    protected ProtocolAdapter prot_adapter = null;
    protected TransportAdapter transport_adapter = null;
    protected final Vector members = new Vector();
    protected Address local_addr = null;
    protected boolean deadlock_detection = false;
    protected PullPushAdapter adapter = null;
    protected Serializable id = null;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected boolean concurrent_processing = false;

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2) {
        this.channel = channel;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
            channel.setOpt(4, Boolean.TRUE);
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this.prot_adapter);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, boolean deadlock_detection) {
        this.channel = channel;
        this.deadlock_detection = deadlock_detection;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
            channel.setOpt(4, Boolean.TRUE);
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this.prot_adapter);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, boolean deadlock_detection, boolean concurrent_processing) {
        this.channel = channel;
        this.deadlock_detection = deadlock_detection;
        this.concurrent_processing = concurrent_processing;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
            channel.setOpt(4, Boolean.TRUE);
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this.prot_adapter);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this(channel, l, l2);
        this.setRequestHandler(req_handler);
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean deadlock_detection) {
        this(channel, l, l2);
        this.deadlock_detection = deadlock_detection;
        this.setRequestHandler(req_handler);
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean deadlock_detection, boolean concurrent_processing) {
        this(channel, l, l2);
        this.deadlock_detection = deadlock_detection;
        this.concurrent_processing = concurrent_processing;
        this.setRequestHandler(req_handler);
    }

    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2) {
        this.adapter = adapter;
        this.id = id;
        this.setMembers(((Channel)adapter.getTransport()).getView().getMembers());
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        PullPushHandler handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(handler);
        if (id == null) {
            adapter.setListener(handler);
        } else {
            adapter.registerListener(id, handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            ((Channel)tp).setOpt(4, Boolean.TRUE);
            this.local_addr = ((Channel)tp).getLocalAddress();
        }
        this.start();
    }

    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this.adapter = adapter;
        this.id = id;
        this.setMembers(((Channel)adapter.getTransport()).getView().getMembers());
        this.setRequestHandler(req_handler);
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        PullPushHandler handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(handler);
        if (id == null) {
            adapter.setListener(handler);
        } else {
            adapter.registerListener(id, handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            ((Channel)tp).setOpt(4, Boolean.TRUE);
            this.local_addr = ((Channel)tp).getLocalAddress();
        }
        this.start();
    }

    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean concurrent_processing) {
        this.concurrent_processing = concurrent_processing;
        this.adapter = adapter;
        this.id = id;
        this.setMembers(((Channel)adapter.getTransport()).getView().getMembers());
        this.setRequestHandler(req_handler);
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        PullPushHandler handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(handler);
        if (id == null) {
            adapter.setListener(handler);
        } else {
            adapter.registerListener(id, handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            ((Channel)tp).setOpt(4, Boolean.TRUE);
            this.local_addr = ((Channel)tp).getLocalAddress();
        }
        this.start();
    }

    private void setMembers(Vector new_mbrs) {
        if (new_mbrs != null) {
            this.members.removeAllElements();
            this.members.addAll(new_mbrs);
        }
    }

    public void setDeadlockDetection(boolean flag) {
        this.deadlock_detection = flag;
        if (this.corr != null) {
            this.corr.setDeadlockDetection(flag);
        }
    }

    public void setConcurrentProcessing(boolean flag) {
        this.concurrent_processing = flag;
    }

    public void start() {
        if (this.corr == null) {
            this.corr = this.transport_adapter != null ? new RequestCorrelator("MessageDispatcher", this.transport_adapter, this, this.deadlock_detection, this.local_addr, this.concurrent_processing) : new RequestCorrelator("MessageDispatcher", this.prot_adapter, this, this.deadlock_detection, this.local_addr, this.concurrent_processing);
            this.corr.start();
        }
        if (this.channel != null) {
            Vector tmp_mbrs = this.channel.getView() != null ? this.channel.getView().getMembers() : null;
            this.setMembers(tmp_mbrs);
        }
        if (null != this.prot_adapter) {
            this.prot_adapter.resume();
        }
    }

    public void stop() {
        if (null != this.prot_adapter) {
            this.prot_adapter.suspend();
        }
        if (this.corr != null) {
            this.corr.stop();
            this.corr = null;
        }
    }

    public void setMessageListener(MessageListener l) {
        this.msg_listener = l;
    }

    public MessageListener getMessageListener() {
        return this.msg_listener;
    }

    public void setMembershipListener(MembershipListener l) {
        this.membership_listener = l;
    }

    public void setRequestHandler(RequestHandler rh) {
        this.req_handler = rh;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        block8: {
            if (this.channel != null) {
                this.channel.send(msg);
            } else {
                if (this.adapter != null) {
                    try {
                        if (this.id != null) {
                            this.adapter.send(this.id, msg);
                            break block8;
                        }
                        this.adapter.send(msg);
                    }
                    catch (Throwable ex) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("exception=" + Util.print(ex)));
                        }
                        break block8;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"channel == null");
                }
            }
        }
    }

    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        GroupRequest _req = null;
        Vector real_dests = dests != null ? (Vector)dests.clone() : (this.members != null ? (Vector)this.members.clone() : null);
        Channel tmp = this.channel;
        if (tmp == null && this.adapter != null && this.adapter.getTransport() instanceof Channel) {
            tmp = (Channel)this.adapter.getTransport();
        }
        if (tmp != null && tmp.getOpt(3).equals(Boolean.FALSE)) {
            if (this.local_addr == null) {
                this.local_addr = tmp.getLocalAddress();
            }
            if (this.local_addr != null && real_dests != null) {
                real_dests.removeElement(this.local_addr);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("real_dests=" + real_dests));
        }
        if (real_dests == null || real_dests.size() == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"destination list is empty, won't send message");
            }
            return new RspList();
        }
        _req = new GroupRequest(msg, this.corr, real_dests, mode, timeout, 0);
        _req.execute();
        return _req.getResults();
    }

    public void castMessage(Vector dests, long req_id, Message msg, RspCollector coll) {
        if (msg == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"request is null");
            }
            return;
        }
        if (coll == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"response collector is null (must be non-null)");
            }
            return;
        }
        Vector real_dests = dests != null ? (Vector)dests.clone() : (Vector)this.members.clone();
        Channel tmp = this.channel;
        if (tmp == null && this.adapter != null && this.adapter.getTransport() instanceof Channel) {
            tmp = (Channel)this.adapter.getTransport();
        }
        if (tmp != null && tmp.getOpt(3).equals(Boolean.FALSE)) {
            if (this.local_addr == null) {
                this.local_addr = tmp.getLocalAddress();
            }
            if (this.local_addr != null) {
                real_dests.removeElement(this.local_addr);
            }
        }
        if (real_dests.size() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"destination list is empty, won't send message");
            }
            return;
        }
        this.corr.sendRequest(req_id, real_dests, msg, coll);
    }

    public void done(long req_id) {
        this.corr.done(req_id);
    }

    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        Rsp rsp;
        Vector<Address> mbrs = new Vector<Address>();
        RspList rsp_list = null;
        Address dest = msg.getDest();
        GroupRequest _req = null;
        if (dest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"the message's destination is null, cannot send message");
            }
            return null;
        }
        mbrs.addElement(dest);
        _req = new GroupRequest(msg, this.corr, mbrs, mode, timeout, 0);
        _req.execute();
        if (mode == 6) {
            return null;
        }
        rsp_list = _req.getResults();
        if (rsp_list.size() == 0) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)" response list is empty");
            }
            return null;
        }
        if (rsp_list.size() > 1 && this.log.isWarnEnabled()) {
            this.log.warn((Object)"response list contains more that 1 response; returning first response !");
        }
        if ((rsp = (Rsp)rsp_list.elementAt(0)).wasSuspected()) {
            throw new SuspectedException(dest);
        }
        if (!rsp.wasReceived()) {
            throw new TimeoutException();
        }
        return rsp.getValue();
    }

    public Object handle(Message msg) {
        if (this.req_handler != null) {
            return this.req_handler.handle(msg);
        }
        return null;
    }

    class PullPushHandler
    implements MessageListener,
    MembershipListener {
        PullPushHandler() {
        }

        public void receive(Message msg) {
            boolean pass_up = true;
            if (MessageDispatcher.this.corr != null) {
                pass_up = MessageDispatcher.this.corr.receiveMessage(msg);
            }
            if (pass_up && MessageDispatcher.this.msg_listener != null) {
                MessageDispatcher.this.msg_listener.receive(msg);
            }
        }

        public byte[] getState() {
            return MessageDispatcher.this.msg_listener != null ? MessageDispatcher.this.msg_listener.getState() : null;
        }

        public void setState(byte[] state) {
            if (MessageDispatcher.this.msg_listener != null) {
                MessageDispatcher.this.msg_listener.setState(state);
            }
        }

        public void viewAccepted(View v) {
            Vector new_mbrs;
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receiveView(v);
            }
            if ((new_mbrs = v.getMembers()) != null) {
                MessageDispatcher.this.members.removeAllElements();
                for (int i = 0; i < new_mbrs.size(); ++i) {
                    MessageDispatcher.this.members.addElement(new_mbrs.elementAt(i));
                }
            }
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.viewAccepted(v);
            }
        }

        public void suspect(Address suspected_mbr) {
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receiveSuspect(suspected_mbr);
            }
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.suspect(suspected_mbr);
            }
        }

        public void block() {
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.block();
            }
        }
    }

    class TransportAdapter
    implements Transport {
        TransportAdapter() {
        }

        public void send(Message msg) throws Exception {
            block8: {
                if (MessageDispatcher.this.channel != null) {
                    MessageDispatcher.this.channel.send(msg);
                } else {
                    if (MessageDispatcher.this.adapter != null) {
                        try {
                            if (MessageDispatcher.this.id != null) {
                                MessageDispatcher.this.adapter.send(MessageDispatcher.this.id, msg);
                                break block8;
                            }
                            MessageDispatcher.this.adapter.send(msg);
                        }
                        catch (Throwable ex) {
                            if (MessageDispatcher.this.log.isErrorEnabled()) {
                                MessageDispatcher.this.log.error((Object)("exception=" + Util.print(ex)));
                            }
                            break block8;
                        }
                    }
                    if (MessageDispatcher.this.log.isErrorEnabled()) {
                        MessageDispatcher.this.log.error((Object)"channel == null");
                    }
                }
            }
        }

        public Object receive(long timeout) throws Exception {
            return null;
        }
    }

    class ProtocolAdapter
    extends Protocol
    implements UpHandler {
        private Thread upProcessingThread = null;
        private final Queue upQueue = new Queue();
        private final ReentrantLatch m_upLatch = new ReentrantLatch(false);

        ProtocolAdapter() {
        }

        public String getName() {
            return "MessageDispatcher";
        }

        public void startUpHandler() {
        }

        public void startDownHandler() {
        }

        public void stopInternal() {
        }

        protected void receiveUpEvent(Event evt) {
        }

        protected void receiveDownEvent(Event evt) {
        }

        public void passUp(Event evt) {
            byte[] tmp_state = null;
            switch (evt.getType()) {
                case 1: {
                    if (MessageDispatcher.this.msg_listener == null) break;
                    MessageDispatcher.this.msg_listener.receive((Message)evt.getArg());
                    break;
                }
                case 17: {
                    if (MessageDispatcher.this.msg_listener != null) {
                        try {
                            tmp_state = MessageDispatcher.this.msg_listener.getState();
                        }
                        catch (Throwable t) {
                            this.log.error((Object)("failed getting state from message listener (" + MessageDispatcher.this.msg_listener + ')'), t);
                        }
                    }
                    MessageDispatcher.this.channel.returnState(tmp_state);
                    break;
                }
                case 20: {
                    if (MessageDispatcher.this.msg_listener == null) break;
                    try {
                        MessageDispatcher.this.msg_listener.setState((byte[])evt.getArg());
                    }
                    catch (ClassCastException cast_ex) {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error((Object)("received SetStateEvent, but argument " + evt.getArg() + " is not serializable. Discarding message."));
                    }
                    break;
                }
                case 6: {
                    View v = (View)evt.getArg();
                    Vector new_mbrs = v.getMembers();
                    if (new_mbrs != null) {
                        MessageDispatcher.this.members.removeAllElements();
                        MessageDispatcher.this.members.addAll(new_mbrs);
                    }
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.viewAccepted(v);
                    break;
                }
                case 8: {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("setting local_addr (" + MessageDispatcher.this.local_addr + ") to " + evt.getArg()));
                    }
                    MessageDispatcher.this.local_addr = (Address)evt.getArg();
                    break;
                }
                case 9: {
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.suspect((Address)evt.getArg());
                    break;
                }
                case 10: {
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.block();
                }
            }
        }

        public void passDown(Event evt) {
            this.down(evt);
        }

        synchronized void suspend() {
            this.m_upLatch.lock();
            if (this.upProcessingThread != null) {
                Thread t = this.upProcessingThread;
                this.upProcessingThread = null;
                t.interrupt();
            }
        }

        synchronized void resume() {
            this.m_upLatch.unlock();
            if (this.upProcessingThread == null) {
                this.startProcessingThread();
            }
        }

        private void startProcessingThread() {
            this.upProcessingThread = new Thread(new Runnable(this){
                private final /* synthetic */ ProtocolAdapter this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    Event event = null;
                    while (Thread.currentThread() == ProtocolAdapter.access$000(this.this$1)) {
                        try {
                            event = (Event)ProtocolAdapter.access$100(this.this$1).remove();
                            ProtocolAdapter.access$200(this.this$1).passThrough();
                            ProtocolAdapter.access$300(this.this$1, event);
                        }
                        catch (QueueClosedException ex1) {
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            });
            this.upProcessingThread.setDaemon(true);
            this.upProcessingThread.start();
        }

        public void up(Event evt) {
            try {
                this.upQueue.add(evt);
            }
            catch (QueueClosedException queueClosedException) {
                // empty catch block
            }
        }

        private void handleUp(Event evt) {
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receive(evt);
            } else if (this.log.isErrorEnabled()) {
                this.log.error((Object)"correlator is null, but latch is not locked! Event ignored.");
            }
        }

        public void down(Event evt) {
            if (MessageDispatcher.this.channel != null) {
                MessageDispatcher.this.channel.down(evt);
            } else if (this.log.isErrorEnabled()) {
                this.log.error((Object)"channel == null");
            }
        }

        static /* synthetic */ Thread access$000(ProtocolAdapter x0) {
            return x0.upProcessingThread;
        }

        static /* synthetic */ Queue access$100(ProtocolAdapter x0) {
            return x0.upQueue;
        }

        static /* synthetic */ ReentrantLatch access$200(ProtocolAdapter x0) {
            return x0.m_upLatch;
        }

        static /* synthetic */ void access$300(ProtocolAdapter x0, Event x1) {
            x0.handleUp(x1);
        }
    }
}

