/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.servlet.UnavailableException;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.jetty.webapp.WebAppHandler;
import org.mortbay.resource.Resource;
import org.mortbay.util.LazyList;
import org.mortbay.util.LogSupport;
import org.mortbay.xml.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXmlConfiguration
implements Configuration {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$webapp$WebXmlConfiguration == null ? (class$org$mortbay$jetty$webapp$WebXmlConfiguration = WebXmlConfiguration.class$("org.mortbay.jetty.webapp.WebXmlConfiguration")) : class$org$mortbay$jetty$webapp$WebXmlConfiguration));
    protected WebAppHandler _context;
    protected XmlParser xmlParser = WebXmlConfiguration.webXmlParser();
    protected List filters;
    protected List filterMappings;
    protected List servlets;
    protected List servletMappings;
    protected List welcomeFiles;
    protected List constraintMappings;
    static /* synthetic */ Class class$org$mortbay$jetty$webapp$WebXmlConfiguration;
    static /* synthetic */ Class class$org$mortbay$jetty$webapp$WebAppHandler;

    public static XmlParser webXmlParser() {
        XmlParser xmlParser = new XmlParser();
        URL dtd22 = (class$org$mortbay$jetty$webapp$WebAppHandler == null ? (class$org$mortbay$jetty$webapp$WebAppHandler = WebXmlConfiguration.class$("org.mortbay.jetty.webapp.WebAppHandler")) : class$org$mortbay$jetty$webapp$WebAppHandler).getResource("/javax/servlet/resources/web-app_2_2.dtd");
        URL dtd23 = (class$org$mortbay$jetty$webapp$WebAppHandler == null ? (class$org$mortbay$jetty$webapp$WebAppHandler = WebXmlConfiguration.class$("org.mortbay.jetty.webapp.WebAppHandler")) : class$org$mortbay$jetty$webapp$WebAppHandler).getResource("/javax/servlet/resources/web-app_2_3.dtd");
        URL jsp20xsd = (class$org$mortbay$jetty$webapp$WebAppHandler == null ? (class$org$mortbay$jetty$webapp$WebAppHandler = WebXmlConfiguration.class$("org.mortbay.jetty.webapp.WebAppHandler")) : class$org$mortbay$jetty$webapp$WebAppHandler).getResource("/javax/servlet/resources/jsp_2_0.xsd");
        URL j2ee14xsd = (class$org$mortbay$jetty$webapp$WebAppHandler == null ? (class$org$mortbay$jetty$webapp$WebAppHandler = WebXmlConfiguration.class$("org.mortbay.jetty.webapp.WebAppHandler")) : class$org$mortbay$jetty$webapp$WebAppHandler).getResource("/javax/servlet/resources/j2ee_1_4.xsd");
        URL webapp24xsd = (class$org$mortbay$jetty$webapp$WebAppHandler == null ? (class$org$mortbay$jetty$webapp$WebAppHandler = WebXmlConfiguration.class$("org.mortbay.jetty.webapp.WebAppHandler")) : class$org$mortbay$jetty$webapp$WebAppHandler).getResource("/javax/servlet/resources/web-app_2_4.xsd");
        URL schemadtd = (class$org$mortbay$jetty$webapp$WebAppHandler == null ? (class$org$mortbay$jetty$webapp$WebAppHandler = WebXmlConfiguration.class$("org.mortbay.jetty.webapp.WebAppHandler")) : class$org$mortbay$jetty$webapp$WebAppHandler).getResource("/javax/servlet/resources/XMLSchema.dtd");
        URL xmlxsd = (class$org$mortbay$jetty$webapp$WebAppHandler == null ? (class$org$mortbay$jetty$webapp$WebAppHandler = WebXmlConfiguration.class$("org.mortbay.jetty.webapp.WebAppHandler")) : class$org$mortbay$jetty$webapp$WebAppHandler).getResource("/javax/servlet/resources/xml.xsd");
        URL webservice11xsd = (class$org$mortbay$jetty$webapp$WebAppHandler == null ? (class$org$mortbay$jetty$webapp$WebAppHandler = WebXmlConfiguration.class$("org.mortbay.jetty.webapp.WebAppHandler")) : class$org$mortbay$jetty$webapp$WebAppHandler).getResource("/javax/servlet/resources/j2ee_web_services_client_1_1.xsd");
        URL datatypesdtd = (class$org$mortbay$jetty$webapp$WebAppHandler == null ? (class$org$mortbay$jetty$webapp$WebAppHandler = WebXmlConfiguration.class$("org.mortbay.jetty.webapp.WebAppHandler")) : class$org$mortbay$jetty$webapp$WebAppHandler).getResource("/javax/servlet/resources/datatypes.dtd");
        xmlParser.redirectEntity("web-app_2_2.dtd", dtd22);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", dtd22);
        xmlParser.redirectEntity("web.dtd", dtd23);
        xmlParser.redirectEntity("web-app_2_3.dtd", dtd23);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", dtd23);
        xmlParser.redirectEntity("XMLSchema.dtd", schemadtd);
        xmlParser.redirectEntity("http://www.w3.org/2001/XMLSchema.dtd", schemadtd);
        xmlParser.redirectEntity("-//W3C//DTD XMLSCHEMA 200102//EN", schemadtd);
        xmlParser.redirectEntity("jsp_2_0.xsd", jsp20xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", jsp20xsd);
        xmlParser.redirectEntity("j2ee_1_4.xsd", j2ee14xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", j2ee14xsd);
        xmlParser.redirectEntity("web-app_2_4.xsd", webapp24xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", webapp24xsd);
        xmlParser.redirectEntity("xml.xsd", xmlxsd);
        xmlParser.redirectEntity("http://www.w3.org/2001/xml.xsd", xmlxsd);
        xmlParser.redirectEntity("datatypes.dtd", datatypesdtd);
        xmlParser.redirectEntity("http://www.w3.org/2001/datatypes.dtd", datatypesdtd);
        xmlParser.redirectEntity("j2ee_web_services_client_1_1.xsd", webservice11xsd);
        xmlParser.redirectEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", webservice11xsd);
        return xmlParser;
    }

    public void setWebAppHandler(WebAppHandler context) {
        this._context = context;
    }

    public WebAppHandler getWebAppHandler() {
        return this._context;
    }

    public void configureClassLoader() throws Exception {
        if (this._context.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        Resource webInf = this._context.getWebInf();
        if (webInf != null && webInf.isDirectory()) {
            Resource lib;
            Resource classes = webInf.addPath("classes/");
            if (classes.exists()) {
                ((WebAppClassLoader)this._context.getClassLoader()).addClassPath(classes.toString());
            }
            if ((lib = webInf.addPath("lib/")).exists() || lib.isDirectory()) {
                ((WebAppClassLoader)this._context.getClassLoader()).addJars(lib);
            }
        }
    }

    public void configureDefaults() throws Exception {
        if (this._context.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        String defaultsDescriptor = this.getWebAppHandler().getDefaultsDescriptor();
        if (defaultsDescriptor != null && defaultsDescriptor.length() > 0) {
            Resource dftResource = Resource.newSystemResource(defaultsDescriptor);
            if (dftResource == null) {
                dftResource = Resource.newResource(defaultsDescriptor);
            }
            XmlParser.Node defaultConfig = this.xmlParser.parse(dftResource.getURL().toString());
            this.initialize(defaultConfig);
        }
    }

    public void configureWebApp() throws Exception {
        if (this._context.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        Resource webInf = this.getWebAppHandler().getWebInf();
        if (webInf != null && webInf.isDirectory()) {
            Resource web = webInf.addPath("web.xml");
            if (!web.exists()) {
                log.info("No WEB-INF/web.xml in " + this.getWebAppHandler().getWar() + ". Serving files and default/dynamic servlets only");
            } else {
                XmlParser.Node config = null;
                config = this.xmlParser.parse(web.getURL().toString());
                this.initialize(config);
            }
        }
    }

    public void deconfigureWebApp() throws Exception {
    }

    protected void initialize(XmlParser.Node config) throws ClassNotFoundException, UnavailableException {
        ServletHandler servlet_handler = this.getWebAppHandler().getServletHandler();
        this.filters = LazyList.array2List(servlet_handler.getFilters());
        this.filterMappings = LazyList.array2List(servlet_handler.getFilterMappings());
        this.servlets = LazyList.array2List(servlet_handler.getServlets());
        this.servletMappings = LazyList.array2List(servlet_handler.getServletMappings());
        this.welcomeFiles = LazyList.array2List(this.getWebAppHandler().getWelcomeFiles());
        this.constraintMappings = LazyList.array2List(this.getWebAppHandler().getSecurityHandler().getConstraintMappings());
        Iterator iter = config.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            try {
                Object o = iter.next();
                if (!(o instanceof XmlParser.Node)) continue;
                node = (XmlParser.Node)o;
                String name = node.getTag();
                this.initWebXmlElement(name, node);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                log.warn("Configuration problem at " + node, (Throwable)e);
                throw new UnavailableException("Configuration problem");
            }
        }
        servlet_handler.setFilters(this.filters.toArray(new FilterHolder[this.filters.size()]));
        servlet_handler.setFilterMappings(this.filterMappings.toArray(new FilterMapping[this.filterMappings.size()]));
        servlet_handler.setServlets(this.servlets.toArray(new ServletHolder[this.servlets.size()]));
        servlet_handler.setServletMappings(this.servletMappings.toArray(new ServletMapping[this.servletMappings.size()]));
        this.getWebAppHandler().setWelcomeFiles(this.welcomeFiles.toArray(new String[this.welcomeFiles.size()]));
    }

    protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
        if ("display-name".equals(element)) {
            this.initDisplayName(node);
        } else if (!"description".equals(element)) {
            if ("context-param".equals(element)) {
                this.initContextParam(node);
            } else if ("servlet".equals(element)) {
                this.initServlet(node);
            } else if ("servlet-mapping".equals(element)) {
                this.initServletMapping(node);
            } else if ("session-config".equals(element)) {
                this.initSessionConfig(node);
            } else if ("mime-mapping".equals(element)) {
                this.initMimeConfig(node);
            } else if ("welcome-file-list".equals(element)) {
                this.initWelcomeFileList(node);
            } else if ("locale-encoding-mapping-list".equals(element)) {
                this.initLocaleEncodingList(node);
            } else if ("error-page".equals(element)) {
                this.initErrorPage(node);
            } else if ("taglib".equals(element)) {
                this.initTagLib(node);
            } else if ("jsp-config".equals(element)) {
                this.initJspConfig(node);
            } else if ("resource-ref".equals(element)) {
                if (log.isDebugEnabled()) {
                    log.debug("No implementation: " + node);
                }
            } else if ("security-constraint".equals(element)) {
                this.initSecurityConstraint(node);
            } else if ("login-config".equals(element)) {
                this.initLoginConfig(node);
            } else if ("security-role".equals(element)) {
                this.initSecurityRole(node);
            } else if ("filter".equals(element)) {
                this.initFilter(node);
            } else if ("filter-mapping".equals(element)) {
                this.initFilterMapping(node);
            } else if ("listener".equals(element)) {
                this.initListener(node);
            } else if ("distributable".equals(element)) {
                this.initDistributable(node);
            } else if (log.isDebugEnabled()) {
                log.debug("Element {} not handled in {}", (Object)element, (Object)this);
                log.debug(node.toString());
            }
        }
    }

    protected void initDisplayName(XmlParser.Node node) {
        this.getWebAppHandler().setServletContextName(node.toString(false, true));
    }

    protected void initContextParam(XmlParser.Node node) {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        if (log.isDebugEnabled()) {
            log.debug("ContextParam: " + name + "=" + value);
        }
        this.getWebAppHandler().getInitParams().put(name, value);
    }

    protected void initFilter(XmlParser.Node node) throws ClassNotFoundException, UnavailableException {
        FilterHolder holder = new FilterHolder();
        holder.setName(node.getString("filter-name", false, true));
        holder.setClassName(node.getString("filter-class", false, true));
        Iterator iter = node.iterator("init-param");
        while (iter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.setInitParameter(pname, pvalue);
        }
        this.filters.add(holder);
    }

    protected void initFilterMapping(XmlParser.Node node) {
        FilterMapping mapping = new FilterMapping();
        mapping.setFilterName(node.getString("filter-name", false, true));
        mapping.setPathSpec(node.getString("url-pattern", false, true));
        mapping.setServletName(node.getString("servlet-name", false, true));
        int dispatcher = 0;
        Iterator iter = node.iterator("dispatcher");
        while (iter.hasNext()) {
            String d = ((XmlParser.Node)iter.next()).toString(false, true);
            dispatcher |= Dispatcher.type(d);
        }
        mapping.setDispatches(dispatcher);
        this.filterMappings.add(mapping);
    }

    protected void initServlet(XmlParser.Node node) throws ClassNotFoundException, UnavailableException, IOException, MalformedURLException {
        String roleName;
        ServletHolder holder = new ServletHolder();
        holder.setName(node.getString("servlet-name", false, true));
        holder.setClassName(node.getString("servlet-class", false, true));
        holder.setForcedPath(node.getString("jsp-file", false, true));
        Iterator iParamsIter = node.iterator("init-param");
        while (iParamsIter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iParamsIter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.setInitParameter(pname, pvalue);
        }
        XmlParser.Node startup = node.get("load-on-startup");
        if (startup != null) {
            String s = startup.toString(false, true).toLowerCase();
            if (s.startsWith("t")) {
                log.warn("Deprecated boolean load-on-startup.  Please use integer");
                holder.setInitOrder(1);
            } else {
                int order = 0;
                try {
                    if (s != null && s.trim().length() > 0) {
                        order = Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    log.warn("Cannot parse load-on-startup " + s + ". Please use integer");
                    LogSupport.ignore(log, e);
                }
                holder.setInitOrder(order);
            }
        }
        Iterator sRefsIter = node.iterator("security-role-ref");
        while (sRefsIter.hasNext()) {
            XmlParser.Node securityRef = (XmlParser.Node)sRefsIter.next();
            roleName = securityRef.getString("role-name", false, true);
            String roleLink = securityRef.getString("role-link", false, true);
            if (roleName != null && roleName.length() > 0 && roleLink != null && roleLink.length() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("link role " + roleName + " to " + roleLink + " for " + this);
                }
                holder.setUserRoleLink(roleName, roleLink);
                continue;
            }
            log.warn("Ignored invalid security-role-ref element: servlet-name=" + holder.getName() + ", " + securityRef);
        }
        XmlParser.Node run_as = node.get("run-as");
        if (run_as != null && (roleName = run_as.getString("role-name", false, true)) != null) {
            holder.setRunAs(roleName);
        }
        this.servlets.add(holder);
    }

    protected void initServletMapping(XmlParser.Node node) {
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName(node.getString("servlet-name", false, true));
        mapping.setPathSpec(node.getString("url-pattern", false, true));
        this.servletMappings.add(mapping);
    }

    protected void initListener(XmlParser.Node node) {
        String className = node.getString("listener-class", false, true);
        Object listener = null;
        try {
            Class listenerClass = this.getWebAppHandler().loadClass(className);
            listener = listenerClass.newInstance();
        }
        catch (Exception e) {
            log.warn("Could not instantiate listener " + className, (Throwable)e);
            return;
        }
        if (!(listener instanceof EventListener)) {
            log.warn("Not an EventListener: " + listener);
            return;
        }
        this.getWebAppHandler().addEventListener(listener);
    }

    protected void initDistributable(XmlParser.Node node) {
        WebAppHandler wac = this.getWebAppHandler();
        if (!wac.isDistributable()) {
            wac.setDistributable(true);
        }
    }

    protected void initSessionConfig(XmlParser.Node node) {
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            int timeout = Integer.parseInt(tNode.toString(false, true));
            this.getWebAppHandler().getSessionHandler().getSessionManager().setMaxInactiveInterval(timeout * 60);
        }
    }

    protected void initMimeConfig(XmlParser.Node node) {
        String extension = node.getString("extension", false, true);
        if (extension != null && extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        String mimeType = node.getString("mime-type", false, true);
        this.getWebAppHandler().getMimeTypes().addMimeMapping(extension, mimeType);
    }

    protected void initWelcomeFileList(XmlParser.Node node) {
        Iterator iter = node.iterator("welcome-file");
        while (iter.hasNext()) {
            XmlParser.Node indexNode = (XmlParser.Node)iter.next();
            String welcome = indexNode.toString(false, true);
            this.welcomeFiles.add(welcome);
        }
    }

    protected void initLocaleEncodingList(XmlParser.Node node) {
        Iterator iter = node.iterator("locale-encoding-mapping");
        while (iter.hasNext()) {
            XmlParser.Node mapping = (XmlParser.Node)iter.next();
            String locale = mapping.getString("locale", false, true);
            String encoding = mapping.getString("encoding", false, true);
            this.getWebAppHandler().addLocaleEncoding(locale, encoding);
        }
    }

    protected void initErrorPage(XmlParser.Node node) {
        String error = node.getString("error-code", false, true);
        if (error == null || error.length() == 0) {
            error = node.getString("exception-type", false, true);
        }
        String location = node.getString("location", false, true);
    }

    protected void initTagLib(XmlParser.Node node) {
        String uri = node.getString("taglib-uri", false, true);
        String location = node.getString("taglib-location", false, true);
    }

    protected void initJspConfig(XmlParser.Node node) {
        for (int i = 0; i < node.size(); ++i) {
            Object o = node.get(i);
            if (!(o instanceof XmlParser.Node) || !"taglib".equals(((XmlParser.Node)o).getTag())) continue;
            this.initTagLib((XmlParser.Node)o);
        }
    }

    protected void initSecurityConstraint(XmlParser.Node node) {
        Constraint scBase = new Constraint();
        try {
            XmlParser.Node data;
            XmlParser.Node auths = node.get("auth-constraint");
            if (auths != null) {
                scBase.setAuthenticate(true);
                Iterator iter = auths.iterator("role-name");
                while (iter.hasNext()) {
                    String role = ((XmlParser.Node)iter.next()).toString(false, true);
                    scBase.addRole(role);
                }
            }
            if ((data = node.get("user-data-constraint")) != null) {
                String guarantee = (data = data.get("transport-guarantee")).toString(false, true).toUpperCase();
                if (guarantee == null || guarantee.length() == 0 || "NONE".equals(guarantee)) {
                    scBase.setDataConstraint(0);
                } else if ("INTEGRAL".equals(guarantee)) {
                    scBase.setDataConstraint(1);
                } else if ("CONFIDENTIAL".equals(guarantee)) {
                    scBase.setDataConstraint(2);
                } else {
                    log.warn("Unknown user-data-constraint:" + guarantee);
                    scBase.setDataConstraint(2);
                }
            }
            Iterator iter = node.iterator("web-resource-collection");
            while (iter.hasNext()) {
                XmlParser.Node collection = (XmlParser.Node)iter.next();
                String name = collection.getString("web-resource-name", false, true);
                Constraint sc = (Constraint)scBase.clone();
                sc.setName(name);
                Iterator iter2 = collection.iterator("url-pattern");
                while (iter2.hasNext()) {
                    String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                    Iterator iter3 = collection.iterator("http-method");
                    if (iter3.hasNext()) {
                        while (iter3.hasNext()) {
                            String method = ((XmlParser.Node)iter3.next()).toString(false, true);
                            ConstraintMapping mapping = new ConstraintMapping();
                            mapping.setMethod(method);
                            mapping.setPathSpec(url);
                            mapping.setConstraint(sc);
                            this.constraintMappings.add(mapping);
                        }
                        continue;
                    }
                    ConstraintMapping mapping = new ConstraintMapping();
                    mapping.setPathSpec(url);
                    mapping.setConstraint(sc);
                    this.constraintMappings.add(mapping);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            log.error("EXCEPTION ", (Throwable)e);
        }
    }

    protected void initLoginConfig(XmlParser.Node node) {
    }

    protected void initSecurityRole(XmlParser.Node node) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

