/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import org.mortbay.io.IO;
import org.mortbay.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppClassLoader
extends URLClassLoader {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$webapp$WebAppClassLoader == null ? (class$org$mortbay$jetty$webapp$WebAppClassLoader = WebAppClassLoader.class$("org.mortbay.jetty.webapp.WebAppClassLoader")) : class$org$mortbay$jetty$webapp$WebAppClassLoader));
    private boolean _parentLoaderPriority = false;
    private ClassLoader _parent;
    private PermissionCollection _permissions;
    private String _urlClassPath;
    private String[] _systemClasses;
    private String[] _serverClasses;
    private File _tmpdir;
    static /* synthetic */ Class class$org$mortbay$jetty$webapp$WebAppClassLoader;

    public WebAppClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this._parent = parent;
        if (parent == null) {
            throw new IllegalArgumentException("no parent classloader!");
        }
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public void setParentLoaderPriority(boolean java2compliant) {
        this._parentLoaderPriority = java2compliant;
    }

    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    public void setPermissions(PermissionCollection permissions) {
        this._permissions = permissions;
    }

    public String getUrlClassPath() {
        return this._urlClassPath;
    }

    public void setTempDirectory(File tmpdir) {
        if (this._tmpdir != null || this._urlClassPath != null) {
            throw new IllegalStateException();
        }
        this._tmpdir = tmpdir;
    }

    public File getTempDirectory() {
        if (this._tmpdir != null) {
            return this._tmpdir;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassPath(String classPath) throws IOException {
        if (classPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
        while (tokenizer.hasMoreTokens()) {
            URL url;
            Resource resource;
            block9: {
                File lib;
                File file;
                resource = Resource.newResource(tokenizer.nextToken());
                if (log.isDebugEnabled()) {
                    log.debug("Path resource=" + resource);
                }
                if ((file = resource.getFile()) != null) {
                    url = resource.getURL();
                    this.addURL(url);
                    this._urlClassPath = this._urlClassPath == null ? url.toString() : this._urlClassPath + "," + url.toString();
                    continue;
                }
                if (resource.isDirectory() || file != null) break block9;
                InputStream in = resource.getInputStream();
                if (this._tmpdir == null) {
                    this._tmpdir = File.createTempFile("jetty.cl.lib", null);
                    this._tmpdir.mkdir();
                    this._tmpdir.deleteOnExit();
                }
                if (!(lib = new File(this._tmpdir, "lib")).exists()) {
                    lib.mkdir();
                    lib.deleteOnExit();
                }
                File jar = File.createTempFile("Jetty-", ".jar", lib);
                jar.deleteOnExit();
                if (log.isDebugEnabled()) {
                    log.debug("Extract " + resource + " to " + jar);
                }
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(jar);
                    IO.copy(in, out);
                }
                catch (Throwable throwable) {
                    IO.close(out);
                    throw throwable;
                }
                IO.close(out);
                URL url2 = jar.toURL();
                this.addURL(url2);
                this._urlClassPath = this._urlClassPath == null ? url2.toString() : this._urlClassPath + "," + url2.toString();
                continue;
            }
            url = resource.getURL();
            this.addURL(url);
            this._urlClassPath = this._urlClassPath == null ? url.toString() : this._urlClassPath + "," + url.toString();
        }
    }

    public void addJars(Resource lib) {
        if (lib.exists() && lib.isDirectory()) {
            String[] files = lib.list();
            for (int f = 0; files != null && f < files.length; ++f) {
                try {
                    Resource fn = lib.addPath(files[f]);
                    String fnlc = fn.getName().toLowerCase();
                    if (!fnlc.endsWith(".jar") && !fnlc.endsWith(".zip")) continue;
                    this.addClassPath(fn.toString());
                    continue;
                }
                catch (Exception ex) {
                    log.warn("EXCEPTION ", (Throwable)ex);
                }
            }
        }
    }

    public void setJava2Compliant(boolean compliant) {
        this._parentLoaderPriority = compliant;
    }

    public boolean isJava2Compliant() {
        return this._parentLoaderPriority;
    }

    public String toString() {
        if (log.isDebugEnabled()) {
            return "ContextLoader@" + this.hashCode() + "(" + this._urlClassPath + ") / " + this._parent;
        }
        return "ContextLoader@" + this.hashCode();
    }

    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection pc;
        PermissionCollection permissionCollection = pc = this._permissions == null ? super.getPermissions(cs) : this._permissions;
        if (log.isDebugEnabled()) {
            log.debug("loader.getPermissions(" + cs + ")=" + pc);
        }
        return pc;
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        boolean tried_parent = false;
        if (c == null && (this._parentLoaderPriority || this.isSystemPath(name)) && !this.isServerPath(name) && this._parent != null) {
            if (log.isDebugEnabled()) {
                log.debug("try loadClass " + name + " from " + this._parent);
            }
            tried_parent = true;
            try {
                c = this._parent.loadClass(name);
                if (log.isDebugEnabled()) {
                    log.debug("loaded " + c);
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null) {
            if (log.isDebugEnabled()) {
                log.debug("try findClass " + name + " from " + this._urlClassPath);
            }
            try {
                c = this.findClass(name);
                if (log.isDebugEnabled()) {
                    log.debug("loaded " + c);
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null && !tried_parent && !this.isServerPath(name) && this._parent != null) {
            if (log.isDebugEnabled()) {
                log.debug("try loadClass " + name + " from " + this._parent);
            }
            c = this._parent.loadClass(name);
            if (log.isDebugEnabled()) {
                log.debug("loaded " + c);
            }
        }
        if (c == null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public synchronized URL getResource(String name) {
        URL url = null;
        boolean tried_parent = false;
        if (this._parentLoaderPriority || this.isSystemPath(name)) {
            if (log.isDebugEnabled()) {
                log.debug("try getResource " + name + " from " + this._parent);
            }
            tried_parent = true;
            if (this._parent != null) {
                url = this._parent.getResource(name);
            }
        }
        if (url == null) {
            if (log.isDebugEnabled()) {
                log.debug("try findResource " + name + " from " + this._urlClassPath);
            }
            if ((url = this.findResource(name)) == null && name.startsWith("/")) {
                if (log.isDebugEnabled()) {
                    log.debug("HACK leading / off " + name);
                }
                url = this.findResource(name.substring(1));
            }
        }
        if (url == null && !tried_parent) {
            if (log.isDebugEnabled()) {
                log.debug("try getResource " + name + " from " + this._parent);
            }
            if (this._parent != null) {
                url = this._parent.getResource(name);
            }
        }
        if (url != null && log.isDebugEnabled()) {
            log.debug("found " + url);
        }
        return url;
    }

    public boolean isServerPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        if (this._serverClasses != null) {
            for (int i = 0; i < this._serverClasses.length; ++i) {
                if (this._serverClasses[i].startsWith("-")) {
                    if (!name.equals(this._serverClasses[i].substring(1))) continue;
                    return false;
                }
                if (!(this._serverClasses[i].endsWith(".") ? name.startsWith(this._serverClasses[i]) : name.equals(this._serverClasses[i]))) continue;
                return true;
            }
            return false;
        }
        if (name.equals("org.mortbay.jetty.servlet.DefaultServlet") || name.startsWith("org.mortbay.jetty.util.")) {
            return false;
        }
        return name.startsWith("org.mortbay.jetty.");
    }

    public boolean isSystemPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        if (this._systemClasses != null) {
            for (int i = 0; i < this._systemClasses.length; ++i) {
                if (this._systemClasses[i].startsWith("-")) {
                    if (!name.equals(this._systemClasses[i].substring(1))) continue;
                    return false;
                }
                if (!(this._systemClasses[i].endsWith(".") ? name.startsWith(this._systemClasses[i]) : name.equals(this._systemClasses[i]))) continue;
                return true;
            }
            return false;
        }
        return name.startsWith("java.") || name.startsWith("javax.servlet.") || name.startsWith("javax.xml.") || name.startsWith("org.mortbay.") || name.startsWith("org.xml.") || name.startsWith("org.w3c.");
    }

    public void destroy() {
        this._parent = null;
        this._permissions = null;
        this._urlClassPath = null;
    }

    String[] getServerClasses() {
        return this._serverClasses;
    }

    public void setServerClasses(String[] serverClasses) {
        this._serverClasses = serverClasses == null ? null : (String[])serverClasses.clone();
    }

    String[] getSystemClasses() {
        return this._systemClasses;
    }

    void setSystemClasses(String[] systemClasses) {
        this._systemClasses = systemClasses == null ? null : (String[])systemClasses.clone();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

