/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.util.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher
implements RequestDispatcher {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$servlet$DefaultServlet == null ? (class$org$mortbay$jetty$servlet$DefaultServlet = Dispatcher.class$("org.mortbay.jetty.servlet.DefaultServlet")) : class$org$mortbay$jetty$servlet$DefaultServlet));
    public static final String __INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String __INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String __INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String __INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String __INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String __FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    public static final String __FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    public static final String __FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    public static final String __FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    public static final String __FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    private ContextHandler _contextHandler;
    private String _uri;
    private String _path;
    private String _query;
    private String _named;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$DefaultServlet;

    public static int type(String type) {
        if ("request".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("forward".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("include".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("error".equalsIgnoreCase(type)) {
            return 8;
        }
        throw new IllegalArgumentException(type);
    }

    public Dispatcher(ContextHandler contextHandler, String uri, String pathInContext, String query) {
        this._contextHandler = contextHandler;
        this._uri = uri;
        this._path = pathInContext;
        this._query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        response.reset();
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        String old_uri = base_request.getRequestURI();
        String old_context_path = base_request.getContextPath();
        String old_query = base_request.getQueryString();
        Attributes old_attr = base_request.getAttributes();
        try {
            String query = this._query;
            ForwardAttributes attr = new ForwardAttributes(old_attr);
            attr._requestURI = base_request.getRequestURI();
            attr._contextPath = base_request.getContextPath();
            attr._servletPath = base_request.getServletPath();
            attr._pathInfo = base_request.getPathInfo();
            attr._query = base_request.getQueryString();
            base_request.setRequestURI(this._uri);
            base_request.setContextPath(this._contextHandler.getContextPath());
            base_request.setAttributes(attr);
            base_request.setQueryString(query);
            this._contextHandler.handle(this._path, (HttpServletRequest)request, (HttpServletResponse)response, 2);
            Object var11_10 = null;
            base_request.setRequestURI(old_uri);
            base_request.setContextPath(old_context_path);
            base_request.setAttributes(old_attr);
            base_request.setQueryString(old_query);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            base_request.setRequestURI(old_uri);
            base_request.setContextPath(old_context_path);
            base_request.setAttributes(old_attr);
            base_request.setQueryString(old_query);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        Attributes old_attr = base_request.getAttributes();
        try {
            String query = this._query;
            IncludeAttributes attr = new IncludeAttributes(old_attr);
            attr._requestURI = this._uri;
            attr._contextPath = this._contextHandler.getContextPath();
            attr._query = query;
            base_request.setAttributes(attr);
            this._contextHandler.handle(this._path, (HttpServletRequest)request, (HttpServletResponse)response, 4);
        }
        finally {
            base_request.setAttributes(old_attr);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class IncludeAttributes
    implements Attributes {
        Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        IncludeAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals(Dispatcher.__INCLUDE_PATH_INFO)) {
                    return this._pathInfo;
                }
                if (key.equals(Dispatcher.__INCLUDE_SERVLET_PATH)) {
                    return this._servletPath;
                }
                if (key.equals(Dispatcher.__INCLUDE_CONTEXT_PATH)) {
                    return this._contextPath;
                }
                if (key.equals(Dispatcher.__INCLUDE_QUERY_STRING)) {
                    return this._query;
                }
                if (key.equals(Dispatcher.__INCLUDE_REQUEST_URI)) {
                    return this._requestURI;
                }
            } else {
                if (key.equals(Dispatcher.__INCLUDE_PATH_INFO)) {
                    return null;
                }
                if (key.equals(Dispatcher.__INCLUDE_REQUEST_URI)) {
                    return null;
                }
                if (key.equals(Dispatcher.__INCLUDE_SERVLET_PATH)) {
                    return null;
                }
                if (key.equals(Dispatcher.__INCLUDE_CONTEXT_PATH)) {
                    return null;
                }
                if (key.equals(Dispatcher.__INCLUDE_QUERY_STRING)) {
                    return null;
                }
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            HashSet set = new HashSet();
            Enumeration e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
            if (Dispatcher.this._named == null) {
                set.add(Dispatcher.__INCLUDE_PATH_INFO);
                set.add(Dispatcher.__INCLUDE_REQUEST_URI);
                set.add(Dispatcher.__INCLUDE_SERVLET_PATH);
                set.add(Dispatcher.__INCLUDE_CONTEXT_PATH);
                set.add(Dispatcher.__INCLUDE_QUERY_STRING);
            } else {
                set.remove(Dispatcher.__INCLUDE_PATH_INFO);
                set.remove(Dispatcher.__INCLUDE_REQUEST_URI);
                set.remove(Dispatcher.__INCLUDE_SERVLET_PATH);
                set.remove(Dispatcher.__INCLUDE_CONTEXT_PATH);
                set.remove(Dispatcher.__INCLUDE_QUERY_STRING);
            }
            return Collections.enumeration(set);
        }

        public void setAttribute(String key, Object value) {
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                if (key.equals(Dispatcher.__INCLUDE_PATH_INFO)) {
                    this._pathInfo = (String)value;
                } else if (key.equals(Dispatcher.__INCLUDE_REQUEST_URI)) {
                    this._requestURI = (String)value;
                } else if (key.equals(Dispatcher.__INCLUDE_SERVLET_PATH)) {
                    this._servletPath = (String)value;
                } else if (key.equals(Dispatcher.__INCLUDE_CONTEXT_PATH)) {
                    this._contextPath = (String)value;
                } else if (key.equals(Dispatcher.__INCLUDE_QUERY_STRING)) {
                    this._query = (String)value;
                } else if (value == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value);
                }
            } else if (value == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "INCLUDE+" + this._attr.toString();
        }

        public void clear() {
            throw new IllegalStateException();
        }

        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }

    private class ForwardAttributes
    implements Attributes {
        Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        ForwardAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals(Dispatcher.__FORWARD_PATH_INFO)) {
                    return this._pathInfo;
                }
                if (key.equals(Dispatcher.__FORWARD_REQUEST_URI)) {
                    return this._requestURI;
                }
                if (key.equals(Dispatcher.__FORWARD_SERVLET_PATH)) {
                    return this._servletPath;
                }
                if (key.equals(Dispatcher.__FORWARD_CONTEXT_PATH)) {
                    return this._contextPath;
                }
                if (key.equals(Dispatcher.__FORWARD_QUERY_STRING)) {
                    return this._query;
                }
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            HashSet set = new HashSet();
            Enumeration e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
            if (Dispatcher.this._named == null) {
                set.add(Dispatcher.__FORWARD_PATH_INFO);
                set.add(Dispatcher.__FORWARD_REQUEST_URI);
                set.add(Dispatcher.__FORWARD_SERVLET_PATH);
                set.add(Dispatcher.__FORWARD_CONTEXT_PATH);
                set.add(Dispatcher.__FORWARD_QUERY_STRING);
            }
            return Collections.enumeration(set);
        }

        public void setAttribute(String key, Object value) {
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                if (key.equals(Dispatcher.__FORWARD_PATH_INFO)) {
                    this._pathInfo = (String)value;
                } else if (key.equals(Dispatcher.__FORWARD_REQUEST_URI)) {
                    this._requestURI = (String)value;
                } else if (key.equals(Dispatcher.__FORWARD_SERVLET_PATH)) {
                    this._servletPath = (String)value;
                } else if (key.equals(Dispatcher.__FORWARD_CONTEXT_PATH)) {
                    this._contextPath = (String)value;
                } else if (key.equals(Dispatcher.__FORWARD_QUERY_STRING)) {
                    this._query = (String)value;
                } else if (value == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value);
                }
            } else if (value == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "FORWARD+" + this._attr.toString();
        }

        public void clear() {
            throw new IllegalStateException();
        }

        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }
}

