/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.security.Principal;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.B64Code;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticator
implements Authenticator {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$security$BasicAuthenticator == null ? (class$org$mortbay$jetty$security$BasicAuthenticator = BasicAuthenticator.class$("org.mortbay.jetty.security.BasicAuthenticator")) : class$org$mortbay$jetty$security$BasicAuthenticator));
    static /* synthetic */ Class class$org$mortbay$jetty$security$BasicAuthenticator;

    public Principal authenticate(UserRealm realm, String pathInContext, Request request, Response response) throws IOException {
        Principal user = null;
        String credentials = request.getHeader("Authorization");
        if (credentials != null) {
            try {
                String password;
                int i;
                if (log.isDebugEnabled()) {
                    log.debug("Credentials: " + credentials);
                }
                credentials = credentials.substring(credentials.indexOf(32) + 1);
                String username = (credentials = B64Code.decode(credentials, StringUtil.__ISO_8859_1)).substring(0, i = credentials.indexOf(58));
                user = realm.authenticate(username, password = credentials.substring(i + 1), request);
                if (user == null) {
                    log.warn("AUTH FAILURE: user " + username);
                } else {
                    request.setAuthType("BASIC");
                    request.setUserPrincipal(user);
                }
            }
            catch (Exception e) {
                log.warn("AUTH FAILURE: " + e.toString());
                LogSupport.ignore(log, e);
            }
        }
        if (user == null && response != null) {
            this.sendChallenge(realm, response);
        }
        return user;
    }

    public String getAuthMethod() {
        return "BASIC";
    }

    public void sendChallenge(UserRealm realm, Response response) throws IOException {
        response.setHeader("WWW-Authenticate", "basic realm=\"" + realm.getName() + '\"');
        response.sendError(401);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

