/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.StringUtil;

public class NotFoundHandler
extends AbstractHandler {
    public boolean handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        int i;
        String method = request.getMethod();
        if (!method.equals("GET") || !request.getRequestURI().equals("/")) {
            response.sendError(404);
            return true;
        }
        response.setStatus(404);
        response.setContentType("text/html");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(1500);
        String uri = request.getRequestURI();
        uri = StringUtil.replace(uri, "<", "&lt;");
        uri = StringUtil.replace(uri, ">", "&gt;");
        writer.write("<HTML>\n<HEAD>\n<TITLE>Error 404 - Not Found");
        writer.write("</TITLE>\n<BODY>\n<H2>Error 404 - Not Found.</H2>\n");
        writer.write("No context on this server matched or handled this request.<BR>");
        writer.write("Contexts known to this server are: <ul>");
        Handler[] handlers = Server.getCurrentServer().getAllHandlers();
        for (i = 0; i < handlers.length; ++i) {
            if (!(handlers[i] instanceof ContextHandler)) continue;
            ContextHandler context = (ContextHandler)handlers[i];
            writer.write("<li><a href=\"");
            writer.write(context.getContextPath());
            writer.write("/\">");
            writer.write(context.getContextPath());
            writer.write("&nbsp;--->&nbsp;");
            writer.write(context.toString());
            writer.write("</a></li>\n");
        }
        writer.write("</ul><small><I>The links above may not work if a virtual host is configured</I></small>");
        for (i = 0; i < 10; ++i) {
            writer.write("\n<!-- Padding for IE                  -->");
        }
        writer.write("\n</BODY>\n</HTML>\n");
        writer.flush();
        response.setContentLength(writer.size());
        ServletOutputStream out = response.getOutputStream();
        writer.writeTo((OutputStream)out);
        out.close();
        return true;
    }
}

