/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.WrappedHandler;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.resource.Resource;
import org.mortbay.util.Loader;
import org.mortbay.util.LogSupport;
import org.mortbay.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextHandler
extends WrappedHandler {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$handler$ContextHandler == null ? (class$org$mortbay$jetty$handler$ContextHandler = ContextHandler.class$("org.mortbay.jetty.handler.ContextHandler")) : class$org$mortbay$jetty$handler$ContextHandler));
    private static ThreadLocal __context = new ThreadLocal();
    private HashMap _attributes;
    private ClassLoader _classLoader;
    private Context _context = new Context();
    private String _contextPath;
    private HashMap _initParams;
    private String _servletContextName;
    private String _docRoot;
    private Resource _baseResource;
    private MimeTypes _mimeTypes;
    private Map _localeEncodingMap;
    private String[] _welcomeFiles;
    private ErrorHandler _errorHandler;
    static /* synthetic */ Class class$org$mortbay$jetty$handler$ContextHandler;

    public static Context getCurrentContext() {
        Context context = (Context)__context.get();
        if (context == null) {
            throw new IllegalStateException("Only valid during call to doStart()");
        }
        return context;
    }

    public ContextHandler() {
        this._attributes = new HashMap();
        this._initParams = new HashMap();
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this._attributes.keySet());
    }

    public HashMap getAttributes() {
        return this._attributes;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getInitParameter(String name) {
        return (String)this._initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public HashMap getInitParams() {
        return this._initParams;
    }

    public String getServletContextName() {
        return this._servletContextName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        ClassLoader old_classloader = null;
        Thread current_thread = null;
        Object old_context = null;
        try {
            if (this._classLoader != null) {
                current_thread = Thread.currentThread();
                old_classloader = current_thread.getContextClassLoader();
                current_thread.setContextClassLoader(this._classLoader);
            }
            if (this._mimeTypes == null) {
                this._mimeTypes = new MimeTypes();
            }
            old_context = __context.get();
            __context.set(this._context);
            if (this._errorHandler == null) {
                this._errorHandler = new ErrorHandler();
            }
            this.startContext();
            Object var5_4 = null;
            __context.set(old_context);
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            __context.set(old_context);
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
            throw throwable;
        }
    }

    protected void startContext() throws Exception {
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        ClassLoader old_classloader = null;
        Thread current_thread = null;
        try {
            if (this._classLoader != null) {
                current_thread = Thread.currentThread();
                old_classloader = current_thread.getContextClassLoader();
                current_thread.setContextClassLoader(this._classLoader);
            }
            super.doStop();
            Object var4_3 = null;
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        boolean handled = false;
        Request base_request = null;
        Context old_context = null;
        String old_context_path = null;
        String old_servlet_path = null;
        String old_path_info = null;
        ClassLoader old_classloader = null;
        Thread current_thread = null;
        try {
            base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
            old_context = base_request.getContext();
            old_context_path = base_request.getContextPath();
            old_servlet_path = base_request.getServletPath();
            old_path_info = base_request.getPathInfo();
            if (old_context != this._context) {
                if (dispatch == 1) {
                    if (target.startsWith(this._contextPath)) {
                        target = target.substring(this._contextPath.length());
                    } else {
                        old_context = this._context;
                        boolean bl = false;
                        Object var15_14 = null;
                        if (old_context == this._context) return bl;
                        if (this._classLoader != null) {
                            current_thread.setContextClassLoader(old_classloader);
                        }
                        base_request.setContext(old_context);
                        base_request.setContextPath(old_context_path);
                        base_request.setServletPath(old_servlet_path);
                        base_request.setPathInfo(old_path_info);
                        return bl;
                    }
                }
                base_request.setContext(this._context);
                if (dispatch != 4 && target.startsWith("/")) {
                    base_request.setContextPath(this._context.getContextPath());
                    base_request.setServletPath(null);
                    base_request.setPathInfo(target);
                }
                if (this._classLoader != null) {
                    current_thread = Thread.currentThread();
                    old_classloader = current_thread.getContextClassLoader();
                    current_thread.setContextClassLoader(this._classLoader);
                }
            }
            handled = this.getHandler().handle(target, base_request, response, dispatch);
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (old_context == this._context) throw throwable;
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
            base_request.setContext(old_context);
            base_request.setContextPath(old_context_path);
            base_request.setServletPath(old_servlet_path);
            base_request.setPathInfo(old_path_info);
            throw throwable;
        }
        Object var15_15 = null;
        if (old_context == this._context) return handled;
        if (this._classLoader != null) {
            current_thread.setContextClassLoader(old_classloader);
        }
        base_request.setContext(old_context);
        base_request.setContextPath(old_context_path);
        base_request.setServletPath(old_servlet_path);
        base_request.setPathInfo(old_path_info);
        return handled;
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public void setAttribute(String name, Object object) {
        this._attributes.put(name, object);
    }

    public void setAttributes(HashMap attributes) {
        this._attributes = attributes;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setInitParams(HashMap initParams) {
        this._initParams = initParams;
    }

    public void setServletContextName(String servletContextName) {
        this._servletContextName = servletContextName;
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public void setBaseResource(Resource base) {
        this._baseResource = base;
        this._docRoot = null;
        try {
            File file = this._baseResource.getFile();
            if (file != null) {
                this._docRoot = file.getCanonicalPath();
                if (this._docRoot.endsWith(File.pathSeparator)) {
                    this._docRoot = this._docRoot.substring(0, this._docRoot.length() - 1);
                }
            }
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", (Throwable)e);
            throw new IllegalArgumentException(base.toString());
        }
    }

    public void setResourceBase(String resourceBase) {
        try {
            this.setBaseResource(Resource.newResource(resourceBase));
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", (Throwable)e);
            throw new IllegalArgumentException(resourceBase);
        }
    }

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public void setWelcomeFiles(String[] files) {
        this._welcomeFiles = files;
    }

    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public String toString() {
        return "ContextHandler@" + Integer.toHexString(this.hashCode()) + "{" + this.getContextPath() + "," + this.getBaseResource() + "}";
    }

    public synchronized Class loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (this._classLoader == null) {
            return Loader.loadClass(this.getClass(), className);
        }
        return this._classLoader.loadClass(className);
    }

    public void addLocaleEncoding(String locale, String encoding) {
        if (this._localeEncodingMap == null) {
            this._localeEncodingMap = new HashMap();
        }
        this._localeEncodingMap.put(locale, encoding);
    }

    public String getLocaleEncoding(Locale locale) {
        if (this._localeEncodingMap == null) {
            return null;
        }
        String encoding = (String)this._localeEncodingMap.get(locale.toString());
        if (encoding == null) {
            encoding = (String)this._localeEncodingMap.get(locale.getLanguage());
        }
        return encoding;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Context
    implements ServletContext {
        private Context() {
        }

        public ContextHandler getContextHandler() {
            return ContextHandler.this;
        }

        public ServletContext getContext(String uripath) {
            return null;
        }

        public int getMajorVersion() {
            return 2;
        }

        public String getMimeType(String file) {
            if (ContextHandler.this._mimeTypes == null) {
                return null;
            }
            Buffer mime = ContextHandler.this._mimeTypes.getMimeByExtension(file);
            if (mime != null) {
                return mime.toString();
            }
            return null;
        }

        public int getMinorVersion() {
            return 4;
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return null;
        }

        public String getRealPath(String path) {
            if (ContextHandler.this._docRoot == null) {
                return null;
            }
            if (path == null) {
                return null;
            }
            if (!(path = URIUtil.canonicalPath(path)).startsWith("/")) {
                path = "/" + path;
            }
            path.replace('/', File.pathSeparatorChar);
            return ContextHandler.this._docRoot + path;
        }

        public RequestDispatcher getRequestDispatcher(String uriInContext) {
            if (uriInContext == null) {
                return null;
            }
            if (!uriInContext.startsWith("/")) {
                return null;
            }
            try {
                String query = null;
                int q = 0;
                q = uriInContext.indexOf(63);
                if (q > 0) {
                    query = uriInContext.substring(q + 1);
                    uriInContext = uriInContext.substring(0, q);
                }
                if ((q = uriInContext.indexOf(59)) > 0) {
                    uriInContext = uriInContext.substring(0, q);
                }
                String pathInContext = URIUtil.canonicalPath(URIUtil.decodePath(uriInContext));
                String uri = URIUtil.addPaths(this.getContextPath(), uriInContext);
                return new Dispatcher(ContextHandler.this, uri, pathInContext, query);
            }
            catch (Exception e) {
                LogSupport.ignore(log, e);
                return null;
            }
        }

        public URL getResource(String path) throws MalformedURLException {
            if (path == null || !path.startsWith("/")) {
                throw new MalformedURLException(path);
            }
            if (ContextHandler.this._baseResource == null) {
                return null;
            }
            try {
                Resource resource = ContextHandler.this._baseResource.addPath(URIUtil.canonicalPath(path));
                return resource.getURL();
            }
            catch (Exception e) {
                LogSupport.ignore(log, e);
                return null;
            }
        }

        public InputStream getResourceAsStream(String path) {
            try {
                URL url = this.getResource(path);
                if (url == null) {
                    return null;
                }
                return url.openStream();
            }
            catch (Exception e) {
                LogSupport.ignore(log, e);
                return null;
            }
        }

        public Set getResourcePaths(String path) {
            if (path == null || !path.startsWith("/")) {
                return Collections.EMPTY_SET;
            }
            if (ContextHandler.this._baseResource == null) {
                return null;
            }
            try {
                Resource resource = ContextHandler.this._baseResource.addPath(URIUtil.canonicalPath(path));
                String[] l = resource.list();
                if (l == null) {
                    HashSet<String> set = new HashSet<String>();
                    for (int i = 0; i < l.length; ++i) {
                        set.add(l[i]);
                    }
                    return set;
                }
            }
            catch (Exception e) {
                LogSupport.ignore(log, e);
            }
            return Collections.EMPTY_SET;
        }

        public String getServerInfo() {
            return "JettyE";
        }

        public Servlet getServlet(String name) throws ServletException {
            return null;
        }

        public Enumeration getServletNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public Enumeration getServlets() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public void log(Exception exception, String msg) {
            log.info(msg, (Throwable)exception);
        }

        public void log(String msg) {
            log.info(msg);
        }

        public void log(String message, Throwable throwable) {
            log.info(message, throwable);
        }

        public String getInitParameter(String name) {
            return ContextHandler.this.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return ContextHandler.this.getInitParameterNames();
        }

        public Object getAttribute(String name) {
            return ContextHandler.this.getAttribute(name);
        }

        public Enumeration getAttributeNames() {
            return ContextHandler.this.getAttributeNames();
        }

        public void setAttribute(String name, Object object) {
            ContextHandler.this.setAttribute(name, object);
        }

        public void removeAttribute(String name) {
            ContextHandler.this.removeAttribute(name);
        }

        public String getServletContextName() {
            return ContextHandler.this.getServletContextName();
        }

        public String getContextPath() {
            return ContextHandler.this._contextPath;
        }

        public String toString() {
            return "ServletContext@" + Integer.toHexString(this.hashCode()) + "{" + this.getContextPath() + "," + ContextHandler.this.getBaseResource() + "}";
        }
    }
}

