/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.mortbay.io.IO;
import org.mortbay.util.LogSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServletWriter
extends PrintWriter {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$ServletWriter == null ? (class$org$mortbay$jetty$ServletWriter = ServletWriter.class$("org.mortbay.jetty.ServletWriter")) : class$org$mortbay$jetty$ServletWriter));
    String encoding = null;
    OutputStream os = null;
    boolean written = false;
    static /* synthetic */ Class class$org$mortbay$jetty$ServletWriter;

    ServletWriter(OutputStream os) throws IOException {
        super(new OutputStreamWriter(os));
        this.os = os;
    }

    ServletWriter(OutputStream os, String encoding) throws IOException {
        super(new OutputStreamWriter(os, encoding));
        this.os = os;
        this.encoding = encoding;
    }

    public void disable() {
        this.out = IO.getNullWriter();
    }

    public void reset() {
        try {
            if (this.written) {
                this.out = IO.getNullWriter();
                super.flush();
            }
            this.out = new OutputStreamWriter(this.os, this.encoding);
            this.written = false;
        }
        catch (UnsupportedEncodingException e) {
            LogSupport.ignore(log, e);
        }
    }

    public boolean isWritten() {
        return this.written;
    }

    public void print(boolean p) {
        this.written = true;
        super.print(p);
    }

    public void print(char p) {
        this.written = true;
        super.print(p);
    }

    public void print(char[] p) {
        this.written = true;
        super.print(p);
    }

    public void print(double p) {
        this.written = true;
        super.print(p);
    }

    public void print(float p) {
        this.written = true;
        super.print(p);
    }

    public void print(int p) {
        this.written = true;
        super.print(p);
    }

    public void print(long p) {
        this.written = true;
        super.print(p);
    }

    public void print(Object p) {
        this.written = true;
        super.print(p);
    }

    public void print(String p) {
        this.written = true;
        super.print(p);
    }

    public void println() {
        this.written = true;
        super.println();
    }

    public void println(boolean p) {
        this.written = true;
        super.println(p);
    }

    public void println(char p) {
        this.written = true;
        super.println(p);
    }

    public void println(char[] p) {
        this.written = true;
        super.println(p);
    }

    public void println(double p) {
        this.written = true;
        super.println(p);
    }

    public void println(float p) {
        this.written = true;
        super.println(p);
    }

    public void println(int p) {
        this.written = true;
        super.println(p);
    }

    public void println(long p) {
        this.written = true;
        super.println(p);
    }

    public void println(Object p) {
        this.written = true;
        super.println(p);
    }

    public void println(String p) {
        this.written = true;
        super.println(p);
    }

    public void write(int c) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(c);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    public void write(char[] cbuf, int off, int len) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(cbuf, off, len);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    public void write(char[] cbuf) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(cbuf, 0, cbuf.length);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    public void write(String s, int off, int len) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(s, off, len);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    public void write(String s) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(s, 0, s.length());
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

