/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.WrappedHandler;
import org.mortbay.thread.AbstractLifeCycle;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.MultiException;

public class Server
extends AbstractLifeCycle
implements Handler,
ThreadPool {
    private static ThreadLocal __server = new ThreadLocal();
    private ThreadPool _threadPool;
    private Connector[] _connectors;
    private Handler[] _handlers;

    public Connector[] getConnectors() {
        return this._connectors;
    }

    public void setConnectors(Connector[] connectors) {
        int i;
        if (this._connectors != null) {
            for (i = 0; i < this._connectors.length; ++i) {
                if (this._connectors[i].getThreadPool() == this) {
                    this._connectors[i].setThreadPool(null);
                }
                if (this._connectors[i].getHandler() != this) continue;
                this._connectors[i].setHandler(null);
            }
        }
        this._connectors = connectors;
        if (this._connectors != null) {
            for (i = 0; i < this._connectors.length; ++i) {
                if (this._connectors[i].getThreadPool() == null) {
                    this._connectors[i].setThreadPool(this);
                }
                if (this._connectors[i].getHandler() != null) continue;
                this._connectors[i].setHandler(this);
            }
        }
    }

    public Handler[] getHandlers() {
        return this._handlers;
    }

    public void setHandlers(Handler[] handlers) {
        this._handlers = handlers;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    protected void doStart() throws Exception {
        MultiException mex = new MultiException();
        if (this._threadPool == null) {
            BoundedThreadPool btp = new BoundedThreadPool();
            btp.setQueue(true);
            this._threadPool = btp;
        }
        try {
            this._threadPool.start();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this._handlers != null) {
            for (int i = 0; i < this._handlers.length; ++i) {
                try {
                    this._handlers[i].start();
                    continue;
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        if (this._connectors != null) {
            for (int i = 0; i < this._connectors.length; ++i) {
                try {
                    this._connectors[i].start();
                    continue;
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    protected void doStop() throws Exception {
        int i;
        MultiException mex = new MultiException();
        if (this._connectors != null) {
            i = this._connectors.length;
            while (i-- > 0) {
                try {
                    this._connectors[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        if (this._handlers != null) {
            i = this._handlers.length;
            while (i-- > 0) {
                try {
                    this._handlers[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        try {
            this._threadPool.stop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        mex.ifExceptionThrow();
    }

    public boolean dispatch(Runnable job) {
        if (this.isRunning()) {
            return this._threadPool.dispatch(job);
        }
        return false;
    }

    public boolean handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        __server.set(this);
        if (this._handlers == null || this._handlers.length == 0) {
            response.sendError(500);
            return true;
        }
        for (int i = 0; i < this._handlers.length; ++i) {
            if (!this._handlers[i].handle(target, request, response, dispatch)) continue;
            return true;
        }
        return false;
    }

    public Handler[] getAllHandlers() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this._handlers.length; ++i) {
            this.expandHandler(this._handlers[i], list);
        }
        return list.toArray(new Handler[list.size()]);
    }

    private void expandHandler(Handler handler, List list) {
        if (handler == null) {
            return;
        }
        list.add(handler);
        if (handler instanceof WrappedHandler) {
            this.expandHandler(((WrappedHandler)handler).getHandler(), list);
        }
        if (handler instanceof HandlerCollection) {
            Handler[] ha = ((HandlerCollection)handler).getHandlers();
            for (int i = 0; ha != null && i < ha.length; ++i) {
                this.expandHandler(ha[i], list);
            }
        }
    }

    public static Server getCurrentServer() {
        return (Server)__server.get();
    }
}

