/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mortbay.resource.Resource;
import org.mortbay.resource.ResourceFactory;
import org.mortbay.thread.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCache
extends AbstractLifeCycle
implements Serializable {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$ResourceCache == null ? (class$org$mortbay$jetty$ResourceCache = ResourceCache.class$("org.mortbay.jetty.ResourceCache")) : class$org$mortbay$jetty$ResourceCache));
    private int _maxCachedFileSize = 260096;
    private int _maxCachedFiles = 1024;
    private int _maxCacheSize = 0x400000;
    protected transient Map _cache;
    protected transient int _cacheSize;
    protected transient int _cachedFiles;
    protected transient Entry _mostRecentlyUsed;
    protected transient Entry _leastRecentlyUsed;
    static /* synthetic */ Class class$org$mortbay$jetty$ResourceCache;

    public int getMaxCachedFileSize() {
        return this._maxCachedFileSize;
    }

    public void setMaxCachedFileSize(int maxCachedFileSize) {
        this._maxCachedFileSize = maxCachedFileSize;
        this._cache.clear();
    }

    public int getMaxCacheSize() {
        return this._maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this._maxCacheSize = maxCacheSize;
        this._cache.clear();
    }

    public int getMaxCachedFiles() {
        return this._maxCachedFiles;
    }

    public void setMaxCachedFiles(int maxCachedFiles) {
        this._maxCachedFiles = maxCachedFiles;
    }

    public void flushCache() {
        this._cache.clear();
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry lookup(String pathInContext, ResourceFactory factory) {
        if (log.isDebugEnabled()) {
            log.debug("lookup " + pathInContext);
        }
        Entry entry = null;
        boolean newEntry = false;
        Object object = this._cache;
        synchronized (object) {
            entry = (Entry)this._cache.get(pathInContext);
            if (entry != null) {
                if (entry != null && !entry.isValid()) {
                    entry = null;
                } else if (log.isDebugEnabled()) {
                    log.debug("CACHE HIT: " + entry);
                }
            }
            if (entry == null) {
                Resource resource = factory.getResource(pathInContext);
                long len = resource.length();
                if (resource.exists()) {
                    if (resource.isDirectory()) {
                        return null;
                    }
                    if (len > 0L && len < (long)this._maxCachedFileSize && len < (long)this._maxCacheSize) {
                        int needed = this._maxCacheSize - (int)len;
                        while (this._cacheSize > needed || this._maxCachedFiles > 0 && this._cachedFiles > this._maxCachedFiles) {
                            this._leastRecentlyUsed.invalidate();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("CACHED: " + resource);
                        }
                        entry = new Entry(pathInContext, resource);
                        newEntry = true;
                    }
                }
            }
        }
        if (!newEntry && entry != null) {
            object = entry;
            synchronized (object) {
                try {
                    while (entry.getKey() != null && entry.getValue() == null) {
                        entry.wait();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return entry;
    }

    public synchronized void doStart() throws Exception {
        this._cache = new HashMap();
        this._cacheSize = 0;
        this._cachedFiles = 0;
    }

    public void doStop() throws InterruptedException {
        if (this._cache != null) {
            this._cache.clear();
        }
        this._cache = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Value {
        public void validate();

        public void invalidate();
    }

    public class Entry {
        String _key;
        Resource _resource;
        Object _value;
        long _lastModified;
        Entry _prev;
        Entry _next;

        Entry(String pathInContext, Resource resource) {
            this._key = pathInContext;
            this._resource = resource;
            this._lastModified = resource.lastModified();
            this._next = ResourceCache.this._mostRecentlyUsed;
            ResourceCache.this._mostRecentlyUsed = this;
            if (this._next != null) {
                this._next._prev = this;
            }
            this._prev = null;
            if (ResourceCache.this._leastRecentlyUsed == null) {
                ResourceCache.this._leastRecentlyUsed = this;
            }
            ResourceCache.this._cache.put(this._key, this);
            ResourceCache.this._cacheSize = (int)((long)ResourceCache.this._cacheSize + this._resource.length());
            ++ResourceCache.this._cachedFiles;
        }

        public String getKey() {
            return this._key;
        }

        public Resource getResource() {
            return this._resource;
        }

        public Object getValue() {
            return this._value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object value) {
            Entry entry = this;
            synchronized (entry) {
                this._value = value;
                if (value != null) {
                    if (value instanceof Value) {
                        ((Value)value).validate();
                    }
                    this.notifyAll();
                }
            }
        }

        boolean isValid() {
            if (this._lastModified == this._resource.lastModified()) {
                if (ResourceCache.this._mostRecentlyUsed != this) {
                    Entry tp = this._prev;
                    Entry tn = this._next;
                    this._next = ResourceCache.this._mostRecentlyUsed;
                    ResourceCache.this._mostRecentlyUsed = this;
                    if (this._next != null) {
                        this._next._prev = this;
                    }
                    this._prev = null;
                    if (tp != null) {
                        tp._next = tn;
                    }
                    if (tn != null) {
                        tn._prev = tp;
                    }
                    if (ResourceCache.this._leastRecentlyUsed == this && tp != null) {
                        ResourceCache.this._leastRecentlyUsed = tp;
                    }
                }
                return true;
            }
            this.invalidate();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() {
            Entry entry = this;
            synchronized (entry) {
                ResourceCache.this._cache.remove(this._key);
                this._key = null;
                ResourceCache.this._cacheSize -= (int)this._resource.length();
                --ResourceCache.this._cachedFiles;
                if (ResourceCache.this._mostRecentlyUsed == this) {
                    ResourceCache.this._mostRecentlyUsed = this._next;
                } else {
                    this._prev._next = this._next;
                }
                if (ResourceCache.this._leastRecentlyUsed == this) {
                    ResourceCache.this._leastRecentlyUsed = this._prev;
                } else {
                    this._next._prev = this._prev;
                }
                this._prev = null;
                this._next = null;
                this._resource = null;
                if (this._value == null) {
                    this.notifyAll();
                } else if (this._value instanceof Value) {
                    ((Value)this._value).invalidate();
                }
                this._value = null;
            }
        }
    }
}

