/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;
import org.mortbay.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypes {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$MimeTypes == null ? (class$org$mortbay$jetty$MimeTypes = MimeTypes.class$("org.mortbay.jetty.MimeTypes")) : class$org$mortbay$jetty$MimeTypes));
    public static final String FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String MESSAGE_HTTP = "message/http";
    public static final String MULTIPART_BYTERANGES = "multipart/byteranges";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_XML = "text/xml";
    private static int index = 1;
    private static final int FORM_ENCODED_ORDINAL = index++;
    private static final int MESSAGE_HTTP_ORDINAL = index++;
    private static final int MULTIPART_BYTERANGES_ORDINAL = index++;
    private static final int TEXT_HTML_ORDINAL = index++;
    private static final int TEXT_PLAIN_ORDINAL = index++;
    private static final int TEXT_XML_ORDINAL = index++;
    public static final BufferCache CACHE = new BufferCache();
    public static final Buffer FORM_ENCODED_BUFFER = CACHE.add("application/x-www-form-urlencoded", FORM_ENCODED_ORDINAL);
    public static final Buffer MESSAGE_HTTP_BUFFER = CACHE.add("message/http", MESSAGE_HTTP_ORDINAL);
    public static final Buffer MULTIPART_BYTERANGES_BUFFER = CACHE.add("multipart/byteranges", MULTIPART_BYTERANGES_ORDINAL);
    public static final Buffer TEXT_HTML_BUFFER = CACHE.add("text/html", TEXT_HTML_ORDINAL);
    public static final Buffer TEXT_PLAIN_BUFFER = CACHE.add("text/plain", TEXT_PLAIN_ORDINAL);
    public static final Buffer TEXT_XML_BUFFER = CACHE.add("text/xml", TEXT_XML_ORDINAL);
    private static final Map __dftMimeMap = new HashMap();
    private static final Map __encodings = new HashMap();
    private Map _mimeMap;
    private Map _encodingMap;
    static /* synthetic */ Class class$org$mortbay$jetty$MimeTypes;

    public synchronized Map getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map mimeMap) {
        if (mimeMap == null) {
            this._mimeMap = null;
            return;
        }
        HashMap m = new HashMap();
        Iterator i = mimeMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            m.put(entry.getKey(), MimeTypes.normalizeMimeType(entry.getValue().toString()));
        }
        this._mimeMap = m;
    }

    public Buffer getMimeByExtension(String filename) {
        Buffer type = null;
        if (filename != null) {
            int i = -1;
            while (type == null && (i = filename.indexOf(".", i + 1)) >= 0 && i < filename.length()) {
                String ext = StringUtil.asciiToLowerCase(filename.substring(i + 1));
                if (this._mimeMap != null) {
                    type = (Buffer)this._mimeMap.get(ext);
                }
                if (type != null) continue;
                type = (Buffer)__dftMimeMap.get(ext);
            }
        }
        if (type == null) {
            if (this._mimeMap != null) {
                type = (Buffer)this._mimeMap.get("*");
            }
            if (type == null) {
                type = (Buffer)__dftMimeMap.get("*");
            }
        }
        return type;
    }

    public void addMimeMapping(String extension, String type) {
        if (this._mimeMap == null) {
            this._mimeMap = new HashMap();
        }
        this._mimeMap.put(StringUtil.asciiToLowerCase(extension), MimeTypes.normalizeMimeType(type));
    }

    public synchronized Map getEncodingMap() {
        return this._encodingMap;
    }

    public void setEncodingMap(Map encodingMap) {
        if (encodingMap == null) {
            this._encodingMap = null;
            return;
        }
        HashMap e = new HashMap();
        Iterator i = encodingMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            e.put(MimeTypes.normalizeMimeType(entry.getKey().toString()), entry.getValue());
        }
        this._encodingMap = e;
    }

    public String getEncodingByMimeType(String type) {
        String encoding = null;
        if (type != null) {
            encoding = (String)this._encodingMap.get(type);
        }
        return encoding;
    }

    public void addTypeEncoding(String mimeType, String encoding) {
        this.getEncodingMap().put(mimeType, encoding);
    }

    private static synchronized Buffer normalizeMimeType(String type) {
        BufferCache.CachedBuffer b = CACHE.get(type);
        if (b == null) {
            b = CACHE.add(type, index++);
        }
        return b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ResourceBundle mime = ResourceBundle.getBundle("org/mortbay/jetty/mime");
        Enumeration<String> i = mime.getKeys();
        while (i.hasMoreElements()) {
            String ext = i.nextElement();
            String m = mime.getString(ext);
            __dftMimeMap.put(StringUtil.asciiToLowerCase(ext), MimeTypes.normalizeMimeType(m));
        }
        ResourceBundle encoding = ResourceBundle.getBundle("org/mortbay/jetty/encoding");
        i = encoding.getKeys();
        while (i.hasMoreElements()) {
            Buffer type = MimeTypes.normalizeMimeType(i.nextElement());
            __encodings.put(type, encoding.getString(type.toString()));
        }
    }
}

