/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.Resource;
import org.mortbay.xml.XmlParser;

public class TagLibConfiguration
implements WebApplicationContext.Configuration {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$servlet$TagLibConfiguration == null ? (class$org$mortbay$jetty$servlet$TagLibConfiguration = TagLibConfiguration.class$("org.mortbay.jetty.servlet.TagLibConfiguration")) : class$org$mortbay$jetty$servlet$TagLibConfiguration));
    WebApplicationContext _context;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$TagLibConfiguration;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$WebApplicationContext;

    public void setWebApplicationContext(WebApplicationContext context) {
        this._context = context;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this._context;
    }

    public void configureClassPath() throws Exception {
    }

    public void configureDefaults() throws Exception {
    }

    public void configureWebApp() throws Exception {
        Resource l;
        HashSet<Resource> tlds = new HashSet<Resource>();
        if (this._context.getResourceAliases() != null) {
            Iterator iter = this._context.getResourceAliases().values().iterator();
            while (iter.hasNext()) {
                String location = (String)iter.next();
                if (location == null || !location.toLowerCase().endsWith(".tld")) continue;
                if (!location.startsWith("/")) {
                    location = "/WEB-INF/" + location;
                }
                l = this._context.getBaseResource().addPath(location);
                tlds.add(l);
            }
        }
        if (this._context.getWebInf() != null) {
            String[] contents = this._context.getWebInf().list();
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i] == null || !contents[i].toLowerCase().endsWith(".tld")) continue;
                l = this._context.getWebInf().addPath(contents[i]);
                tlds.add(l);
            }
            Resource lib = this._context.getWebInf().addPath("lib/");
            if (lib.exists() && lib.isDirectory()) {
                contents = lib.list();
                for (int i = 0; i < contents.length; ++i) {
                    if (contents[i] == null || !contents[i].toLowerCase().endsWith(".jar")) continue;
                    Resource l2 = lib.addPath(contents[i]);
                    Resource meta = Resource.newResource("jar:" + l2 + "!/META-INF/");
                    if (!meta.exists()) continue;
                    String[] meta_contents = meta.list();
                    for (int j = 0; j < meta_contents.length; ++j) {
                        if (meta_contents[j] == null || !meta_contents[j].toLowerCase().endsWith(".tld")) continue;
                        Resource t = meta.addPath(meta_contents[j]);
                        tlds.add(t);
                    }
                }
            }
        }
        XmlParser parser = new XmlParser(false);
        parser.redirectEntity("web-jsptaglibrary_1_1.dtd", (class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = TagLibConfiguration.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext).getResource("/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd"));
        parser.redirectEntity("web-jsptaglibrary_1_2.dtd", (class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = TagLibConfiguration.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext).getResource("/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd"));
        parser.redirectEntity("web-jsptaglibrary_2_0.xsd", (class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = TagLibConfiguration.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext).getResource("/javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd"));
        parser.setXpath("/taglib/listener/listener-class");
        Iterator iter = tlds.iterator();
        while (iter.hasNext()) {
            try {
                Resource tld = (Resource)iter.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TLD=" + tld));
                }
                XmlParser.Node root = parser.parse(tld.getURL());
                for (int i = 0; i < root.size(); ++i) {
                    XmlParser.Node node;
                    Object o = root.get(i);
                    if (!(o instanceof XmlParser.Node) || !"listener".equals((node = (XmlParser.Node)o).getTag())) continue;
                    String className = node.getString("listener-class", false, true);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("listener=" + className));
                    }
                    try {
                        Class listenerClass = this.getWebApplicationContext().loadClass(className);
                        EventListener l3 = (EventListener)listenerClass.newInstance();
                        this._context.addEventListener(l3);
                        continue;
                    }
                    catch (Exception e) {
                        log.warn((Object)("Could not instantiate listener " + className), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

