/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.server;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;

public class MethodMapper {
    private HashMap map = null;

    public static String getterSignature(MBeanAttributeInfo info) {
        ModelMBeanAttributeInfo minfo;
        Descriptor desc;
        String methodName;
        if (null == info) {
            throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
        }
        String sig = null;
        if (info instanceof ModelMBeanAttributeInfo && (methodName = (String)(desc = (minfo = (ModelMBeanAttributeInfo)info).getDescriptor()).getFieldValue("getMethod")) != null) {
            sig = MethodMapper.methodSignature(info.getType(), methodName, null);
        }
        if (sig == null) {
            String prefix = info.isIs() ? "is" : "get";
            sig = MethodMapper.methodSignature(info.getType(), prefix + info.getName(), null);
        }
        return sig;
    }

    public static String setterSignature(MBeanAttributeInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
        }
        String sig = null;
        if (info instanceof ModelMBeanAttributeInfo) {
            ModelMBeanAttributeInfo minfo = (ModelMBeanAttributeInfo)info;
            Descriptor desc = minfo.getDescriptor();
            String methodName = (String)desc.getFieldValue("setMethod");
            String[] typeSig = new String[]{info.getType()};
            if (methodName != null) {
                sig = MethodMapper.methodSignature(Void.TYPE.getName(), methodName, typeSig);
            }
        }
        if (sig == null) {
            String[] typeSig = new String[]{info.getType()};
            sig = MethodMapper.methodSignature(Void.TYPE.getName(), "set" + info.getName(), typeSig);
        }
        return sig;
    }

    public static String operationSignature(MBeanOperationInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("MBeanOperationInfo cannot be null");
        }
        MBeanParameterInfo[] params = info.getSignature();
        String[] signature = new String[params.length];
        for (int i = 0; i < signature.length; ++i) {
            signature[i] = params[i].getType();
        }
        return MethodMapper.methodSignature(info.getReturnType(), info.getName(), signature);
    }

    public static String methodSignature(Method method) {
        if (null == method) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        Class<?>[] paramtypes = method.getParameterTypes();
        String[] signature = new String[paramtypes.length];
        for (int i = 0; i < signature.length; ++i) {
            signature[i] = paramtypes[i].getName();
        }
        return MethodMapper.methodSignature(method.getReturnType().getName(), method.getName(), signature);
    }

    public static String methodSignature(String returnType, String name, String[] signature) {
        if (null == returnType) {
            throw new IllegalArgumentException("returnType cannot be null");
        }
        if (null == name) {
            throw new IllegalArgumentException("method name cannot be null");
        }
        StringBuffer buf = new StringBuffer(returnType).append(';').append(name);
        if (null == signature) {
            return buf.toString();
        }
        for (int i = 0; i < signature.length; ++i) {
            buf.append(';').append(signature[i]);
        }
        return buf.toString();
    }

    public MethodMapper(Class resourceClass) {
        this.map = this.createMap(resourceClass);
    }

    public Method lookupOperation(MBeanOperationInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("MBeanOperationInfo cannot be null");
        }
        return (Method)this.map.get(MethodMapper.operationSignature(info));
    }

    public Method lookupOperation(MBeanOperationInfo info, Object mbean) {
        Class<?> mbeanClass = mbean.getClass();
        Method m = null;
        try {
            ClassLoader loader = mbeanClass.getClassLoader();
            MBeanParameterInfo[] params = info.getSignature();
            Class[] signature = new Class[params.length];
            for (int i = 0; i < signature.length; ++i) {
                Class<?> type;
                signature[i] = type = loader.loadClass(params[i].getType());
            }
            if (Object.class.equals((m = mbeanClass.getMethod(info.getName(), signature)).getDeclaringClass())) {
                m = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return m;
    }

    public Method lookupGetter(MBeanAttributeInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
        }
        return (Method)this.map.get(MethodMapper.getterSignature(info));
    }

    public Method lookupSetter(MBeanAttributeInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
        }
        return (Method)this.map.get(MethodMapper.setterSignature(info));
    }

    public Method lookupMethod(String returnType, String name, String[] signature) {
        if (null == returnType) {
            throw new IllegalArgumentException("returnType cannot be null");
        }
        if (null == name) {
            throw new IllegalArgumentException("method name cannot be null");
        }
        return (Method)this.map.get(MethodMapper.methodSignature(returnType, name, signature));
    }

    protected HashMap createMap(Class resourceClass) {
        HashMap<String, Method> cmap = new HashMap<String, Method>();
        if (resourceClass != null) {
            Method[] methods = resourceClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                cmap.put(MethodMapper.methodSignature(methods[i]), methods[i]);
            }
        }
        return cmap;
    }
}

