/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.io.InputStream;
import org.jboss.logging.Logger;
import org.jboss.mx.service.ServiceConstants;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMBeanEntityResolver
implements EntityResolver,
ServiceConstants {
    private static final Logger log = Logger.getLogger((Class)XMBeanEntityResolver.class);

    public InputSource resolveEntity(String publicId, String systemId) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("resolveEntity() : publicId=" + publicId + ", systemId=" + systemId));
        }
        if (publicId == null) {
            return null;
        }
        try {
            if (publicId.equals("-//JBoss//DTD JBOSS XMBEAN 1.0//EN")) {
                InputStream dtdStream = this.getClass().getResourceAsStream("/dtd/jboss_xmbean_1_0.dtd");
                return new InputSource(dtdStream);
            }
            if (publicId.equals("-//JBoss//DTD JBOSS XMBEAN 1.1//EN")) {
                InputStream dtdStream = this.getClass().getResourceAsStream("/dtd/jboss_xmbean_1_1.dtd");
                return new InputSource(dtdStream);
            }
            if (publicId.equals("-//JBoss//DTD JBOSS XMBEAN 1.2//EN")) {
                InputStream dtdStream = this.getClass().getResourceAsStream("/dtd/jboss_xmbean_1_2.dtd");
                return new InputSource(dtdStream);
            }
            log.warn((Object)("Cannot resolve entity: " + publicId));
        }
        catch (Exception ignore) {
            log.error((Object)("Cannot load local entity resource for: " + publicId));
        }
        return null;
    }
}

