/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoaderUtils;
import org.jboss.mx.loading.LoadMgr3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.mx.loading.UnifiedLoaderRepository3;

public class HeirarchicalLoaderRepository3
extends UnifiedLoaderRepository3 {
    private static final Logger log = Logger.getLogger((Class)HeirarchicalLoaderRepository3.class);
    private static ObjectName DEFAULT_LOADER_NAME;
    private UnifiedLoaderRepository3 parentRepository;
    private boolean java2ParentDelegation;
    static /* synthetic */ Class class$org$jboss$mx$loading$RepositoryClassLoader;

    public HeirarchicalLoaderRepository3(UnifiedLoaderRepository3 parent) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this.parentRepository = parent;
    }

    public HeirarchicalLoaderRepository3(MBeanServer server) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this(server, DEFAULT_LOADER_NAME);
    }

    public HeirarchicalLoaderRepository3(MBeanServer server, ObjectName parentName) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this.parentRepository = (UnifiedLoaderRepository3)server.getAttribute(parentName, "Instance");
    }

    public RepositoryClassLoader newClassLoader(URL url, boolean addToRepository) throws Exception {
        UnifiedClassLoader3 ucl = null;
        ucl = !this.java2ParentDelegation ? new UnifiedClassLoader3(url, null, (ClassLoader)new NoParentClassLoader(), this) : new UnifiedClassLoader3(url, null, this);
        if (addToRepository) {
            this.addClassLoader(ucl);
        }
        return ucl;
    }

    public RepositoryClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception {
        UnifiedClassLoader3 ucl = null;
        ucl = !this.java2ParentDelegation ? new UnifiedClassLoader3(url, origURL, (ClassLoader)new NoParentClassLoader(), this) : new UnifiedClassLoader3(url, origURL, this);
        if (addToRepository) {
            this.addClassLoader(ucl);
        }
        return ucl;
    }

    public boolean getUseParentFirst() {
        return this.java2ParentDelegation;
    }

    public void setUseParentFirst(boolean flag) {
        this.java2ParentDelegation = flag;
    }

    public Class loadClass(String name, boolean resolve, ClassLoader scl) throws ClassNotFoundException {
        Class foundClass;
        block7: {
            foundClass = null;
            if (this.java2ParentDelegation) {
                try {
                    foundClass = this.parentRepository.loadClass(name, resolve, scl);
                }
                catch (ClassNotFoundException e) {
                    if (foundClass == null) {
                        foundClass = super.loadClass(name, resolve, scl);
                    }
                    break block7;
                }
            }
            try {
                foundClass = super.loadClass(name, resolve, scl);
            }
            catch (ClassNotFoundException e) {
                if (foundClass != null) break block7;
                foundClass = this.parentRepository.loadClass(name, resolve, scl);
            }
        }
        if (foundClass != null) {
            return foundClass;
        }
        throw new ClassNotFoundException(name);
    }

    public Class getCachedClass(String classname) {
        Class clazz = null;
        if (this.java2ParentDelegation) {
            clazz = this.parentRepository.getCachedClass(classname);
            if (clazz == null) {
                clazz = super.getCachedClass(classname);
            }
        } else {
            clazz = super.getCachedClass(classname);
        }
        return clazz;
    }

    public URL getResource(String name, ClassLoader scl) {
        URL resource = null;
        if (this.java2ParentDelegation) {
            resource = this.getParentResource(name, scl);
            if (resource == null) {
                resource = super.getResource(name, scl);
            }
        } else {
            resource = super.getResource(name, scl);
            if (resource == null) {
                resource = this.getParentResource(name, scl);
            }
        }
        return resource;
    }

    public void getResources(String name, ClassLoader cl, List urls) {
        if (this.java2ParentDelegation) {
            this.parentRepository.getResources(name, cl, urls);
            super.getResources(name, cl, urls);
        } else {
            super.getResources(name, cl, urls);
            this.parentRepository.getResources(name, cl, urls);
        }
    }

    public URL[] getURLs() {
        URL[] ourURLs = super.getURLs();
        URL[] parentURLs = this.parentRepository.getURLs();
        int size = ourURLs.length + parentURLs.length;
        URL[] urls = new URL[size];
        System.arraycopy(ourURLs, 0, urls, 0, ourURLs.length);
        System.arraycopy(parentURLs, 0, urls, ourURLs.length, parentURLs.length);
        return urls;
    }

    public Class loadClassFromCache(String name) {
        Class foundClass = null;
        if (this.java2ParentDelegation) {
            foundClass = this.parentRepository.loadClassFromCache(name);
            if (foundClass == null) {
                foundClass = super.loadClassFromCache(name);
            }
        } else {
            foundClass = super.loadClassFromCache(name);
        }
        return foundClass;
    }

    public Set getPackageClassLoaders(String name) {
        Set pkgSet = super.getPackageClassLoaders(name);
        Set parentPkgSet = this.parentRepository.getPackageClassLoaders(name);
        GetClassLoadersAction action = new GetClassLoadersAction(name, pkgSet, parentPkgSet);
        Set theSet = (Set)AccessController.doPrivileged(action);
        return theSet;
    }

    public int compare(LoaderRepository lr) {
        if (lr == this) {
            return 0;
        }
        return this.reverseCompare(lr);
    }

    protected int reverseCompare(LoaderRepository lr) {
        if (lr != this.parentRepository) {
            return 0;
        }
        if (this.java2ParentDelegation) {
            return 1;
        }
        return -1;
    }

    private URL getParentResource(String name, ClassLoader scl) {
        URL resource = this.parentRepository.getResourceFromGlobalCache(name);
        if (resource != null) {
            return resource;
        }
        resource = this.parentRepository.getResourceFromRepository(name, scl);
        return resource;
    }

    static {
        try {
            DEFAULT_LOADER_NAME = new ObjectName("JMImplementation:service=LoaderRepository,name=Default");
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialize default loader name", (Throwable)e);
        }
    }

    private class GetClassLoadersAction
    implements PrivilegedAction {
        private String name;
        Set pkgSet;
        Set parentPkgSet;

        GetClassLoadersAction(String name, Set pkgSet, Set parentPkgSet) {
            this.name = name;
            this.pkgSet = pkgSet;
            this.parentPkgSet = parentPkgSet;
        }

        public Object run() {
            Class cacheClass;
            LoadMgr3.PkgClassLoader pkgUcl;
            RepositoryClassLoader ucl;
            Iterator iter;
            Set theSet = ClassLoaderUtils.newPackageSet();
            if (this.pkgSet != null) {
                iter = this.pkgSet.iterator();
                while (iter.hasNext()) {
                    ucl = (RepositoryClassLoader)iter.next();
                    pkgUcl = new LoadMgr3.PkgClassLoader(ucl, 0);
                    theSet.add(pkgUcl);
                }
            }
            if (!HeirarchicalLoaderRepository3.this.java2ParentDelegation && (cacheClass = HeirarchicalLoaderRepository3.this.parentRepository.loadClassFromCache(this.name)) != null) {
                ucl = new CacheClassLoader(cacheClass, (LoaderRepository)HeirarchicalLoaderRepository3.this);
                pkgUcl = new LoadMgr3.PkgClassLoader(ucl, 1);
                theSet.add(pkgUcl);
            }
            if (this.parentPkgSet != null) {
                iter = this.parentPkgSet.iterator();
                while (iter.hasNext()) {
                    ucl = (RepositoryClassLoader)iter.next();
                    pkgUcl = new LoadMgr3.PkgClassLoader(ucl, 2);
                    theSet.add(pkgUcl);
                }
            }
            if (!HeirarchicalLoaderRepository3.this.java2ParentDelegation) {
                ClassLoader loader = (class$org$jboss$mx$loading$RepositoryClassLoader == null ? (class$org$jboss$mx$loading$RepositoryClassLoader = HeirarchicalLoaderRepository3.class$("org.jboss.mx.loading.RepositoryClassLoader")) : class$org$jboss$mx$loading$RepositoryClassLoader).getClassLoader();
                ucl = null;
                ucl = loader instanceof RepositoryClassLoader ? (RepositoryClassLoader)loader : new UnifiedClassLoader3(null, null, HeirarchicalLoaderRepository3.this);
                pkgUcl = new LoadMgr3.PkgClassLoader(ucl, 3);
                theSet.add(pkgUcl);
            }
            return theSet;
        }
    }

    static class CacheClassLoader
    extends UnifiedClassLoader3 {
        Class cacheClass;

        CacheClassLoader(Class cacheClass, LoaderRepository rep) {
            super(null, null, (ClassLoader)new NoParentClassLoader(), rep);
            this.cacheClass = cacheClass;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            Class c = this.cacheClass;
            if (!name.equals(this.cacheClass.getName())) {
                c = null;
            }
            return c;
        }
    }

    static class NoParentClassLoader
    extends ClassLoader {
        NoParentClassLoader() {
            super((class$org$jboss$mx$loading$HeirarchicalLoaderRepository3 == null ? (class$org$jboss$mx$loading$HeirarchicalLoaderRepository3 = HeirarchicalLoaderRepository3.class$("org.jboss.mx.loading.HeirarchicalLoaderRepository3")) : class$org$jboss$mx$loading$HeirarchicalLoaderRepository3).getClassLoader());
        }

        public URL getResource(String name) {
            return null;
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            throw new ClassNotFoundException("NoParentClassLoader has no classes");
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException("NoParentClassLoader has no classes");
        }
    }
}

