/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.client;

import java.util.Locale;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Variant;

public final class Entity<T> {
    private final T entity;
    private final Variant variant;

    public static <T> Entity<T> entity(T entity, MediaType mediaType) {
        return new Entity<T>(entity, mediaType);
    }

    public static <T> Entity<T> entity(T entity, String mediaType) throws IllegalArgumentException {
        return new Entity<T>(entity, MediaType.valueOf(mediaType));
    }

    public static <T> Entity<T> entity(T entity, Variant variant) {
        return new Entity<T>(entity, variant);
    }

    public static <T> Entity<T> text(T entity) {
        return new Entity<T>(entity, MediaType.TEXT_PLAIN_TYPE);
    }

    public static <T> Entity<T> xml(T entity) {
        return new Entity<T>(entity, MediaType.APPLICATION_XML_TYPE);
    }

    public static <T> Entity<T> json(T entity) {
        return new Entity<T>(entity, MediaType.APPLICATION_JSON_TYPE);
    }

    public static <T> Entity<T> html(T entity) {
        return new Entity<T>(entity, MediaType.TEXT_HTML_TYPE);
    }

    public static <T> Entity<T> xhtml(T entity) {
        return new Entity<T>(entity, MediaType.APPLICATION_XHTML_XML_TYPE);
    }

    public static Entity<Form> form(Form form) {
        return new Entity<Form>(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    public static Entity<Form> form(MultivaluedMap<String, String> formData) {
        return new Entity<Form>(new Form(formData), MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    private Entity(T entity, MediaType mediaType) {
        this.entity = entity;
        this.variant = new Variant(mediaType, (Locale)null, null);
    }

    private Entity(T entity, Variant variant) {
        this.entity = entity;
        this.variant = variant;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public MediaType getMediaType() {
        return this.variant.getMediaType();
    }

    public String getEncoding() {
        return this.variant.getEncoding();
    }

    public Locale getLanguage() {
        return this.variant.getLanguage();
    }

    public T getEntity() {
        return this.entity;
    }
}

