/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

public abstract class TypeLiteral<T> {
    private transient Type type;
    private transient Class<T> rawType;
    private transient Type[] parameterTypes;

    public static <T> TypeLiteral<T> of(final Class<?> rawType, final Type type) {
        return new TypeLiteral<T>(){

            @Override
            Class<T> _rawType() {
                return rawType;
            }

            @Override
            Type _type() {
                return type;
            }
        };
    }

    protected TypeLiteral() {
    }

    Type _type() {
        return this.type;
    }

    Class<T> _rawType() {
        return this.rawType;
    }

    public final Type getType() {
        if (this.type == null) {
            this.type = this._type();
            if (this.type == null) {
                Class<?> typeLiteralSubclass = TypeLiteral.getTypeLiteralSubclass(this.getClass());
                this.type = TypeLiteral.getTypeParameter(typeLiteralSubclass);
                if (this.type == null) {
                    throw new RuntimeException(this.getClass() + " does not specify the type parameter T of TypeLiteral<T>");
                }
            }
        }
        return this.type;
    }

    public final Type[] getParameterTypes() {
        if (this.parameterTypes == null) {
            Type t = this.getType();
            this.parameterTypes = t instanceof ParameterizedType ? ((ParameterizedType)t).getActualTypeArguments() : new Type[0];
        }
        return this.parameterTypes;
    }

    public final Class<T> getRawType() {
        if (this.rawType == null) {
            Type t = this.getType();
            return TypeLiteral.getRawType(t);
        }
        return this.rawType;
    }

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof GenericArrayType) {
            return Object[].class;
        }
        if (type instanceof WildcardType) {
            return null;
        }
        throw new RuntimeException("Illegal type");
    }

    private static Class<?> getTypeLiteralSubclass(Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(TypeLiteral.class)) {
            return clazz;
        }
        if (!TypeLiteral.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("No type information has been specified for this TypeLiteral instance.");
        }
        return TypeLiteral.getTypeLiteralSubclass(superClass);
    }

    private static Type getTypeParameter(Class<?> typeLiteralSubclass) {
        ParameterizedType parameterizedType;
        Type type = typeLiteralSubclass.getGenericSuperclass();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getActualTypeArguments().length == 1) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj instanceof TypeLiteral) {
            TypeLiteral that = (TypeLiteral)obj;
            return this.getType().equals(that.getType());
        }
        return result;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        return "TypeLiteral{" + this.getType().toString() + "}";
    }
}

