/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.client;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.client.FactoryFinder;
import javax.ws.rs.ext.ClientBuilderFactory;

public class ClientFactory {
    private static final Logger LOGGER = Logger.getLogger(Client.class.getName());
    public static final String JAXRS_DEFAULT_CLIENT_BUILDER_FACTORY_PROPERTY = "javax.ws.rs.ext.ClientBuilderFactory";
    private static final String JAXRS_DEFAULT_CLIENT_BUILDER_FACTORY = "org.glassfish.jersey.client.Client$Builder$Factory";

    private static <FACTORY extends ClientBuilderFactory<?>> FACTORY getFactory(Class<FACTORY> builderFactoryClass) {
        try {
            return (FACTORY)((ClientBuilderFactory)builderFactoryClass.newInstance());
        }
        catch (InstantiationException ex) {
            LOGGER.log(Level.SEVERE, "Unable to instantiate client builder factory.", ex);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.SEVERE, "Unable to instantiate client builder factory.", ex);
        }
        return null;
    }

    private static ClientBuilderFactory<? extends Client.Builder<Client>> getDefaultFactory() {
        try {
            Object delegate = FactoryFinder.find(JAXRS_DEFAULT_CLIENT_BUILDER_FACTORY_PROPERTY, JAXRS_DEFAULT_CLIENT_BUILDER_FACTORY);
            if (!(delegate instanceof ClientBuilderFactory)) {
                Class<ClientBuilderFactory> pClass = ClientBuilderFactory.class;
                String classnameAsResource = pClass.getName().replace('.', '/') + ".class";
                ClassLoader loader = pClass.getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                URL targetTypeURL = loader.getResource(classnameAsResource);
                throw new LinkageError("ClassCastException: attempting to cast" + delegate.getClass().getClassLoader().getResource(classnameAsResource) + "to" + targetTypeURL.toString());
            }
            return (ClientBuilderFactory)delegate;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <B extends Client.Builder> B newClientBy(Class<? extends ClientBuilderFactory<B>> builderFactoryClass) {
        return ClientFactory.getFactory(builderFactoryClass).newBuilder();
    }

    public static Client newClient() {
        return ClientFactory.getDefaultFactory().newBuilder().build();
    }

    public static Client newClient(Configuration configuration) {
        return ClientFactory.getDefaultFactory().newBuilder().build(configuration);
    }

    private ClientFactory() {
    }
}

