/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLRootRecord
extends UnmarshalRecord {
    private Class targetClass;
    private StrBuffer characters;
    private boolean shouldReadChars;
    private int elementCount;

    public XMLRootRecord(Class cls) {
        super(null);
        this.targetClass = cls;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.characters == null) {
            this.characters = new StrBuffer();
        }
        if (this.shouldReadChars) {
            this.characters.append(ch, start, length);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.shouldReadChars = false;
    }

    @Override
    public Object getCurrentObject() {
        XMLRoot xmlRoot = new XMLRoot();
        xmlRoot.setLocalName(this.getLocalName());
        xmlRoot.setNamespaceURI(this.getRootElementNamespaceUri());
        if (this.currentObject == null) {
            String val = null;
            if (this.characters != null) {
                val = this.characters.toString();
            }
            xmlRoot.setObject(((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(val, this.targetClass));
        } else {
            xmlRoot.setObject(this.currentObject);
        }
        return xmlRoot;
    }

    @Override
    public void startDocument() throws SAXException {
        this.characters = null;
        this.elementCount = 0;
        this.shouldReadChars = true;
    }

    @Override
    public void initializeRecord(Mapping selfRecordMapping) throws SAXException {
    }

    @Override
    public void initializeRecord(XMLMapping selfRecordMapping) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.rootElementName == null) {
            this.rootElementName = qName;
            this.rootElementLocalName = localName;
            this.rootElementNamespaceUri = namespaceURI;
        }
        if ("".equals(localName)) {
            return;
        }
        ++this.elementCount;
        if (this.elementCount > 1) {
            this.shouldReadChars = false;
        }
    }
}

