/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.AnyCollectionMapping;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAbstractAnyMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLAnyCollectionMapping
extends XMLAbstractAnyMapping
implements AnyCollectionMapping<AttributeAccessor, ContainerPolicy, ClassDescriptor, DatabaseField, Session>,
XMLMapping,
ContainerMapping {
    private XMLField field;
    private ContainerPolicy containerPolicy = ContainerPolicy.buildDefaultPolicy();
    private boolean defaultEmptyContainer = true;
    private boolean useXMLRoot = false;
    private boolean mixedContent = true;
    private boolean isWhitespacePreservedForMixedContent = false;
    private boolean areOtherMappingInThisContext = true;
    private XMLConverter valueConverter;
    private boolean reuseContainer;
    private AbstractNullPolicy wrapperNullPolicy;

    public XMLAnyCollectionMapping() {
        this.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_NONE_AS_ELEMENT);
    }

    @Override
    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupClone");
    }

    @Override
    public void buildClone(Object original, CacheKey cacheKey, Object clone, Integer refreshCascade, AbstractSession cloningSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildClone");
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneFromRow");
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public Object clone() {
        XMLAnyCollectionMapping mapping = null;
        mapping = (XMLAnyCollectionMapping)super.clone();
        mapping.setContainerPolicy(this.getContainerPolicy());
        mapping.setField(this.getField());
        return mapping;
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareForChange");
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareObjects");
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, DistributedSession session) {
        throw DescriptorException.invalidMappingOperation(this, "fixObjectReferences");
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    @Override
    public DatabaseField getField() {
        return this.field;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.getField() != null) {
            this.setField(((ClassDescriptor)this.getDescriptor()).buildField(this.getField()));
        }
        if (this.valueConverter != null) {
            this.valueConverter.initialize(this, session);
        }
    }

    @Override
    public void iterate(DescriptorIterator iterator) {
        throw DescriptorException.invalidMappingOperation(this, "iterate");
    }

    public void setXPath(String xpath) {
        this.field = new XMLField(xpath);
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        throw DescriptorException.invalidMappingOperation(this, "mergeChangesIntoObject");
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUninitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        throw DescriptorException.invalidMappingOperation(this, "mergeIntoObject");
    }

    @Override
    public void setContainerPolicy(ContainerPolicy cp) {
        this.containerPolicy = cp;
    }

    public void setField(DatabaseField field) {
        this.field = (XMLField)field;
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        XMLRecord record = (XMLRecord)row;
        if (this.getField() != null) {
            Object nested = record.get(this.getField());
            if (nested instanceof Vector) {
                nested = ((Vector)nested).firstElement();
            }
            if (!(nested instanceof XMLRecord)) {
                return null;
            }
            record = (XMLRecord)nested;
        }
        return this.buildObjectValuesFromDOMRecord((DOMRecord)record, executionSession, sourceQuery, joinManager);
    }

    private Object buildObjectValuesFromDOMRecord(DOMRecord record, AbstractSession session, ObjectBuildingQuery query, JoinedAttributeManager joinManager) {
        Node root = record.getDOM();
        NodeList children = root.getChildNodes();
        ContainerPolicy cp = this.getContainerPolicy();
        Object container = null;
        if (this.reuseContainer) {
            Object currentObject = record.getCurrentObject();
            Object value = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
            container = value != null ? value : cp.containerInstance();
        } else {
            container = cp.containerInstance();
        }
        int length = children.getLength();
        Node next = null;
        if (length > 0) {
            next = record.getDOM().getFirstChild();
        }
        while (next != null) {
            Object objectValue = null;
            if (this.isUnmappedContent(next)) {
                if (next.getNodeType() == 3 && this.isMixedContent()) {
                    if (next.getNodeValue().trim().length() > 0) {
                        objectValue = next.getNodeValue();
                        objectValue = this.convertDataValueToObjectValue(objectValue, session, record.getUnmarshaller());
                        cp.addInto(objectValue, container, session);
                    }
                } else if (next.getNodeType() == 1) {
                    XMLDescriptor referenceDescriptor = null;
                    DOMRecord nestedRecord = (DOMRecord)record.buildNestedRow((Element)next);
                    if (!this.useXMLRoot) {
                        referenceDescriptor = this.getDescriptor(nestedRecord, session, null);
                        objectValue = this.buildObjectForNonXMLRoot(referenceDescriptor, this.getConverter(), query, record, nestedRecord, joinManager, session, next, container, cp);
                    } else {
                        String schemaType = ((Element)next).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                        QName schemaTypeQName = null;
                        XPathFragment frag = new XPathFragment();
                        if (schemaType != null && schemaType.length() > 0) {
                            frag.setXPath(schemaType);
                            if (frag.hasNamespace()) {
                                String prefix = frag.getPrefix();
                                XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
                                String url = xmlPlatform.resolveNamespacePrefix(next, prefix);
                                frag.setNamespaceURI(url);
                                schemaTypeQName = new QName(url, frag.getLocalName());
                            }
                            XMLContext xmlContext = nestedRecord.getUnmarshaller().getXMLContext();
                            referenceDescriptor = xmlContext.getDescriptorByGlobalType(frag);
                        }
                        if (referenceDescriptor == null) {
                            try {
                                QName qname = new QName(nestedRecord.getNamespaceURI(), nestedRecord.getLocalName());
                                referenceDescriptor = this.getDescriptor(nestedRecord, session, qname);
                            }
                            catch (XMLMarshalException xMLMarshalException) {
                                referenceDescriptor = null;
                            }
                            XMLDescriptor xmlReferenceDescriptor = referenceDescriptor;
                            if (referenceDescriptor != null && xmlReferenceDescriptor.isWrapper()) {
                                referenceDescriptor = null;
                            }
                        }
                        if (this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT || referenceDescriptor == null && this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT) {
                            Object objVal = this.buildObjectNoReferenceDescriptor(record, this.getConverter(), session, next, null, null);
                            if (referenceDescriptor != null) {
                                objVal = referenceDescriptor.wrapObjectInXMLRoot(objVal, next.getNamespaceURI(), next.getLocalName(), next.getPrefix(), false, record.isNamespaceAware(), record.getUnmarshaller());
                                cp.addInto(objVal, container, session);
                            } else {
                                cp.addInto((Object)this.buildXMLRoot(next, objVal), container, session);
                            }
                        } else if (referenceDescriptor != null) {
                            this.buildObjectAndWrapInXMLRoot(referenceDescriptor, this.getConverter(), query, record, nestedRecord, joinManager, session, next, container, cp);
                        } else {
                            XMLRoot rootValue = this.buildXMLRootForText(next, schemaTypeQName, this.getConverter(), session, record);
                            if (rootValue != null) {
                                cp.addInto((Object)rootValue, container, session);
                            }
                        }
                    }
                }
            }
            next = next.getNextSibling();
        }
        return container;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        DOMRecord record = (DOMRecord)row;
        Object attributeValue = this.getAttributeValueFromObject(object);
        Node root = record.getDOM();
        Document doc = record.getDocument();
        XMLField xmlRootField = null;
        if (attributeValue == null) {
            return;
        }
        if (this.field != null) {
            root = XPathEngine.getInstance().create((XMLField)this.getField(), record.getDOM(), session);
            DOMRecord rootRecord = new DOMRecord(root);
            rootRecord.setSession(session);
            rootRecord.setDocPresPolicy(record.getDocPresPolicy());
            rootRecord.setNamespaceResolver(record.getNamespaceResolver());
            rootRecord.setMarshaller(record.getMarshaller());
            record = rootRecord;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        ArrayList childNodes = this.getUnmappedChildNodes(record.getDOM().getChildNodes());
        Object iter = cp.iteratorFor(attributeValue);
        int childNodeCount = 0;
        boolean wasXMLRoot = false;
        if (iter != null) {
            while (cp.hasNext(iter) && childNodeCount < childNodes.size()) {
                DOMRecord nestedRecord;
                Object element = cp.next(iter, session);
                Object originalObject = element = this.convertObjectValueToDataValue(element, session, record.getMarshaller());
                Node nextChild = null;
                while (childNodeCount < childNodes.size()) {
                    Node nextPossible = (Node)childNodes.get(childNodeCount);
                    if (nextPossible.getNodeType() == 1 || nextPossible.getNodeType() == 3 || nextPossible.getNodeType() == 4) {
                        nextChild = nextPossible;
                        ++childNodeCount;
                        break;
                    }
                    ++childNodeCount;
                }
                if (nextChild == null) break;
                if (this.usesXMLRoot() && element instanceof XMLRoot) {
                    xmlRootField = new XMLField();
                    wasXMLRoot = true;
                    XPathFragment frag = new XPathFragment();
                    if (((XMLRoot)element).getNamespaceURI() != null) {
                        frag.setNamespaceURI(((XMLRoot)element).getNamespaceURI());
                    }
                    frag.setXPath(((XMLRoot)element).getLocalName());
                    xmlRootField.setXPathFragment(frag);
                    xmlRootField.setNamespaceResolver(record.getNamespaceResolver());
                    element = ((XMLRoot)element).getObject();
                }
                if (element instanceof String) {
                    if (wasXMLRoot && ((XMLRoot)originalObject).getNamespaceURI() != null) {
                        String prefix = record.getNamespaceResolver().resolveNamespaceURI(((XMLRoot)originalObject).getNamespaceURI());
                        if (prefix == null || prefix.length() == 0) {
                            xmlRootField.getXPathFragment().setGeneratedPrefix(true);
                            prefix = record.getNamespaceResolver().generatePrefix();
                        }
                        xmlRootField.getXPathFragment().setXPath(String.valueOf(prefix) + ':' + ((XMLRoot)originalObject).getLocalName());
                    }
                    if (xmlRootField != null) {
                        XPathEngine.getInstance().create(xmlRootField, root, element, session);
                        continue;
                    }
                    Text textNode = doc.createTextNode((String)element);
                    root.replaceChild(textNode, nextChild);
                    continue;
                }
                if (element instanceof Node) {
                    Node importedCopy = doc.importNode((Node)element, true);
                    root.replaceChild(importedCopy, nextChild);
                    continue;
                }
                XMLDescriptor referenceDescriptor = (XMLDescriptor)session.getDescriptor(element.getClass());
                if (wasXMLRoot && ((XMLRoot)originalObject).getNamespaceURI() != null) {
                    String prefix = referenceDescriptor.getNonNullNamespaceResolver().resolveNamespaceURI(((XMLRoot)originalObject).getNamespaceURI());
                    if (prefix == null || prefix.length() == 0) {
                        prefix = record.getNamespaceResolver().resolveNamespaceURI(((XMLRoot)originalObject).getNamespaceURI());
                    }
                    if (prefix == null || prefix.length() == 0) {
                        xmlRootField.getXPathFragment().setGeneratedPrefix(true);
                        prefix = record.getNamespaceResolver().generatePrefix();
                    }
                    xmlRootField.getXPathFragment().setXPath(String.valueOf(prefix) + ':' + ((XMLRoot)originalObject).getLocalName());
                }
                if ((nestedRecord = (DOMRecord)this.buildCompositeRow(element, session, referenceDescriptor, row, xmlRootField, element, wasXMLRoot)) == null || nestedRecord.getDOM() == nextChild) continue;
                root.replaceChild(nestedRecord.getDOM(), nextChild);
            }
        }
        if (childNodeCount < childNodes.size()) {
            int i = childNodeCount;
            while (i < childNodes.size()) {
                Node child = (Node)childNodes.get(i);
                if (child.getNodeType() == 1 || child.getNodeType() == 3 || child.getNodeType() == 4) {
                    root.removeChild(child);
                }
                ++i;
            }
        }
        if (iter != null && cp.hasNext(iter)) {
            while (cp.hasNext(iter)) {
                Object element = cp.next(iter, session);
                this.writeSingleValue(element, object, record, session);
            }
        }
    }

    @Override
    public void writeSingleValue(Object element, Object parent, XMLRecord row, AbstractSession session) {
        XMLField xmlRootField = null;
        Object originalObject = element;
        DOMRecord record = (DOMRecord)row;
        Node root = record.getDOM();
        Document doc = row.getDocument();
        boolean wasXMLRoot = false;
        if (this.usesXMLRoot() && element instanceof XMLRoot) {
            wasXMLRoot = true;
            xmlRootField = new XMLField();
            XPathFragment frag = new XPathFragment();
            if (((XMLRoot)element).getNamespaceURI() != null) {
                frag.setNamespaceURI(((XMLRoot)element).getNamespaceURI());
            }
            frag.setLocalName(((XMLRoot)element).getLocalName());
            xmlRootField.setXPathFragment(frag);
            xmlRootField.setNamespaceResolver(row.getNamespaceResolver());
            element = ((XMLRoot)element).getObject();
        }
        if (element instanceof String) {
            this.writeSimpleValue(xmlRootField, element, originalObject, record, doc, root, wasXMLRoot, session);
        } else if (element instanceof Node) {
            Node importedCopy = doc.importNode((Node)element, true);
            root.appendChild(importedCopy);
        } else {
            DOMRecord nestedRecord;
            XMLDescriptor referenceDescriptor = (XMLDescriptor)session.getDescriptor(element.getClass());
            if (referenceDescriptor == null) {
                this.writeSimpleValue(xmlRootField, element, originalObject, record, doc, root, wasXMLRoot, session);
                return;
            }
            if (wasXMLRoot && ((XMLRoot)originalObject).getNamespaceURI() != null) {
                String prefix = referenceDescriptor.getNonNullNamespaceResolver().resolveNamespaceURI(((XMLRoot)originalObject).getNamespaceURI());
                if (prefix == null || prefix.length() == 0) {
                    prefix = record.getNamespaceResolver().resolveNamespaceURI(((XMLRoot)originalObject).getNamespaceURI());
                }
                if (prefix == null || prefix.length() == 0) {
                    xmlRootField.getXPathFragment().setGeneratedPrefix(true);
                    prefix = record.getNamespaceResolver().generatePrefix();
                }
                xmlRootField.getXPathFragment().setXPath(String.valueOf(prefix) + ':' + ((XMLRoot)originalObject).getLocalName());
            }
            if ((nestedRecord = (DOMRecord)this.buildCompositeRow(element, session, referenceDescriptor, row, xmlRootField, originalObject, wasXMLRoot)) != null) {
                root.appendChild(nestedRecord.getDOM());
            }
        }
    }

    private void writeSimpleValue(XMLField xmlRootField, Object element, Object originalObject, DOMRecord record, Document doc, Node root, boolean wasXMLRoot, AbstractSession session) {
        if (wasXMLRoot && ((XMLRoot)originalObject).getNamespaceURI() != null) {
            String prefix = record.getNamespaceResolver().resolveNamespaceURI(((XMLRoot)originalObject).getNamespaceURI());
            if (prefix == null || prefix.length() == 0) {
                xmlRootField.getXPathFragment().setGeneratedPrefix(true);
                prefix = record.getNamespaceResolver().generatePrefix();
            }
            xmlRootField.getXPathFragment().setXPath(String.valueOf(prefix) + ':' + ((XMLRoot)originalObject).getLocalName());
        }
        if (xmlRootField != null) {
            xmlRootField.setNamespaceResolver(record.getNamespaceResolver());
            QName qname = ((XMLRoot)originalObject).getSchemaType();
            if (qname != null && !qname.equals(XMLConstants.STRING_QNAME)) {
                xmlRootField.setSchemaType(qname);
                xmlRootField.setIsTypedTextField(true);
                xmlRootField.addJavaConversion(((XMLRoot)originalObject).getObject().getClass(), qname);
            }
            XPathEngine.getInstance().create(xmlRootField, root, element, session);
        } else {
            Text textNode = doc.createTextNode((String)element);
            root.appendChild(textNode);
        }
    }

    protected AbstractRecord buildCompositeRow(Object attributeValue, AbstractSession session, XMLDescriptor referenceDescriptor, AbstractRecord parentRow, DatabaseField field, Object originalObject, boolean wasXMLRoot) {
        if (field == null && referenceDescriptor != null && referenceDescriptor.getDefaultRootElement() != null) {
            field = referenceDescriptor.buildField(referenceDescriptor.getDefaultRootElement());
        }
        if (field != null && referenceDescriptor != null) {
            ((XMLRecord)parentRow).setLeafElementType(referenceDescriptor.getDefaultRootElementType());
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)referenceDescriptor.getObjectBuilder();
            XMLRecord child = (XMLRecord)objectBuilder.createRecordFor(attributeValue, (XMLField)field, (XMLRecord)parentRow, this);
            child.setNamespaceResolver(((XMLRecord)parentRow).getNamespaceResolver());
            objectBuilder.buildIntoNestedRow(child, originalObject, attributeValue, session, referenceDescriptor, (XMLField)field, wasXMLRoot);
            return child;
        }
        return null;
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public Vector getFields() {
        return this.collectFields();
    }

    @Override
    public void useCollectionClass(Class concreteContainerClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteContainerClass));
    }

    @Override
    public void useMapClass(Class concreteContainerClass, String methodName) {
        throw DescriptorException.invalidMappingOperation(this, "useMapClass");
    }

    @Override
    public void useMapClassName(String concreteContainerClass, String methodName) {
        throw DescriptorException.invalidMappingOperation(this, "useMapClass");
    }

    @Override
    public void useCollectionClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteContainerClassName));
    }

    @Override
    public void useListClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new ListContainerPolicy(concreteContainerClassName));
    }

    public void setUseXMLRoot(boolean useXMLRoot) {
        this.useXMLRoot = useXMLRoot;
    }

    @Override
    public boolean usesXMLRoot() {
        return this.useXMLRoot;
    }

    @Override
    public boolean isMixedContent() {
        return this.mixedContent;
    }

    public void setMixedContent(boolean mixed) {
        this.mixedContent = mixed;
    }

    private boolean isUnmappedContent(Node node) {
        if (!this.areOtherMappingInThisContext) {
            return true;
        }
        XMLDescriptor parentDesc = (XMLDescriptor)this.getDescriptor();
        XMLField field = (XMLField)this.getField();
        Iterator<DatabaseMapping> mappings = parentDesc.getMappings().iterator();
        int mappingsInContext = 0;
        while (mappings.hasNext()) {
            XMLField nextField;
            XPathFragment frag;
            DatabaseMapping next = mappings.next();
            if (next != this && (frag = this.getFragmentToCompare(nextField = (XMLField)next.getField(), field)) != null) {
                ++mappingsInContext;
                if ((node.getNodeType() == 3 || node.getNodeType() == 4) && frag.nameIsText()) {
                    return false;
                }
                if (node.getNodeType() == 1) {
                    String nodeNS = node.getNamespaceURI();
                    String fragNS = frag.getNamespaceURI();
                    String nodeLocalName = node.getLocalName();
                    String fragLocalName = frag.getLocalName();
                    if ((nodeNS == fragNS || nodeNS != null && fragNS != null && nodeNS.equals(fragNS)) && (nodeLocalName == fragLocalName || nodeLocalName != null && fragLocalName != null && nodeLocalName.equals(fragLocalName))) {
                        return false;
                    }
                }
            }
            if (mappingsInContext != 0) continue;
            this.areOtherMappingInThisContext = false;
        }
        return true;
    }

    private XPathFragment getFragmentToCompare(XMLField field, XMLField context) {
        if (field == null) {
            return null;
        }
        if (context == null) {
            return field.getXPathFragment();
        }
        XPathFragment fieldFrag = field.getXPathFragment();
        for (XPathFragment contextFrag = context.getXPathFragment(); fieldFrag != null && contextFrag != null; contextFrag = contextFrag.getNextFragment(), fieldFrag = fieldFrag.getNextFragment()) {
            if (fieldFrag.equals(contextFrag)) {
                if (contextFrag.getNextFragment() != null) continue;
                return fieldFrag.getNextFragment();
            }
            return null;
        }
        return null;
    }

    private ArrayList getUnmappedChildNodes(NodeList nodes) {
        ArrayList<Node> unmappedNodes = new ArrayList<Node>();
        int length = nodes.getLength();
        int i = 0;
        while (i < length) {
            Node next = nodes.item(i);
            if (this.isUnmappedContent(next)) {
                unmappedNodes.add(next);
            }
            ++i;
        }
        return unmappedNodes;
    }

    @Override
    public boolean isCollectionMapping() {
        return true;
    }

    public void setConverter(XMLConverter conv) {
        this.valueConverter = conv;
    }

    public XMLConverter getConverter() {
        return this.valueConverter;
    }

    @Override
    public boolean isWhitespacePreservedForMixedContent() {
        return this.isWhitespacePreservedForMixedContent;
    }

    public void setPreserveWhitespaceForMixedContent(boolean preserveWhitespace) {
        this.isWhitespacePreservedForMixedContent = preserveWhitespace;
    }

    @Override
    public boolean getReuseContainer() {
        return this.reuseContainer;
    }

    @Override
    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.defaultEmptyContainer;
    }

    @Override
    public void setDefaultEmptyContainer(boolean defaultEmptyContainer) {
        this.defaultEmptyContainer = defaultEmptyContainer;
    }

    @Override
    public AbstractNullPolicy getWrapperNullPolicy() {
        return this.wrapperNullPolicy;
    }

    @Override
    public void setWrapperNullPolicy(AbstractNullPolicy policy) {
        this.wrapperNullPolicy = policy;
    }

    @Override
    public Object convertObjectValueToDataValue(Object value, Session session, XMLMarshaller marshaller) {
        if (this.valueConverter != null) {
            return this.valueConverter.convertObjectValueToDataValue(value, session, marshaller);
        }
        return value;
    }

    @Override
    public Object convertDataValueToObjectValue(Object fieldValue, Session session, XMLUnmarshaller unmarshaller) {
        if (this.valueConverter != null) {
            return this.valueConverter.convertDataValueToObjectValue(fieldValue, session, unmarshaller);
        }
        return fieldValue;
    }
}

