/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.net.URI;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.persistence.jpa.rs.AbstractResource;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;

@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
@Path(value="/{context}/query/")
public class QueryResource
extends AbstractResource {
    @POST
    @Path(value="{name}")
    @Produces(value={"application/octet-stream"})
    public Response namedQueryUpdate(@PathParam(value="context") String persistenceUnit, @PathParam(value="name") String name, @Context HttpHeaders hh, @Context UriInfo ui) {
        return this.namedQueryUpdate(persistenceUnit, name, hh, ui, ui.getBaseUri());
    }

    protected Response namedQueryUpdate(String persistenceUnit, String name, HttpHeaders hh, UriInfo ui, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Object result = app.queryExecuteUpdate(QueryResource.getParameterMap(ui, persistenceUnit), name, QueryResource.getParameterMap(ui, name), QueryResource.getHintMap(ui));
        return Response.ok((Object)new StreamingOutputMarshaller(app, (Object)result.toString(), hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{name}")
    public Response namedQuery(@PathParam(value="context") String persistenceUnit, @PathParam(value="name") String name, @Context HttpHeaders hh, @Context UriInfo ui) {
        return this.namedQuery(persistenceUnit, name, hh, ui, ui.getBaseUri());
    }

    protected Response namedQuery(String persistenceUnit, String name, HttpHeaders hh, UriInfo ui, URI baseURI) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, baseURI, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List result = app.queryMultipleResults(QueryResource.getParameterMap(ui, persistenceUnit), name, QueryResource.getParameterMap(ui, name), QueryResource.getHintMap(ui));
        return Response.ok((Object)new StreamingOutputMarshaller(app, (Object)result, hh.getAcceptableMediaTypes())).build();
    }
}

